/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.CharTypes;
import io.vertx.core.json.EncodeException;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JsonCodec {
    private static final JsonFactory factory = new JsonFactory();
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    private static final int[] ESCAPE_CODES = CharTypes.get7BitOutputEscapes();

    private static void writeUnicodeEscape(JsonGenerator gen, char c) throws IOException {
        gen.writeRaw('\\');
        gen.writeRaw('u');
        gen.writeRaw(HEX_CHARS[c >> 12 & 0xF]);
        gen.writeRaw(HEX_CHARS[c >> 8 & 0xF]);
        gen.writeRaw(HEX_CHARS[c >> 4 & 0xF]);
        gen.writeRaw(HEX_CHARS[c & 0xF]);
    }

    private static void writeShortEscape(JsonGenerator gen, char c) throws IOException {
        gen.writeRaw('\\');
        gen.writeRaw(c);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String encode(String[] messages) throws EncodeException {
        StringWriter sw = new StringWriter();
        try (JsonGenerator gen = factory.createGenerator(sw);){
            gen.writeStartArray();
            boolean first2 = true;
            String[] object = messages;
            int n = object.length;
            int n2 = 0;
            while (true) {
                int n3;
                char[] cArray;
                if (n2 < n) {
                    String message = object[n2];
                    if (first2) {
                        first2 = false;
                    } else {
                        gen.writeRaw(',');
                    }
                    gen.writeRaw('\"');
                    cArray = message.toCharArray();
                    n3 = cArray.length;
                } else {
                    gen.writeEndArray();
                    gen.close();
                    String string2 = sw.toString();
                    return string2;
                }
                for (int i = 0; i < n3; ++i) {
                    int code;
                    char c = cArray[i];
                    if (c >= '\u0080') {
                        JsonCodec.writeUnicodeEscape(gen, c);
                        continue;
                    }
                    int n4 = code = c < ESCAPE_CODES.length ? ESCAPE_CODES[c] : 0;
                    if (code == 0) {
                        gen.writeRaw(c);
                        continue;
                    }
                    if (code == -1) {
                        JsonCodec.writeUnicodeEscape(gen, c);
                        continue;
                    }
                    JsonCodec.writeShortEscape(gen, (char)code);
                }
                gen.writeRaw('\"');
                ++n2;
            }
        }
        catch (Exception e2) {
            throw new EncodeException("Failed to encode as JSON", e2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> decodeValues(String messages) {
        List<String> result2 = null;
        try (JsonParser parser = factory.createParser(messages);){
            JsonToken jsonToken = parser.nextToken();
            if (jsonToken == JsonToken.START_ARRAY) {
                while (parser.nextToken() != JsonToken.END_ARRAY) {
                    if (result2 == null) {
                        result2 = new ArrayList();
                    }
                    result2.add(parser.getValueAsString());
                }
            } else if (jsonToken == JsonToken.VALUE_STRING) {
                result2 = Collections.singletonList(parser.getValueAsString());
            }
            List<String> list = result2 != null ? result2 : Collections.emptyList();
            return list;
        }
        catch (Exception ignore) {
            return null;
        }
    }
}

