/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import io.vertx.ext.web.handler.sockjs.impl.BaseTransport;
import io.vertx.ext.web.handler.sockjs.impl.SockJSSession;

class EventSourceTransport
extends BaseTransport {
    private static final Logger LOG = LoggerFactory.getLogger(EventSourceTransport.class);
    private final Handler<SockJSSocket> sockHandler;

    EventSourceTransport(Vertx vertx, Router router2, LocalMap<String, SockJSSession> sessions, SockJSHandlerOptions options2, Handler<SockJSSocket> sockHandler) {
        super(vertx, sessions, options2);
        this.sockHandler = sockHandler;
        String eventSourceRE = "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/eventsource";
        router2.getWithRegex(eventSourceRE).handler(this::handleGet);
    }

    private void handleGet(RoutingContext ctx) {
        String sessionID = ctx.request().getParam("param0");
        SockJSSession session = this.getSession(ctx, this.options, sessionID, this.sockHandler);
        HttpServerRequest req = ctx.request();
        session.register(req, new EventSourceListener(this.options.getMaxBytesStreaming(), ctx, session));
    }

    private class EventSourceListener
    extends BaseTransport.BaseListener {
        final int maxBytesStreaming;
        boolean headersWritten;
        int bytesSent;

        EventSourceListener(int maxBytesStreaming, RoutingContext rc, SockJSSession session) {
            super(rc, session);
            this.maxBytesStreaming = maxBytesStreaming;
            this.addCloseHandler(rc.response(), session);
        }

        @Override
        public void sendFrame(String body, Handler<AsyncResult<Void>> handler) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("EventSource, sending frame");
            }
            if (!this.headersWritten) {
                this.rc.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/event-stream");
                BaseTransport.setNoCacheHeaders(this.rc);
                BaseTransport.setJSESSIONID(EventSourceTransport.this.options, this.rc);
                this.rc.response().setChunked(true).write("\r\n");
                this.headersWritten = true;
            }
            String sb = "data: " + body + "\r\n\r\n";
            Buffer buff = Buffer.buffer(sb);
            this.rc.response().write(buff, handler);
            this.bytesSent += buff.length();
            if (this.bytesSent >= this.maxBytesStreaming) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("More than maxBytes sent so closing connection");
                }
                this.close();
            }
        }

        @Override
        public void close() {
            if (!this.closed) {
                try {
                    this.session.resetListener();
                    this.rc.response().end();
                    this.rc.response().close();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                this.closed = true;
            }
        }
    }
}

