/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.LanguageHeader;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.common.template.TemplateEngine;
import io.vertx.ext.web.handler.TemplateHandler;
import io.vertx.ext.web.impl.Utils;
import java.util.Locale;

public class TemplateHandlerImpl
implements TemplateHandler {
    private final TemplateEngine engine;
    private final String templateDirectory;
    private final String contentType;
    private String indexTemplate;

    public TemplateHandlerImpl(TemplateEngine engine2, String templateDirectory, String contentType) {
        this.engine = engine2;
        this.templateDirectory = templateDirectory == null || templateDirectory.isEmpty() ? "." : templateDirectory;
        this.contentType = contentType;
        this.indexTemplate = "index";
    }

    @Override
    public void handle(RoutingContext context) {
        String file2 = Utils.pathOffset(context.normalizedPath(), context);
        if (file2.endsWith("/") && null != this.indexTemplate) {
            file2 = file2 + this.indexTemplate;
        }
        if (this.templateDirectory == null || "".equals(this.templateDirectory)) {
            file2 = file2.substring(1);
        }
        if (!context.data().containsKey("lang")) {
            for (LanguageHeader acceptableLocale : context.acceptableLanguages()) {
                try {
                    Locale.forLanguageTag(acceptableLocale.value());
                }
                catch (RuntimeException e2) {
                    continue;
                }
                context.data().put("lang", acceptableLocale.value());
                break;
            }
        }
        if (!context.request().isEnded()) {
            context.request().pause();
        }
        this.engine.render(new JsonObject(context.data()), this.templateDirectory + file2, res -> {
            if (res.succeeded()) {
                if (!context.request().isEnded()) {
                    context.request().resume();
                }
                context.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)this.contentType).end((Buffer)res.result());
            } else {
                if (!context.request().isEnded()) {
                    context.request().resume();
                }
                context.fail(res.cause());
            }
        });
    }

    @Override
    public TemplateHandler setIndexTemplate(String indexTemplate) {
        this.indexTemplate = indexTemplate;
        return this;
    }
}

