/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.CookieSameSite;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.handler.impl.UserHolder;
import io.vertx.ext.web.impl.RoutingContextInternal;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.ext.web.sstore.impl.SessionInternal;

public class SessionHandlerImpl
implements SessionHandler {
    public static final String SESSION_USER_HOLDER_KEY = "__vertx.userHolder";
    public static final String SESSION_FLUSHED_KEY = "__vertx.session-flushed";
    public static final String SESSION_STOREUSER_KEY = "__vertx.session-storeuser";
    private static final Logger LOG = LoggerFactory.getLogger(SessionHandlerImpl.class);
    private final SessionStore sessionStore;
    private String sessionCookieName = "vertx-web.session";
    private String sessionCookiePath = "/";
    private long sessionTimeout = 1800000L;
    private boolean nagHttps = true;
    private boolean sessionCookieSecure = false;
    private boolean sessionCookieHttpOnly = false;
    private int minLength = 16;
    private boolean lazySession = false;
    private long cookieMaxAge = -1L;
    private boolean cookieless;
    private CookieSameSite cookieSameSite;

    public SessionHandlerImpl(SessionStore sessionStore) {
        this.sessionStore = sessionStore;
    }

    @Override
    public SessionHandler setSessionTimeout(long timeout) {
        this.sessionTimeout = timeout;
        return this;
    }

    @Override
    public SessionHandler setNagHttps(boolean nag) {
        this.nagHttps = nag;
        return this;
    }

    @Override
    public SessionHandler setCookieSecureFlag(boolean secure) {
        this.sessionCookieSecure = secure;
        return this;
    }

    @Override
    public SessionHandler setCookieHttpOnlyFlag(boolean httpOnly) {
        this.sessionCookieHttpOnly = httpOnly;
        return this;
    }

    @Override
    public SessionHandler setSessionCookieName(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
        return this;
    }

    @Override
    public SessionHandler setSessionCookiePath(String sessionCookiePath) {
        this.sessionCookiePath = sessionCookiePath;
        return this;
    }

    @Override
    public SessionHandler setMinLength(int minLength) {
        this.minLength = minLength;
        return this;
    }

    @Override
    public SessionHandler setCookieSameSite(CookieSameSite policy) {
        this.cookieSameSite = policy;
        return this;
    }

    @Override
    public SessionHandler setLazySession(boolean lazySession) {
        this.lazySession = lazySession;
        return this;
    }

    @Override
    public SessionHandler setCookieMaxAge(long cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
        return this;
    }

    @Override
    public SessionHandler setCookieless(boolean cookieless) {
        this.cookieless = cookieless;
        return this;
    }

    @Override
    public Future<Void> flush(RoutingContext context, boolean ignoreStatus) {
        return this.flush(context, false, ignoreStatus);
    }

    private void setCookieProperties(Cookie cookie, boolean expired) {
        cookie.setPath(this.sessionCookiePath);
        cookie.setSecure(this.sessionCookieSecure);
        cookie.setHttpOnly(this.sessionCookieHttpOnly);
        cookie.setSameSite(this.cookieSameSite);
        if (!expired && this.cookieMaxAge >= 0L) {
            cookie.setMaxAge(this.cookieMaxAge);
        }
    }

    private Future<Void> flush(RoutingContext context, boolean skipCrc, boolean ignoreStatus) {
        Cookie expiredCookie;
        boolean sessionUsed = context.isSessionAccessed();
        Session session = context.session();
        ContextInternal ctx = (ContextInternal)context.vertx().getOrCreateContext();
        if (session == null) {
            return ctx.succeededFuture();
        }
        if (!session.isDestroyed()) {
            int currentStatusCode = context.response().getStatusCode();
            if (ignoreStatus || currentStatusCode >= 200 && currentStatusCode < 400) {
                Boolean storeUser = (Boolean)context.get(SESSION_STOREUSER_KEY);
                if (storeUser != null && storeUser.booleanValue() && context.user() != null) {
                    session.put(SESSION_USER_HOLDER_KEY, new UserHolder(context));
                }
                if (session.isRegenerated()) {
                    if (this.cookieless) {
                        session.setAccessed();
                    } else {
                        Cookie cookie = this.sessionCookie(context, session);
                        session.setAccessed();
                        cookie.setValue(session.value());
                        this.setCookieProperties(cookie, false);
                    }
                    return this.sessionStore.delete(session.oldId()).compose(delete -> this.sessionStore.put(session).onSuccess(put -> {
                        context.put(SESSION_FLUSHED_KEY, true);
                        if (session instanceof SessionInternal) {
                            ((SessionInternal)((Object)session)).flushed(skipCrc);
                        }
                    }));
                }
                if (!this.lazySession || sessionUsed) {
                    if (!this.cookieless) {
                        this.sessionCookie(context, session);
                    }
                    session.setAccessed();
                    return this.sessionStore.put(session).onSuccess(put -> {
                        context.put(SESSION_FLUSHED_KEY, true);
                        if (session instanceof SessionInternal) {
                            ((SessionInternal)((Object)session)).flushed(skipCrc);
                        }
                    });
                }
                return ctx.succeededFuture();
            }
            return ctx.succeededFuture();
        }
        if (!this.cookieless && (expiredCookie = context.response().removeCookie(this.sessionCookieName)) != null) {
            this.setCookieProperties(expiredCookie, true);
        }
        if (session.isRegenerated()) {
            return this.sessionStore.delete(session.oldId()).compose(delete -> this.sessionStore.delete(session.id()).onSuccess(delete2 -> context.put(SESSION_FLUSHED_KEY, true)));
        }
        return this.sessionStore.delete(session.id()).onSuccess(delete -> context.put(SESSION_FLUSHED_KEY, true));
    }

    @Override
    public void handle(RoutingContext context) {
        String sessionID;
        String uri;
        HttpServerRequest request = context.request();
        if (this.nagHttps && LOG.isDebugEnabled() && !(uri = request.absoluteURI()).startsWith("https:")) {
            LOG.debug("Using session cookies without https could make you susceptible to session hijacking: " + uri);
        }
        if ((sessionID = this.getSessionId(context)) != null && sessionID.length() > this.minLength) {
            if (!context.request().isEnded()) {
                context.request().pause();
            }
            ContextInternal ctx = (ContextInternal)context.vertx().getOrCreateContext();
            this.getSession(ctx, sessionID).onFailure(err -> {
                if (!context.request().isEnded()) {
                    context.request().resume();
                }
                context.fail((Throwable)err);
            }).onSuccess(session -> {
                if (session != null) {
                    ((RoutingContextInternal)context).setSession((Session)session);
                    UserHolder holder = (UserHolder)session.get(SESSION_USER_HOLDER_KEY);
                    if (holder != null) {
                        holder.refresh(context);
                    } else {
                        context.put(SESSION_STOREUSER_KEY, true);
                    }
                    this.addStoreSessionHandler(context);
                } else {
                    this.createNewSession(context);
                }
                if (!context.request().isEnded()) {
                    context.request().resume();
                }
                context.next();
            });
        } else {
            this.createNewSession(context);
            context.next();
        }
    }

    @Override
    public Session newSession(RoutingContext context) {
        Session session = this.sessionStore.createSession(this.sessionTimeout, this.minLength);
        ((RoutingContextInternal)context).setSession(session);
        if (!this.cookieless) {
            context.response().removeCookie(this.sessionCookieName, false);
        }
        context.put(SESSION_STOREUSER_KEY, true);
        this.flush(context, true, true).onFailure(err -> LOG.warn("Failed to flush the session to the underlying store", (Throwable)err));
        return session;
    }

    @Override
    public Future<Void> setUser(RoutingContext context, User user) {
        if (!this.cookieless) {
            context.response().removeCookie(this.sessionCookieName, false);
        }
        context.setUser(user);
        context.put(SESSION_STOREUSER_KEY, true);
        return this.flush(context, true, true);
    }

    private String getSessionId(RoutingContext context) {
        if (this.cookieless) {
            String path2 = context.normalizedPath();
            int s2 = -1;
            int e2 = -1;
            for (int i = 0; i < path2.length(); ++i) {
                if (path2.charAt(i) == '(') {
                    s2 = i + 1;
                    continue;
                }
                if (path2.charAt(i) != ')' || s2 == -1) continue;
                e2 = i;
                break;
            }
            if (s2 != -1 && e2 != -1 && s2 < e2) {
                return path2.substring(s2, e2);
            }
        } else {
            Cookie cookie = context.request().getCookie(this.sessionCookieName);
            if (cookie != null) {
                return cookie.getValue();
            }
        }
        return null;
    }

    private Future<Session> getSession(ContextInternal context, String sessionID) {
        return this.doGetSession(context, System.currentTimeMillis(), sessionID);
    }

    private Future<Session> doGetSession(ContextInternal context, long startTime, String sessionID) {
        return this.sessionStore.get(sessionID).compose(session -> {
            if (session == null) {
                PromiseInternal<Session> retry2 = context.promise();
                this.doGetSession(context.owner(), startTime, sessionID, retry2);
                return retry2.future();
            }
            return context.succeededFuture(session);
        });
    }

    private void doGetSession(Vertx vertx, long startTime, String sessionID, Handler<AsyncResult<Session>> resultHandler) {
        this.sessionStore.get(sessionID).onComplete(res -> {
            if (res.succeeded() && res.result() == null && System.currentTimeMillis() - startTime < this.sessionStore.retryTimeout()) {
                vertx.setTimer(5L, v -> this.doGetSession(vertx, startTime, sessionID, resultHandler));
                return;
            }
            resultHandler.handle((AsyncResult<Session>)res);
        });
    }

    private void addStoreSessionHandler(RoutingContext context) {
        context.addHeadersEndHandler(v -> {
            Boolean flushed = (Boolean)context.get(SESSION_FLUSHED_KEY);
            if (flushed == null || !flushed.booleanValue()) {
                this.flush(context, true, false).onFailure(err -> LOG.warn("Failed to flush the session to the underlying store", (Throwable)err));
            }
        });
    }

    private void createNewSession(RoutingContext context) {
        Session session = this.sessionStore.createSession(this.sessionTimeout, this.minLength);
        ((RoutingContextInternal)context).setSession(session);
        if (!this.cookieless) {
            context.response().removeCookie(this.sessionCookieName, false);
        }
        context.put(SESSION_STOREUSER_KEY, true);
        this.addStoreSessionHandler(context);
    }

    private Cookie sessionCookie(RoutingContext context, Session session) {
        Cookie cookie = context.request().getCookie(this.sessionCookieName);
        if (cookie != null) {
            return cookie;
        }
        cookie = Cookie.cookie(this.sessionCookieName, session.value());
        this.setCookieProperties(cookie, false);
        context.response().addCookie(cookie);
        return cookie;
    }
}

