/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.ErrorHandler;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;

public class ErrorHandlerImpl
implements ErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorHandlerImpl.class);
    private final boolean displayExceptionDetails;
    private final String errorTemplate;

    public ErrorHandlerImpl(Vertx vertx, String errorTemplateName, boolean displayExceptionDetails) {
        Objects.requireNonNull(errorTemplateName);
        this.errorTemplate = vertx.fileSystem().readFileBlocking(errorTemplateName).toString(StandardCharsets.UTF_8);
        this.displayExceptionDetails = displayExceptionDetails;
    }

    @Override
    public void handle(RoutingContext context) {
        HttpServerResponse response = context.response();
        Throwable failure = context.failure();
        if (response.headWritten()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Response headers are already written", failure);
            }
            try {
                response.close();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return;
        }
        int errorCode = context.statusCode();
        if (errorCode == -1) {
            errorCode = 500;
        }
        response.setStatusCode(errorCode);
        this.answerWithError(context, errorCode);
    }

    private void answerWithError(RoutingContext context, int errorCode) {
        if (!this.sendErrorResponseMIME(context, errorCode) && !this.sendErrorAcceptMIME(context, errorCode)) {
            this.sendError(context, "text/plain", errorCode);
        }
    }

    private boolean sendErrorResponseMIME(RoutingContext context, int errorCode) {
        String mime = context.response().headers().get(HttpHeaders.CONTENT_TYPE);
        if (mime == null) {
            mime = context.getAcceptableContentType();
        }
        return mime != null && this.sendError(context, mime, errorCode);
    }

    private boolean sendErrorAcceptMIME(RoutingContext context, int errorCode) {
        List<MIMEHeader> acceptableMimes = context.parsedHeaders().accept();
        for (MIMEHeader accept : acceptableMimes) {
            if (!this.sendError(context, accept.value(), errorCode)) continue;
            return true;
        }
        return false;
    }

    private boolean sendError(RoutingContext context, String mime, int errorCode) {
        String title = "An unexpected error occurred";
        HttpServerResponse response = context.response();
        Throwable exception = context.failure();
        String errorMessage2 = this.displayExceptionDetails ? (exception == null ? response.getStatusMessage() : exception.getMessage()) : response.getStatusMessage();
        if (mime.startsWith("text/html")) {
            StringBuilder stack = null;
            if (exception != null && this.displayExceptionDetails) {
                stack = new StringBuilder();
                for (StackTraceElement elem : exception.getStackTrace()) {
                    stack.append("<li>").append(ErrorHandlerImpl.escapeHTML(elem.toString())).append("</li>");
                }
            }
            response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html");
            response.end(this.errorTemplate.replace("{title}", "An unexpected error occurred").replace("{errorCode}", Integer.toString(errorCode)).replace("{errorMessage}", ErrorHandlerImpl.htmlFormat(errorMessage2)).replace("{stackTrace}", stack == null ? "" : stack.toString()));
            return true;
        }
        if (mime.startsWith("application/json")) {
            JsonObject jsonError = new JsonObject();
            jsonError.put("error", new JsonObject().put("code", errorCode).put("message", errorMessage2));
            if (exception != null && this.displayExceptionDetails) {
                JsonArray stack = new JsonArray();
                for (StackTraceElement elem : exception.getStackTrace()) {
                    stack.add(elem.toString());
                }
                jsonError.put("stack", stack);
            }
            response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json");
            response.end(jsonError.encode());
            return true;
        }
        if (mime.startsWith("text/plain")) {
            response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain");
            StringBuilder sb = new StringBuilder();
            sb.append("Error ");
            sb.append(errorCode);
            sb.append(": ");
            sb.append(errorMessage2);
            if (exception != null && this.displayExceptionDetails) {
                for (StackTraceElement elem : exception.getStackTrace()) {
                    sb.append("\tat ").append(elem).append("\n");
                }
            }
            response.end(sb.toString());
            return true;
        }
        return false;
    }

    private static String escapeHTML(String s2) {
        StringBuilder out = new StringBuilder(Math.max(16, s2.length()));
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c > '\u007f' || c == '\"' || c == '\'' || c == '<' || c == '>' || c == '&') {
                out.append("&#");
                out.append((int)c);
                out.append(';');
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    private static String htmlFormat(String errorMessage2) {
        if (errorMessage2 == null) {
            return "";
        }
        String escaped = ErrorHandlerImpl.escapeHTML(errorMessage2);
        return escaped.replaceAll("\\r?\\n", "<br>");
    }
}

