/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.impl.FileUploadImpl;
import io.vertx.ext.web.impl.RoutingContextInternal;
import java.io.File;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class BodyHandlerImpl
implements BodyHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BodyHandlerImpl.class);
    private long bodyLimit = -1L;
    private boolean handleFileUploads;
    private String uploadsDir;
    private boolean mergeFormAttributes = true;
    private boolean deleteUploadedFilesOnEnd = false;
    private boolean isPreallocateBodyBuffer = false;
    private static final int DEFAULT_INITIAL_BODY_BUFFER_SIZE = 1024;

    public BodyHandlerImpl() {
        this(true, "file-uploads");
    }

    public BodyHandlerImpl(boolean handleFileUploads) {
        this(handleFileUploads, "file-uploads");
    }

    public BodyHandlerImpl(String uploadDirectory) {
        this(true, uploadDirectory);
    }

    private BodyHandlerImpl(boolean handleFileUploads, String uploadDirectory) {
        this.handleFileUploads = handleFileUploads;
        this.setUploadsDirectory(uploadDirectory);
    }

    @Override
    public void handle(RoutingContext context) {
        HttpServerRequest request = context.request();
        HttpServerResponse response = context.response();
        if (!((RoutingContextInternal)context).seenHandler(2)) {
            boolean hasTransferEncoding;
            ((RoutingContextInternal)context).visitHandler(2);
            long parsedContentLength = this.parseContentLengthHeader(request);
            boolean bl = hasTransferEncoding = request.version() == HttpVersion.HTTP_2 || request.headers().contains(HttpHeaders.TRANSFER_ENCODING);
            if (!hasTransferEncoding && parsedContentLength == -1L) {
                context.next();
                return;
            }
            if (this.bodyLimit != -1L && parsedContentLength != -1L && parsedContentLength > this.bodyLimit) {
                context.fail(413);
                return;
            }
            String expect = request.getHeader(HttpHeaders.EXPECT);
            if (expect != null) {
                if (expect.equalsIgnoreCase("100-continue")) {
                    if (request.version() != HttpVersion.HTTP_1_0) {
                        response.writeContinue();
                    }
                } else {
                    context.fail(417);
                    return;
                }
            }
            BHandler handler = new BHandler(context, this.isPreallocateBodyBuffer ? parsedContentLength : -1L);
            boolean ended = request.isEnded();
            if (!ended) {
                request.handler((Handler)handler).endHandler(handler::end).resume();
            }
        } else {
            if (this.mergeFormAttributes && request.isExpectMultipart()) {
                request.params().addAll(request.formAttributes());
            }
            context.next();
        }
    }

    @Override
    public BodyHandler setHandleFileUploads(boolean handleFileUploads) {
        this.handleFileUploads = handleFileUploads;
        return this;
    }

    @Override
    public BodyHandler setBodyLimit(long bodyLimit) {
        this.bodyLimit = bodyLimit;
        return this;
    }

    @Override
    public BodyHandler setUploadsDirectory(String uploadsDirectory) {
        this.uploadsDir = uploadsDirectory;
        return this;
    }

    @Override
    public BodyHandler setMergeFormAttributes(boolean mergeFormAttributes) {
        this.mergeFormAttributes = mergeFormAttributes;
        return this;
    }

    @Override
    public BodyHandler setDeleteUploadedFilesOnEnd(boolean deleteUploadedFilesOnEnd) {
        this.deleteUploadedFilesOnEnd = deleteUploadedFilesOnEnd;
        return this;
    }

    @Override
    public BodyHandler setPreallocateBodyBuffer(boolean isPreallocateBodyBuffer) {
        this.isPreallocateBodyBuffer = isPreallocateBodyBuffer;
        return this;
    }

    private long parseContentLengthHeader(HttpServerRequest request) {
        String contentLength = request.getHeader(HttpHeaders.CONTENT_LENGTH);
        if (contentLength == null || contentLength.isEmpty()) {
            return -1L;
        }
        try {
            long parsedContentLength = Long.parseLong(contentLength);
            return parsedContentLength < 0L ? -1L : parsedContentLength;
        }
        catch (NumberFormatException ex) {
            return -1L;
        }
    }

    private class BHandler
    implements Handler<Buffer> {
        private static final int MAX_PREALLOCATED_BODY_BUFFER_BYTES = 65535;
        final RoutingContext context;
        final long contentLength;
        Buffer body;
        boolean failed;
        final AtomicInteger uploadCount = new AtomicInteger();
        final AtomicBoolean cleanup = new AtomicBoolean(false);
        boolean ended;
        long uploadSize = 0L;
        final boolean isMultipart;
        final boolean isUrlEncoded;

        public BHandler(RoutingContext context, long contentLength) {
            this.context = context;
            this.contentLength = contentLength;
            if (contentLength != -1L) {
                this.initBodyBuffer();
            }
            List<FileUpload> fileUploads = context.fileUploads();
            String contentType = context.request().getHeader(HttpHeaders.CONTENT_TYPE);
            if (contentType == null) {
                this.isMultipart = false;
                this.isUrlEncoded = false;
            } else {
                String lowerCaseContentType = contentType.toLowerCase();
                this.isMultipart = lowerCaseContentType.startsWith(HttpHeaderValues.MULTIPART_FORM_DATA.toString());
                this.isUrlEncoded = lowerCaseContentType.startsWith(HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.toString());
            }
            if (this.isMultipart || this.isUrlEncoded) {
                context.request().setExpectMultipart(true);
                if (BodyHandlerImpl.this.handleFileUploads) {
                    this.makeUploadDir(context.vertx().fileSystem());
                }
                context.request().uploadHandler(upload -> {
                    long size;
                    if (BodyHandlerImpl.this.bodyLimit != -1L && upload.isSizeAvailable() && (size = this.uploadSize + upload.size()) > BodyHandlerImpl.this.bodyLimit) {
                        this.failed = true;
                        this.cancelAndCleanupFileUploads();
                        context.fail(413);
                        return;
                    }
                    if (BodyHandlerImpl.this.handleFileUploads) {
                        this.uploadCount.incrementAndGet();
                        String uploadedFileName = new File(BodyHandlerImpl.this.uploadsDir, UUID.randomUUID().toString()).getPath();
                        FileUploadImpl fileUpload = new FileUploadImpl(uploadedFileName, (HttpServerFileUpload)upload);
                        fileUploads.add(fileUpload);
                        Future<Void> fut = upload.streamToFileSystem(uploadedFileName);
                        fut.onComplete(ar -> {
                            if (fut.succeeded()) {
                                this.uploadEnded();
                            } else {
                                this.cancelAndCleanupFileUploads();
                                context.fail(ar.cause());
                            }
                        });
                    }
                });
            }
            context.request().exceptionHandler(t3 -> {
                this.cancelAndCleanupFileUploads();
                if (t3 instanceof DecoderException) {
                    context.fail(400, t3.getCause());
                } else {
                    context.fail((Throwable)t3);
                }
            });
        }

        private void initBodyBuffer() {
            int initialBodyBufferSize = this.contentLength < 0L ? 1024 : (this.contentLength > 65535L ? 65535 : (int)this.contentLength);
            if (BodyHandlerImpl.this.bodyLimit != -1L) {
                initialBodyBufferSize = (int)Math.min((long)initialBodyBufferSize, BodyHandlerImpl.this.bodyLimit);
            }
            this.body = Buffer.buffer(initialBodyBufferSize);
        }

        private void makeUploadDir(FileSystem fileSystem) {
            if (!fileSystem.existsBlocking(BodyHandlerImpl.this.uploadsDir)) {
                fileSystem.mkdirsBlocking(BodyHandlerImpl.this.uploadsDir);
            }
        }

        @Override
        public void handle(Buffer buff) {
            if (this.failed) {
                return;
            }
            this.uploadSize += (long)buff.length();
            if (BodyHandlerImpl.this.bodyLimit != -1L && this.uploadSize > BodyHandlerImpl.this.bodyLimit) {
                this.failed = true;
                this.cancelAndCleanupFileUploads();
                this.context.fail(413);
            } else if (!this.isMultipart) {
                if (this.body == null) {
                    this.initBodyBuffer();
                }
                this.body.appendBuffer(buff);
            }
        }

        void uploadEnded() {
            int count2 = this.uploadCount.decrementAndGet();
            if (this.ended && count2 == 0) {
                this.doEnd();
            }
        }

        void end(Void v) {
            this.ended = true;
            if (this.uploadCount.get() == 0) {
                this.doEnd();
            }
        }

        void doEnd() {
            if (this.failed) {
                this.cancelAndCleanupFileUploads();
                return;
            }
            if (BodyHandlerImpl.this.deleteUploadedFilesOnEnd) {
                this.context.addBodyEndHandler(x -> this.cancelAndCleanupFileUploads());
            }
            HttpServerRequest req = this.context.request();
            if (BodyHandlerImpl.this.mergeFormAttributes && req.isExpectMultipart()) {
                req.params().addAll(req.formAttributes());
            }
            ((RoutingContextInternal)this.context).setBody(this.body);
            this.body = null;
            this.context.next();
        }

        private void cancelAndCleanupFileUploads() {
            if (this.cleanup.compareAndSet(false, true) && BodyHandlerImpl.this.handleFileUploads) {
                for (FileUpload fileUpload : this.context.fileUploads()) {
                    FileSystem fileSystem = this.context.vertx().fileSystem();
                    if (fileUpload.cancel()) continue;
                    String uploadedFileName = fileUpload.uploadedFileName();
                    fileSystem.delete(uploadedFileName, deleteResult -> {
                        if (deleteResult.failed()) {
                            LOG.warn("Delete of uploaded file failed: " + uploadedFileName, deleteResult.cause());
                        }
                    });
                }
            }
        }
    }
}

