/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.auth.impl.Codec;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BasicAuthHandler;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.impl.HTTPAuthorizationHandler;
import java.nio.charset.StandardCharsets;

public class BasicAuthHandlerImpl
extends HTTPAuthorizationHandler<AuthenticationProvider>
implements BasicAuthHandler {
    public BasicAuthHandlerImpl(AuthenticationProvider authProvider, String realm) {
        super(authProvider, HTTPAuthorizationHandler.Type.BASIC, realm);
    }

    @Override
    public void authenticate(RoutingContext context, Handler<AsyncResult<User>> handler) {
        this.parseAuthorization(context, parseAuthorization -> {
            String spass;
            String suser;
            if (parseAuthorization.failed()) {
                handler.handle(Future.failedFuture(parseAuthorization.cause()));
                return;
            }
            try {
                String decoded = new String(Codec.base64Decode((String)parseAuthorization.result()), StandardCharsets.UTF_8);
                int colonIdx = decoded.indexOf(":");
                if (colonIdx != -1) {
                    suser = decoded.substring(0, colonIdx);
                    spass = decoded.substring(colonIdx + 1);
                } else {
                    suser = decoded;
                    spass = null;
                }
            }
            catch (RuntimeException e2) {
                handler.handle(Future.failedFuture(new HttpException(400, (Throwable)e2)));
                return;
            }
            this.authProvider.authenticate(new UsernamePasswordCredentials(suser, spass), (AsyncResult<User> authn) -> {
                if (authn.failed()) {
                    handler.handle(Future.failedFuture(new HttpException(401, authn.cause())));
                } else {
                    handler.handle((AsyncResult<User>)authn);
                }
            });
        });
    }
}

