/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.AuthorizationContext;
import io.vertx.ext.auth.authorization.AuthorizationProvider;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthorizationHandler;
import io.vertx.ext.web.handler.HttpException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiConsumer;

public class AuthorizationHandlerImpl
implements AuthorizationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationHandler.class);
    private static final int FORBIDDEN_CODE = 403;
    private static final HttpException FORBIDDEN_EXCEPTION = new HttpException(403);
    private final Authorization authorization;
    private final Collection<AuthorizationProvider> authorizationProviders;
    private BiConsumer<RoutingContext, AuthorizationContext> variableHandler;

    public AuthorizationHandlerImpl(Authorization authorization) {
        this.authorization = Objects.requireNonNull(authorization);
        this.authorizationProviders = new ArrayList<AuthorizationProvider>();
    }

    @Override
    public void handle(RoutingContext ctx) {
        User user = ctx.user();
        if (user == null) {
            ctx.fail(403, FORBIDDEN_EXCEPTION);
        } else {
            try {
                if (!ctx.request().isEnded()) {
                    ctx.request().pause();
                }
                AuthorizationContext authorizationContext = AuthorizationContext.create(user);
                if (this.variableHandler != null) {
                    this.variableHandler.accept(ctx, authorizationContext);
                }
                this.checkOrFetchAuthorizations(ctx, authorizationContext, this.authorizationProviders.iterator());
            }
            catch (RuntimeException e2) {
                if (!ctx.request().isEnded()) {
                    ctx.request().resume();
                }
                ctx.fail(e2);
            }
        }
    }

    @Override
    public AuthorizationHandler variableConsumer(BiConsumer<RoutingContext, AuthorizationContext> handler) {
        this.variableHandler = handler;
        return this;
    }

    private void checkOrFetchAuthorizations(RoutingContext ctx, AuthorizationContext authorizationContext, Iterator<AuthorizationProvider> providers) {
        if (this.authorization.match(authorizationContext)) {
            if (!ctx.request().isEnded()) {
                ctx.request().resume();
            }
            ctx.next();
            return;
        }
        User user = ctx.user();
        if (user == null || !providers.hasNext()) {
            if (!ctx.request().isEnded()) {
                ctx.request().resume();
            }
            ctx.fail(403, FORBIDDEN_EXCEPTION);
            return;
        }
        do {
            AuthorizationProvider provider2 = providers.next();
            if (user.authorizations().getProviderIds().contains(provider2.getId())) continue;
            provider2.getAuthorizations(ctx.user(), authorizationResult -> {
                if (authorizationResult.failed()) {
                    LOG.warn("An error occurred getting authorization - providerId: " + provider2.getId(), authorizationResult.cause());
                }
                this.checkOrFetchAuthorizations(ctx, authorizationContext, providers);
            });
            return;
        } while (providers.hasNext());
        if (!ctx.request().isEnded()) {
            ctx.request().resume();
        }
        ctx.fail(403, FORBIDDEN_EXCEPTION);
    }

    @Override
    public AuthorizationHandler addAuthorizationProvider(AuthorizationProvider authorizationProvider) {
        Objects.requireNonNull(authorizationProvider);
        this.authorizationProviders.add(authorizationProvider);
        return this;
    }
}

