/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.impl.http;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.impl.http.SimpleHttpResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import java.util.function.Function;

public final class SimpleHttpClient {
    private final HttpClient client;
    private final String userAgent;

    public SimpleHttpClient(Vertx vertx, String userAgent, HttpClientOptions options2) {
        this.client = vertx.createHttpClient(options2);
        this.userAgent = userAgent;
    }

    public Future<SimpleHttpResponse> fetch(HttpMethod method, String url, JsonObject headers, Buffer payload) {
        if (url == null || url.length() == 0) {
            return Future.failedFuture("Invalid url");
        }
        RequestOptions options2 = new RequestOptions().setMethod(method).setAbsoluteURI(url);
        if (this.userAgent != null) {
            options2.addHeader("User-Agent", this.userAgent);
        }
        if (headers != null) {
            for (Map.Entry<String, Object> kv : headers) {
                options2.addHeader(kv.getKey(), (String)kv.getValue());
            }
        }
        if (method != HttpMethod.POST && method != HttpMethod.PATCH && method != HttpMethod.PUT) {
            payload = null;
        }
        return this.makeRequest(options2, payload);
    }

    public static Buffer jsonToQuery(JsonObject json) {
        Buffer buffer = Buffer.buffer();
        try {
            for (Map.Entry<String, Object> kv : json) {
                if (buffer.length() != 0) {
                    buffer.appendByte((byte)38);
                }
                buffer.appendString(URLEncoder.encode(kv.getKey(), "UTF-8"));
                buffer.appendByte((byte)61);
                Object v = kv.getValue();
                if (v == null) continue;
                buffer.appendString(URLEncoder.encode(v.toString(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
        return buffer;
    }

    public static @Nullable JsonObject queryToJson(Buffer query) throws UnsupportedEncodingException {
        String[] pairs;
        if (query == null) {
            return null;
        }
        JsonObject json = new JsonObject();
        for (String pair2 : pairs = query.toString().split("&")) {
            JsonArray array2;
            String value;
            int idx = pair2.indexOf("=");
            String key2 = idx > 0 ? URLDecoder.decode(pair2.substring(0, idx), "UTF-8") : pair2;
            String string2 = value = idx > 0 && pair2.length() > idx + 1 ? URLDecoder.decode(pair2.substring(idx + 1), "UTF-8") : null;
            if (!json.containsKey(key2)) {
                json.put(key2, value);
                continue;
            }
            Object oldValue = json.getValue(key2);
            if (oldValue instanceof JsonArray) {
                array2 = (JsonArray)oldValue;
            } else {
                array2 = new JsonArray();
                array2.add(oldValue);
                json.put(key2, array2);
            }
            if (value == null) {
                array2.addNull();
                continue;
            }
            array2.add(value);
        }
        return json;
    }

    private Future<SimpleHttpResponse> makeRequest(RequestOptions options2, Buffer payload) {
        return this.client.request(options2).compose(req -> {
            Function<HttpClientResponse, Future> resultHandler = res -> res.body().compose(value -> {
                if (res.statusCode() < 200 || res.statusCode() >= 300) {
                    if (value == null || value.length() == 0) {
                        return Future.failedFuture(res.statusMessage());
                    }
                    return Future.failedFuture(res.statusMessage() + ": " + value);
                }
                return Future.succeededFuture(new SimpleHttpResponse(res.statusCode(), res.headers(), (Buffer)value));
            });
            if (payload != null) {
                return req.send(payload).compose(resultHandler);
            }
            return req.send().compose(resultHandler);
        });
    }
}

