/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.impl.hash;

import io.vertx.ext.auth.HashString;
import io.vertx.ext.auth.HashingAlgorithm;
import io.vertx.ext.auth.impl.Codec;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.Set;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PBKDF2
implements HashingAlgorithm {
    private static final int DEFAULT_ITERATIONS = 10000;
    private static final Set<String> DEFAULT_CONFIG = Collections.singleton("it");
    private final SecretKeyFactory skf;

    public PBKDF2() {
        try {
            this.skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("PBKDF2 is not available", nsae);
        }
    }

    @Override
    public String id() {
        return "pbkdf2";
    }

    @Override
    public Set<String> params() {
        return DEFAULT_CONFIG;
    }

    @Override
    public String hash(HashString hashString, String password) {
        int iterations;
        try {
            iterations = hashString.params() != null ? Integer.parseInt(hashString.params().get("it")) : 10000;
        }
        catch (RuntimeException e2) {
            iterations = 10000;
        }
        if (hashString.salt() == null) {
            throw new RuntimeException("hashString salt is null");
        }
        byte[] salt = Codec.base64Decode(hashString.salt());
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, iterations, 512);
        try {
            return Codec.base64EncodeWithoutPadding(this.skf.generateSecret(spec).getEncoded());
        }
        catch (InvalidKeySpecException ikse) {
            throw new RuntimeException(ikse);
        }
    }
}

