/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.authorization.impl;

import io.vertx.ext.auth.authorization.AuthorizationContext;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;

class VariableAwareExpression {
    private final String value;
    private final transient Function<AuthorizationContext, String>[] parts;
    private transient boolean hasVariable = false;

    public VariableAwareExpression(String value) {
        this.value = Objects.requireNonNull(value).trim();
        ArrayList<Function<AuthorizationContext, String>> tmpParts = new ArrayList<Function<AuthorizationContext, String>>();
        int currentPos = 0;
        while (currentPos != -1) {
            int closingCurlyBracePos;
            int openingCurlyBracePos = value.indexOf("{", currentPos);
            if (openingCurlyBracePos == -1) {
                if (currentPos >= value.length()) break;
                String authorizationPart = value.substring(currentPos, value.length() - currentPos);
                tmpParts.add(ctx -> authorizationPart);
                break;
            }
            if (openingCurlyBracePos > currentPos) {
                String authorizationPart = value.substring(currentPos, openingCurlyBracePos);
                tmpParts.add(ctx -> authorizationPart);
            }
            if ((closingCurlyBracePos = value.indexOf("}", currentPos + 1)) == -1) {
                throw new IllegalArgumentException("opening '{' without corresponding closing '}'");
            }
            if (closingCurlyBracePos - openingCurlyBracePos == 1) {
                throw new IllegalArgumentException("empty '{}' is not allowed");
            }
            String part = value.substring(openingCurlyBracePos, closingCurlyBracePos + 1);
            String variableName = value.substring(openingCurlyBracePos + 1, closingCurlyBracePos);
            this.hasVariable = true;
            tmpParts.add(ctx -> {
                String result2 = ctx.variables().get(variableName);
                if (result2 != null) {
                    return result2;
                }
                return part;
            });
            currentPos = closingCurlyBracePos + 1;
        }
        this.parts = (Function[])Array.newInstance(Function.class, tmpParts.size());
        for (int i = 0; i < tmpParts.size(); ++i) {
            this.parts[i] = (Function)tmpParts.get(i);
        }
    }

    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (obj2 == null) {
            return false;
        }
        if (!(obj2 instanceof VariableAwareExpression)) {
            return false;
        }
        VariableAwareExpression other = (VariableAwareExpression)obj2;
        return Objects.equals(this.value, other.value);
    }

    public boolean hasVariable() {
        return this.hasVariable;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public Function<AuthorizationContext, String>[] parts() {
        return this.parts;
    }

    public String resolve(AuthorizationContext context) {
        if (this.parts.length == 1) {
            return this.parts[0].apply(context);
        }
        if (this.parts.length > 1) {
            StringBuilder result2 = new StringBuilder();
            for (Function<AuthorizationContext, String> part : this.parts) {
                result2.append(part.apply(context));
            }
            return result2.toString();
        }
        return "";
    }
}

