/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.Authorizations;
import io.vertx.ext.auth.authorization.RoleBasedAuthorization;
import io.vertx.ext.auth.authorization.WildcardPermissionBasedAuthorization;
import io.vertx.ext.auth.authorization.impl.AuthorizationsImpl;
import io.vertx.ext.auth.impl.UserImpl;

@VertxGen
public interface User {
    public static User fromName(String username) {
        return User.create(new JsonObject().put("username", username));
    }

    public static User fromToken(String token2) {
        return User.create(new JsonObject().put("access_token", token2));
    }

    public static User create(JsonObject principal) {
        return User.create(principal, new JsonObject());
    }

    public static User create(JsonObject principal, JsonObject attributes) {
        return new UserImpl(principal, attributes);
    }

    default public @Nullable String subject() {
        JsonObject idToken;
        if (this.principal().containsKey("username")) {
            return this.principal().getString("username");
        }
        if (this.principal().containsKey("userHandle")) {
            return this.principal().getString("userHandle");
        }
        if (this.attributes().containsKey("idToken") && (idToken = this.attributes().getJsonObject("idToken")).containsKey("sub")) {
            return idToken.getString("sub");
        }
        return (String)this.get("sub");
    }

    public JsonObject attributes();

    default public boolean expired() {
        return this.expired(this.attributes().getInteger("leeway", 0));
    }

    default public boolean expired(int leeway) {
        Long nbf;
        Long iat;
        long now2 = System.currentTimeMillis() / 1000L;
        if (this.containsKey("exp") && now2 - (long)leeway >= this.attributes().getLong("exp", this.principal().getLong("exp", 0L))) {
            return true;
        }
        if (this.containsKey("iat") && (iat = this.attributes().getLong("iat", this.principal().getLong("iat", 0L))) > now2 + (long)leeway) {
            return true;
        }
        return this.containsKey("nbf") && (nbf = this.attributes().getLong("nbf", this.principal().getLong("nbf", 0L))) > now2 + (long)leeway;
    }

    default public <T> @Nullable T get(String key2) {
        if (this.attributes().containsKey("rootClaim")) {
            JsonObject rootClaim;
            try {
                rootClaim = this.attributes().getJsonObject(this.attributes().getString("rootClaim"));
            }
            catch (ClassCastException e2) {
                rootClaim = null;
            }
            if (rootClaim != null && rootClaim.containsKey(key2)) {
                return (T)rootClaim.getValue(key2);
            }
        }
        if (this.attributes().containsKey(key2)) {
            return (T)this.attributes().getValue(key2);
        }
        if (this.principal().containsKey(key2)) {
            return (T)this.principal().getValue(key2);
        }
        return null;
    }

    default public <T> @Nullable T getOrDefault(String key2, T defaultValue) {
        if (this.attributes().containsKey("rootClaim")) {
            JsonObject rootClaim;
            try {
                rootClaim = this.attributes().getJsonObject(this.attributes().getString("rootClaim"));
            }
            catch (ClassCastException e2) {
                rootClaim = null;
            }
            if (rootClaim != null && rootClaim.containsKey(key2)) {
                return (T)rootClaim.getValue(key2);
            }
        }
        if (this.attributes().containsKey(key2)) {
            return (T)this.attributes().getValue(key2);
        }
        if (this.principal().containsKey(key2)) {
            return (T)this.principal().getValue(key2);
        }
        return defaultValue;
    }

    default public boolean containsKey(String key2) {
        if (this.attributes().containsKey("rootClaim")) {
            JsonObject rootClaim;
            try {
                rootClaim = this.attributes().getJsonObject(this.attributes().getString("rootClaim"));
            }
            catch (ClassCastException e2) {
                rootClaim = null;
            }
            if (rootClaim != null && rootClaim.containsKey(key2)) {
                return true;
            }
        }
        return this.attributes().containsKey(key2) || this.principal().containsKey(key2);
    }

    default public Authorizations authorizations() {
        return new AuthorizationsImpl();
    }

    @Fluent
    @Deprecated
    public User isAuthorized(Authorization var1, Handler<AsyncResult<Boolean>> var2);

    @Fluent
    @Deprecated
    default public User isAuthorized(String authority, Handler<AsyncResult<Boolean>> resultHandler) {
        return this.isAuthorized(authority.startsWith("role:") ? RoleBasedAuthorization.create(authority.substring(5)) : WildcardPermissionBasedAuthorization.create(authority), resultHandler);
    }

    @Deprecated
    default public Future<Boolean> isAuthorized(Authorization authority) {
        Promise<Boolean> promise2 = Promise.promise();
        this.isAuthorized(authority, promise2);
        return promise2.future();
    }

    @Deprecated
    default public Future<Boolean> isAuthorized(String authority) {
        return this.isAuthorized(authority.startsWith("role:") ? RoleBasedAuthorization.create(authority.substring(5)) : WildcardPermissionBasedAuthorization.create(authority));
    }

    @Fluent
    @Deprecated
    default public User clearCache() {
        this.authorizations().clear();
        return this;
    }

    public JsonObject principal();

    @Deprecated
    public void setAuthProvider(AuthProvider var1);

    @Fluent
    public User merge(User var1);

    default public boolean hasAmr(String value) {
        if (this.principal().containsKey("amr")) {
            return this.principal().getJsonArray("amr").contains(value);
        }
        return false;
    }
}

