/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.ext.auth.PubSecKeyOptions;
import java.util.Base64;
import java.util.Map;

public class PubSecKeyOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, PubSecKeyOptions obj2) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "algorithm": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setAlgorithm((String)member.getValue());
                    break;
                }
                case "buffer": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setBuffer(Buffer.buffer(BASE64_DECODER.decode((String)member.getValue())));
                    break;
                }
                case "certificate": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setCertificate((Boolean)member.getValue());
                    break;
                }
                case "id": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setId((String)member.getValue());
                    break;
                }
                case "publicKey": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setPublicKey((String)member.getValue());
                    break;
                }
                case "secretKey": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setSecretKey((String)member.getValue());
                    break;
                }
                case "symmetric": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setSymmetric((Boolean)member.getValue());
                }
            }
        }
    }

    public static void toJson(PubSecKeyOptions obj2, JsonObject json) {
        PubSecKeyOptionsConverter.toJson(obj2, json.getMap());
    }

    public static void toJson(PubSecKeyOptions obj2, Map<String, Object> json) {
        if (obj2.getAlgorithm() != null) {
            json.put("algorithm", obj2.getAlgorithm());
        }
        if (obj2.getBuffer() != null) {
            json.put("buffer", BASE64_ENCODER.encodeToString(obj2.getBuffer().getBytes()));
        }
        json.put("certificate", obj2.isCertificate());
        if (obj2.getId() != null) {
            json.put("id", obj2.getId());
        }
        if (obj2.getPublicKey() != null) {
            json.put("publicKey", obj2.getPublicKey());
        }
        if (obj2.getSecretKey() != null) {
            json.put("secretKey", obj2.getSecretKey());
        }
        json.put("symmetric", obj2.isSymmetric());
    }
}

