/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.ext.auth.KeyStoreOptions;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;

public class KeyStoreOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, KeyStoreOptions obj2) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "password": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setPassword((String)member.getValue());
                    break;
                }
                case "passwordProtection": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, String> map2 = new LinkedHashMap<String, String>();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map2.put((String)entry.getKey(), (String)entry.getValue());
                        }
                    });
                    obj2.setPasswordProtection(map2);
                    break;
                }
                case "path": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setPath((String)member.getValue());
                    break;
                }
                case "provider": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setProvider((String)member.getValue());
                    break;
                }
                case "type": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setType((String)member.getValue());
                    break;
                }
                case "value": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setValue(Buffer.buffer(BASE64_DECODER.decode((String)member.getValue())));
                }
            }
        }
    }

    public static void toJson(KeyStoreOptions obj2, JsonObject json) {
        KeyStoreOptionsConverter.toJson(obj2, json.getMap());
    }

    public static void toJson(KeyStoreOptions obj2, Map<String, Object> json) {
        if (obj2.getPassword() != null) {
            json.put("password", obj2.getPassword());
        }
        if (obj2.getPasswordProtection() != null) {
            JsonObject map2 = new JsonObject();
            obj2.getPasswordProtection().forEach((key2, value) -> map2.put((String)key2, value));
            json.put("passwordProtection", map2);
        }
        if (obj2.getPath() != null) {
            json.put("path", obj2.getPath());
        }
        if (obj2.getProvider() != null) {
            json.put("provider", obj2.getProvider());
        }
        if (obj2.getType() != null) {
            json.put("type", obj2.getType());
        }
        if (obj2.getValue() != null) {
            json.put("value", BASE64_ENCODER.encodeToString(obj2.getValue().getBytes()));
        }
    }
}

