/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.ext.auth.JWTOptions;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;

public class JWTOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, JWTOptions obj2) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "algorithm": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setAlgorithm((String)member.getValue());
                    break;
                }
                case "audience": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj2.setAudience(list);
                    break;
                }
                case "audiences": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj2.addAudience((String)item);
                        }
                    });
                    break;
                }
                case "expiresInMinutes": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setExpiresInMinutes(((Number)member.getValue()).intValue());
                    break;
                }
                case "expiresInSeconds": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setExpiresInSeconds(((Number)member.getValue()).intValue());
                    break;
                }
                case "header": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setHeader(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "ignoreExpiration": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setIgnoreExpiration((Boolean)member.getValue());
                    break;
                }
                case "issuer": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setIssuer((String)member.getValue());
                    break;
                }
                case "leeway": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setLeeway(((Number)member.getValue()).intValue());
                    break;
                }
                case "noTimestamp": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setNoTimestamp((Boolean)member.getValue());
                    break;
                }
                case "nonceAlgorithm": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setNonceAlgorithm((String)member.getValue());
                    break;
                }
                case "permissions": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj2.setPermissions(list);
                    break;
                }
                case "subject": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setSubject((String)member.getValue());
                }
            }
        }
    }

    public static void toJson(JWTOptions obj2, JsonObject json) {
        JWTOptionsConverter.toJson(obj2, json.getMap());
    }

    public static void toJson(JWTOptions obj2, Map<String, Object> json) {
        JsonArray array2;
        if (obj2.getAlgorithm() != null) {
            json.put("algorithm", obj2.getAlgorithm());
        }
        if (obj2.getAudience() != null) {
            array2 = new JsonArray();
            obj2.getAudience().forEach(item -> array2.add(item));
            json.put("audience", array2);
        }
        json.put("expiresInSeconds", obj2.getExpiresInSeconds());
        if (obj2.getHeader() != null) {
            json.put("header", obj2.getHeader());
        }
        json.put("ignoreExpiration", obj2.isIgnoreExpiration());
        if (obj2.getIssuer() != null) {
            json.put("issuer", obj2.getIssuer());
        }
        json.put("leeway", obj2.getLeeway());
        json.put("noTimestamp", obj2.isNoTimestamp());
        if (obj2.getNonceAlgorithm() != null) {
            json.put("nonceAlgorithm", obj2.getNonceAlgorithm());
        }
        if (obj2.getPermissions() != null) {
            array2 = new JsonArray();
            obj2.getPermissions().forEach(item -> array2.add(item));
            json.put("permissions", array2);
        }
        if (obj2.getSubject() != null) {
            json.put("subject", obj2.getSubject());
        }
    }
}

