/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.streams;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.streams.StreamBase;

@VertxGen(concrete=false)
public interface WriteStream<T>
extends StreamBase {
    @Override
    public WriteStream<T> exceptionHandler(@Nullable Handler<Throwable> var1);

    public Future<Void> write(T var1);

    public void write(T var1, Handler<AsyncResult<Void>> var2);

    default public Future<Void> end() {
        Promise<Void> promise2 = Promise.promise();
        this.end((Handler<AsyncResult<Void>>)promise2);
        return promise2.future();
    }

    public void end(Handler<AsyncResult<Void>> var1);

    default public Future<Void> end(T data2) {
        Promise<Void> provide2 = Promise.promise();
        this.end(data2, provide2);
        return provide2.future();
    }

    default public void end(T data2, Handler<AsyncResult<Void>> handler) {
        if (handler != null) {
            this.write(data2, ar -> {
                if (ar.succeeded()) {
                    this.end(handler);
                } else {
                    handler.handle((AsyncResult<Void>)ar);
                }
            });
        } else {
            this.end(data2);
        }
    }

    @Fluent
    public WriteStream<T> setWriteQueueMaxSize(int var1);

    public boolean writeQueueFull();

    @Fluent
    public WriteStream<T> drainHandler(@Nullable Handler<Void> var1);
}

