/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.tracing;

import io.vertx.core.spi.tracing.Extractors;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public interface TagExtractor<T> {
    public static <T> TagExtractor<T> empty() {
        return Extractors.EMPTY;
    }

    default public int len(T obj2) {
        return 0;
    }

    default public String name(T obj2, int index2) {
        throw new IndexOutOfBoundsException("Invalid tag index " + index2);
    }

    default public String value(T obj2, int index2) {
        throw new IndexOutOfBoundsException("Invalid tag index " + index2);
    }

    default public Map<String, String> extract(T obj2) {
        HashMap<String, String> tags = new HashMap<String, String>();
        this.extractTo(obj2, tags);
        return tags;
    }

    default public void extractTo(T obj2, Map<String, String> tags) {
        int len = this.len(obj2);
        for (int idx = 0; idx < len; ++idx) {
            tags.put(this.name(obj2, idx), this.value(obj2, idx));
        }
    }

    default public void extractTo(T obj2, BiConsumer<String, String> consumer) {
        int len = this.len(obj2);
        for (int idx = 0; idx < len; ++idx) {
            consumer.accept(this.name(obj2, idx), this.value(obj2, idx));
        }
    }
}

