/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.Arguments;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.Counter;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.Lock;
import io.vertx.core.shareddata.SharedData;
import io.vertx.core.shareddata.impl.AsynchronousCounter;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import io.vertx.core.shareddata.impl.LocalAsyncLocks;
import io.vertx.core.shareddata.impl.LocalAsyncMapImpl;
import io.vertx.core.shareddata.impl.LocalMapImpl;
import io.vertx.core.spi.cluster.ClusterManager;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SharedDataImpl
implements SharedData {
    private static final long DEFAULT_LOCK_TIMEOUT = 10000L;
    private final VertxInternal vertx;
    private final ClusterManager clusterManager;
    private final LocalAsyncLocks localAsyncLocks;
    private final ConcurrentMap<String, LocalAsyncMapImpl<?, ?>> localAsyncMaps = new ConcurrentHashMap();
    private final ConcurrentMap<String, Counter> localCounters = new ConcurrentHashMap<String, Counter>();
    private final ConcurrentMap<String, LocalMap<?, ?>> localMaps = new ConcurrentHashMap();

    public SharedDataImpl(VertxInternal vertx, ClusterManager clusterManager) {
        this.vertx = vertx;
        this.clusterManager = clusterManager;
        this.localAsyncLocks = new LocalAsyncLocks();
    }

    @Override
    public <K, V> void getClusterWideMap(String name2, Handler<AsyncResult<AsyncMap<K, V>>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.getClusterWideMap(name2).onComplete(resultHandler);
    }

    @Override
    public <K, V> Future<AsyncMap<K, V>> getClusterWideMap(String name2) {
        Objects.requireNonNull(name2, "name");
        if (this.clusterManager == null) {
            throw new IllegalStateException("Can't get cluster wide map if not clustered");
        }
        PromiseInternal promise2 = this.vertx.promise();
        this.clusterManager.getAsyncMap(name2, promise2);
        return promise2.future().map(WrappedAsyncMap::new);
    }

    @Override
    public <K, V> void getAsyncMap(String name2, Handler<AsyncResult<AsyncMap<K, V>>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.getAsyncMap(name2).onComplete(resultHandler);
    }

    @Override
    public <K, V> Future<AsyncMap<K, V>> getAsyncMap(String name2) {
        Objects.requireNonNull(name2, "name");
        if (this.clusterManager == null) {
            return this.getLocalAsyncMap(name2);
        }
        PromiseInternal promise2 = this.vertx.promise();
        this.clusterManager.getAsyncMap(name2, promise2);
        return promise2.future().map(WrappedAsyncMap::new);
    }

    @Override
    public void getLock(String name2, Handler<AsyncResult<Lock>> resultHandler) {
        this.getLockWithTimeout(name2, 10000L, resultHandler);
    }

    @Override
    public Future<Lock> getLock(String name2) {
        return this.getLockWithTimeout(name2, 10000L);
    }

    @Override
    public void getLockWithTimeout(String name2, long timeout, Handler<AsyncResult<Lock>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.getLockWithTimeout(name2, timeout).onComplete(resultHandler);
    }

    @Override
    public Future<Lock> getLockWithTimeout(String name2, long timeout) {
        Objects.requireNonNull(name2, "name");
        Arguments.require(timeout >= 0L, "timeout must be >= 0");
        if (this.clusterManager == null) {
            return this.getLocalLockWithTimeout(name2, timeout);
        }
        PromiseInternal<Lock> promise2 = this.vertx.promise();
        this.clusterManager.getLockWithTimeout(name2, timeout, promise2);
        return promise2.future();
    }

    @Override
    public void getLocalLock(String name2, Handler<AsyncResult<Lock>> resultHandler) {
        this.getLocalLockWithTimeout(name2, 10000L, resultHandler);
    }

    @Override
    public Future<Lock> getLocalLock(String name2) {
        return this.getLocalLockWithTimeout(name2, 10000L);
    }

    @Override
    public void getLocalLockWithTimeout(String name2, long timeout, Handler<AsyncResult<Lock>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.getLocalLockWithTimeout(name2, timeout).onComplete(resultHandler);
    }

    @Override
    public Future<Lock> getLocalLockWithTimeout(String name2, long timeout) {
        Objects.requireNonNull(name2, "name");
        Arguments.require(timeout >= 0L, "timeout must be >= 0");
        return this.localAsyncLocks.acquire(this.vertx.getOrCreateContext(), name2, timeout);
    }

    @Override
    public Future<Counter> getCounter(String name2) {
        Objects.requireNonNull(name2, "name");
        if (this.clusterManager == null) {
            return this.getLocalCounter(name2);
        }
        PromiseInternal<Counter> promise2 = this.vertx.promise();
        this.clusterManager.getCounter(name2, promise2);
        return promise2.future();
    }

    @Override
    public void getCounter(String name2, Handler<AsyncResult<Counter>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.getCounter(name2).onComplete(resultHandler);
    }

    @Override
    public <K, V> LocalMap<K, V> getLocalMap(String name2) {
        return this.localMaps.computeIfAbsent(name2, n -> new LocalMapImpl((String)n, this.localMaps));
    }

    @Override
    public <K, V> void getLocalAsyncMap(String name2, Handler<AsyncResult<AsyncMap<K, V>>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.getLocalAsyncMap(name2).onComplete(resultHandler);
    }

    @Override
    public <K, V> Future<AsyncMap<K, V>> getLocalAsyncMap(String name2) {
        LocalAsyncMapImpl asyncMap = this.localAsyncMaps.computeIfAbsent(name2, n -> new LocalAsyncMapImpl(this.vertx));
        ContextInternal context = this.vertx.getOrCreateContext();
        return context.succeededFuture(new WrappedAsyncMap(asyncMap));
    }

    @Override
    public void getLocalCounter(String name2, Handler<AsyncResult<Counter>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        this.getLocalCounter(name2).onComplete(resultHandler);
    }

    @Override
    public Future<Counter> getLocalCounter(String name2) {
        Counter counter = this.localCounters.computeIfAbsent(name2, n -> new AsynchronousCounter(this.vertx));
        ContextInternal context = this.vertx.getOrCreateContext();
        return context.succeededFuture(counter);
    }

    private static void checkType(Object obj2) {
        if (obj2 == null) {
            throw new IllegalArgumentException("Cannot put null in key or value of async map");
        }
        if (!(obj2 instanceof Serializable) && !(obj2 instanceof ClusterSerializable)) {
            throw new IllegalArgumentException("Invalid type: " + obj2.getClass().getName() + " to put in async map");
        }
    }

    public static final class WrappedAsyncMap<K, V>
    implements AsyncMap<K, V> {
        private final AsyncMap<K, V> delegate;

        WrappedAsyncMap(AsyncMap<K, V> other) {
            this.delegate = other;
        }

        @Override
        public Future<V> get(K k) {
            SharedDataImpl.checkType(k);
            return this.delegate.get(k);
        }

        @Override
        public Future<Void> put(K k, V v) {
            SharedDataImpl.checkType(k);
            SharedDataImpl.checkType(v);
            return this.delegate.put(k, v);
        }

        @Override
        public Future<Void> put(K k, V v, long ttl) {
            SharedDataImpl.checkType(k);
            SharedDataImpl.checkType(v);
            return this.delegate.put(k, v, ttl);
        }

        @Override
        public Future<V> putIfAbsent(K k, V v) {
            SharedDataImpl.checkType(k);
            SharedDataImpl.checkType(v);
            return this.delegate.putIfAbsent(k, v);
        }

        @Override
        public Future<V> putIfAbsent(K k, V v, long ttl) {
            SharedDataImpl.checkType(k);
            SharedDataImpl.checkType(v);
            return this.delegate.putIfAbsent(k, v, ttl);
        }

        @Override
        public Future<V> remove(K k) {
            SharedDataImpl.checkType(k);
            return this.delegate.remove(k);
        }

        @Override
        public Future<Boolean> removeIfPresent(K k, V v) {
            SharedDataImpl.checkType(k);
            SharedDataImpl.checkType(v);
            return this.delegate.removeIfPresent(k, v);
        }

        @Override
        public Future<V> replace(K k, V v) {
            SharedDataImpl.checkType(k);
            SharedDataImpl.checkType(v);
            return this.delegate.replace(k, v);
        }

        @Override
        public Future<V> replace(K k, V v, long ttl) {
            SharedDataImpl.checkType(k);
            SharedDataImpl.checkType(v);
            return this.delegate.replace(k, v, ttl);
        }

        @Override
        public Future<Boolean> replaceIfPresent(K k, V oldValue, V newValue) {
            SharedDataImpl.checkType(k);
            SharedDataImpl.checkType(oldValue);
            SharedDataImpl.checkType(newValue);
            return this.delegate.replaceIfPresent(k, oldValue, newValue);
        }

        @Override
        public Future<Boolean> replaceIfPresent(K k, V oldValue, V newValue, long ttl) {
            SharedDataImpl.checkType(k);
            SharedDataImpl.checkType(oldValue);
            SharedDataImpl.checkType(newValue);
            return this.delegate.replaceIfPresent(k, oldValue, newValue, ttl);
        }

        @Override
        public Future<Void> clear() {
            return this.delegate.clear();
        }

        @Override
        public Future<Integer> size() {
            return this.delegate.size();
        }

        @Override
        public Future<Set<K>> keys() {
            return this.delegate.keys();
        }

        @Override
        public Future<List<V>> values() {
            return this.delegate.values();
        }

        @Override
        public Future<Map<K, V>> entries() {
            return this.delegate.entries();
        }

        public AsyncMap<K, V> getDelegate() {
            return this.delegate;
        }
    }
}

