/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata.impl;

import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.impl.Checker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

class LocalMapImpl<K, V>
implements LocalMap<K, V> {
    private final ConcurrentMap<String, LocalMap<?, ?>> maps;
    private final String name;
    private final ConcurrentMap<K, V> map = new ConcurrentHashMap();

    LocalMapImpl(String name2, ConcurrentMap<String, LocalMap<?, ?>> maps) {
        this.name = name2;
        this.maps = maps;
    }

    @Override
    public V get(Object key2) {
        return Checker.copyIfRequired(this.map.get(key2));
    }

    @Override
    public V put(K key2, V value) {
        Checker.checkType(key2);
        Checker.checkType(value);
        return this.map.put(key2, value);
    }

    @Override
    public V remove(Object key2) {
        return Checker.copyIfRequired(this.map.remove(key2));
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public V putIfAbsent(K key2, V value) {
        Checker.checkType(key2);
        Checker.checkType(value);
        return Checker.copyIfRequired(this.map.putIfAbsent(key2, value));
    }

    @Override
    public boolean remove(Object key2, Object value) {
        return this.map.remove(key2, value);
    }

    @Override
    public boolean replace(K key2, V oldValue, V newValue) {
        return this.map.replace(key2, oldValue, newValue);
    }

    @Override
    public boolean removeIfPresent(K key2, V value) {
        return this.map.remove(key2, value);
    }

    @Override
    public boolean replaceIfPresent(K key2, V oldValue, V newValue) {
        Checker.checkType(key2);
        Checker.checkType(oldValue);
        Checker.checkType(newValue);
        return this.map.replace(key2, oldValue, newValue);
    }

    @Override
    public V replace(K key2, V value) {
        Checker.checkType(key2);
        Checker.checkType(value);
        return Checker.copyIfRequired(this.map.replace(key2, value));
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.map.replaceAll((k, v) -> {
            Checker.checkType(k);
            Checker.checkType(v);
            Object output2 = function.apply((Object)k, (Object)v);
            if (output2 != null) {
                Checker.checkType(output2);
            }
            return output2;
        });
    }

    @Override
    public void close() {
        this.maps.remove(this.name);
    }

    @Override
    public Set<K> keySet() {
        HashSet keys2 = new HashSet(this.map.size());
        for (Object k : this.map.keySet()) {
            keys2.add(Checker.copyIfRequired(k));
        }
        return keys2;
    }

    @Override
    public Collection<V> values() {
        ArrayList values2 = new ArrayList(this.map.size());
        for (Object v : this.map.values()) {
            values2.add(Checker.copyIfRequired(v));
        }
        return values2;
    }

    private BiFunction<? super K, ? super V, ? extends V> typeChecked(BiFunction<? super K, ? super V, ? extends V> function) {
        return (k, v) -> {
            Checker.checkType(k);
            Object output2 = function.apply((Object)k, (Object)v);
            if (output2 != null) {
                Checker.checkType(output2);
            }
            return output2;
        };
    }

    private Function<? super K, ? extends V> typeChecked(Function<? super K, ? extends V> function) {
        return k -> {
            Checker.checkType(k);
            Object output2 = function.apply((Object)k);
            if (output2 != null) {
                Checker.checkType(output2);
            }
            return output2;
        };
    }

    @Override
    public V compute(K key2, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.map.compute((K)key2, this.typeChecked(remappingFunction));
    }

    @Override
    public V computeIfAbsent(K key2, Function<? super K, ? extends V> mappingFunction) {
        return this.map.computeIfAbsent((K)key2, this.typeChecked(mappingFunction));
    }

    @Override
    public V computeIfPresent(K key2, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.map.computeIfPresent((K)key2, this.typeChecked(remappingFunction));
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.map.containsKey(key2);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> entries2 = new HashSet<Map.Entry<K, V>>(this.map.size());
        for (final Map.Entry entry : this.map.entrySet()) {
            entries2.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return Checker.copyIfRequired(entry.getKey());
                }

                @Override
                public V getValue() {
                    return Checker.copyIfRequired(entry.getValue());
                }

                @Override
                public V setValue(V value) {
                    throw new UnsupportedOperationException();
                }
            });
        }
        return entries2;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        for (Map.Entry<K, V> entry : this.entrySet()) {
            action.accept(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V getOrDefault(Object key2, V defaultValue) {
        return Checker.copyIfRequired(this.map.getOrDefault(key2, defaultValue));
    }

    @Override
    public V merge(K key2, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Checker.checkType(key2);
        Checker.checkType(value);
        return (V)this.map.merge(key2, value, (k, v) -> {
            Object output2 = remappingFunction.apply((Object)k, (Object)v);
            if (output2 != null) {
                Checker.checkType(output2);
            }
            return output2;
        });
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m4) {
        for (Map.Entry<K, V> entry : m4.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        return this.map.toString();
    }
}

