/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata.impl;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.shareddata.Lock;
import io.vertx.core.shareddata.impl.LockInternal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class LocalAsyncLocks {
    private final ConcurrentMap<String, List<LockWaiter>> waitersMap = new ConcurrentHashMap<String, List<LockWaiter>>();

    public Future<Lock> acquire(ContextInternal context, String name2, long timeout) {
        PromiseInternal<Lock> promise2 = context.promise();
        LockWaiter lockWaiter = new LockWaiter(context, name2, timeout, promise2);
        List waiters = this.waitersMap.compute(name2, (s2, list) -> {
            ArrayList<LockWaiter> result2;
            if (list != null) {
                result2 = new ArrayList(list.size() + 1);
                result2.addAll((Collection<LockWaiter>)list);
            } else {
                result2 = new ArrayList<LockWaiter>(1);
            }
            result2.add(lockWaiter);
            return result2;
        });
        if (waiters.size() == 1) {
            ((LockWaiter)waiters.get(0)).acquireLock();
        }
        return promise2.future();
    }

    private void nextWaiter(String lockName) {
        List waiters = this.waitersMap.compute(lockName, (s2, list) -> list == null || list.size() == 1 ? null : new ArrayList(list.subList(1, list.size())));
        if (waiters != null) {
            ((LockWaiter)waiters.get(0)).acquireLock();
        }
    }

    private class AsyncLock
    implements LockInternal {
        final String lockName;
        final AtomicBoolean invoked = new AtomicBoolean();

        AsyncLock(String lockName) {
            this.lockName = lockName;
        }

        @Override
        public void release() {
            if (this.invoked.compareAndSet(false, true)) {
                LocalAsyncLocks.this.nextWaiter(this.lockName);
            }
        }

        @Override
        public int waiters() {
            List waiters = (List)LocalAsyncLocks.this.waitersMap.get(this.lockName);
            return waiters == null ? 0 : waiters.size() - 1;
        }
    }

    private class LockWaiter {
        final ContextInternal context;
        final String lockName;
        final Promise<Lock> promise;
        final Long timerId;

        LockWaiter(ContextInternal context, String lockName, long timeout, Promise<Lock> promise2) {
            this.lockName = lockName;
            this.promise = promise2;
            this.context = context;
            this.timerId = timeout != Long.MAX_VALUE ? Long.valueOf(context.setTimer(timeout, tid -> this.timeout())) : null;
        }

        void timeout() {
            LocalAsyncLocks.this.waitersMap.compute(this.lockName, (s2, list) -> {
                int idx;
                if (list == null || (idx = list.indexOf(this)) == -1) {
                    return list;
                }
                if (list.size() == 1) {
                    return null;
                }
                int size = list.size();
                ArrayList n = new ArrayList(size - 1);
                if (idx > 0) {
                    n.addAll(list.subList(0, idx));
                }
                if (idx + 1 < size) {
                    n.addAll(list.subList(idx + 1, size));
                }
                return n;
            });
            this.promise.fail("Timed out waiting to get lock");
        }

        void acquireLock() {
            if (this.timerId == null || this.context.owner().cancelTimer(this.timerId)) {
                this.promise.complete(new AsyncLock(this.lockName));
            } else {
                LocalAsyncLocks.this.nextWaiter(this.lockName);
            }
        }
    }
}

