/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata.impl;

import io.vertx.core.impl.ClusterSerializableUtils;
import io.vertx.core.impl.SerializableUtils;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.shareddata.Shareable;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class Checker {
    private static final Logger log = LoggerFactory.getLogger(Checker.class);
    private static final Set<Class<?>> IMMUTABLE_TYPES = Stream.builder().add(String.class).add(Integer.class).add(Long.class).add(Boolean.class).add(Double.class).add(Float.class).add(Short.class).add(Byte.class).add(Character.class).add(BigInteger.class).add(BigDecimal.class).build().collect(Collectors.toSet());

    Checker() {
    }

    static void checkType(Object obj2) {
        Objects.requireNonNull(obj2, "null not allowed for shareddata data structure");
        if (!(obj2 instanceof Serializable || obj2 instanceof Shareable || obj2 instanceof ClusterSerializable)) {
            throw new IllegalArgumentException("Invalid type for shareddata data structure: " + obj2.getClass().getName());
        }
    }

    static <T> T copyIfRequired(T obj2) {
        Object result2;
        if (obj2 == null) {
            result2 = null;
        } else if (IMMUTABLE_TYPES.contains(obj2.getClass())) {
            result2 = obj2;
        } else if (obj2 instanceof byte[]) {
            result2 = Checker.copyByteArray((byte[])obj2);
        } else if (obj2 instanceof Shareable) {
            result2 = ((Shareable)obj2).copy();
        } else if (obj2 instanceof ClusterSerializable) {
            result2 = Checker.copyClusterSerializable((ClusterSerializable)obj2);
        } else if (obj2 instanceof Serializable) {
            result2 = Checker.copySerializable(obj2);
        } else {
            throw new IllegalStateException();
        }
        return (T)result2;
    }

    private static byte[] copyByteArray(byte[] bytes2) {
        byte[] copy2 = new byte[bytes2.length];
        System.arraycopy(bytes2, 0, copy2, 0, bytes2.length);
        return copy2;
    }

    private static ClusterSerializable copyClusterSerializable(ClusterSerializable obj2) {
        Checker.logDeveloperInfo(obj2);
        return ClusterSerializableUtils.copy(obj2);
    }

    private static void logDeveloperInfo(Object obj2) {
        if (log.isDebugEnabled()) {
            log.debug("Copying " + obj2.getClass() + " for shared data. Consider implementing " + Shareable.class + " for better performance.");
        }
    }

    private static Object copySerializable(Object obj2) {
        Checker.logDeveloperInfo(obj2);
        return SerializableUtils.fromBytes(SerializableUtils.toBytes(obj2), ObjectInputStream::new);
    }
}

