/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl.pool;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.http.ConnectionPoolTooBusyException;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.net.impl.pool.CombinerExecutor;
import io.vertx.core.net.impl.pool.ConnectResult;
import io.vertx.core.net.impl.pool.ConnectionPool;
import io.vertx.core.net.impl.pool.Executor;
import io.vertx.core.net.impl.pool.Lease;
import io.vertx.core.net.impl.pool.PoolConnection;
import io.vertx.core.net.impl.pool.PoolConnector;
import io.vertx.core.net.impl.pool.PoolWaiter;
import io.vertx.core.net.impl.pool.Task;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public class SimpleConnectionPool<C>
implements ConnectionPool<C> {
    private static final Future POOL_CLOSED = Future.failedFuture("Pool closed");
    private static final BiFunction<PoolWaiter, List<PoolConnection>, PoolConnection> SAME_EVENT_LOOP_SELECTOR = (waiter, list) -> {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            PoolConnection slot = (PoolConnection)list.get(i);
            if (slot.context().nettyEventLoop() != waiter.context().nettyEventLoop() || slot.available() <= 0L) continue;
            return slot;
        }
        return null;
    };
    private static final BiFunction<PoolWaiter, List<PoolConnection>, PoolConnection> FIRST_AVAILABLE_SELECTOR = (waiter, list) -> {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            PoolConnection slot = (PoolConnection)list.get(i);
            if (slot.available() <= 0L) continue;
            return slot;
        }
        return null;
    };
    private final PoolConnector<C> connector;
    private final int maxWaiters;
    private final int maxCapacity;
    private final int[] capacityFactors;
    private final Executor<SimpleConnectionPool<C>> sync;
    private final ListImpl list = new ListImpl();
    private boolean closed;
    private BiFunction<PoolWaiter<C>, List<PoolConnection<C>>, PoolConnection<C>> selector;
    private Function<ContextInternal, EventLoopContext> contextProvider;
    private BiFunction<PoolWaiter<C>, List<PoolConnection<C>>, PoolConnection<C>> fallbackSelector;
    private final Slot<C>[] slots;
    private int size;
    private int capacity;
    private final Waiters<C> waiters;
    private int requests;

    SimpleConnectionPool(PoolConnector<C> connector, int[] maxSizes) {
        this(connector, maxSizes, -1);
    }

    SimpleConnectionPool(PoolConnector<C> connector, int[] maxSizes, int maxWaiters) {
        int i;
        int[] capacities = new int[maxSizes.length];
        int maxCapacity = 1;
        int numSlots = 0;
        for (i = 0; i < maxSizes.length; ++i) {
            int maxSize = maxSizes[i];
            if (maxSize < 1) {
                throw new IllegalArgumentException();
            }
            maxCapacity *= maxSize;
            numSlots = Math.max(numSlots, maxSize);
        }
        for (i = 0; i < maxSizes.length; ++i) {
            capacities[i] = maxCapacity / maxSizes[i];
        }
        this.capacityFactors = capacities;
        this.connector = connector;
        this.slots = new Slot[numSlots];
        this.size = 0;
        this.maxWaiters = maxWaiters;
        this.capacity = 0;
        this.maxCapacity = maxCapacity;
        this.sync = new CombinerExecutor<SimpleConnectionPool>(this);
        this.selector = SAME_EVENT_LOOP_SELECTOR;
        this.fallbackSelector = FIRST_AVAILABLE_SELECTOR;
        this.contextProvider = EVENT_LOOP_CONTEXT_PROVIDER;
        this.waiters = new Waiters();
    }

    @Override
    public ConnectionPool<C> connectionSelector(BiFunction<PoolWaiter<C>, List<PoolConnection<C>>, PoolConnection<C>> selector) {
        this.selector = selector;
        return this;
    }

    @Override
    public ConnectionPool<C> contextProvider(Function<ContextInternal, EventLoopContext> contextProvider) {
        this.contextProvider = contextProvider;
        return this;
    }

    private void execute(Executor.Action<SimpleConnectionPool<C>> action) {
        this.sync.submit(action);
    }

    @Override
    public int size() {
        return this.size;
    }

    public void connect(Slot<C> slot, PoolWaiter<C> waiter) {
        ((Slot)slot).initiator = waiter;
        this.connector.connect(((Slot)slot).context, slot, ar -> {
            ((Slot)slot).initiator = null;
            if (ar.succeeded()) {
                this.execute(new ConnectSuccess(slot, (ConnectResult)ar.result(), waiter));
            } else {
                this.execute(new ConnectFailed(slot, ar.cause(), waiter));
            }
        });
    }

    private void setConcurrency(Slot<C> slot, long concurrency) {
        this.execute(new SetConcurrency<C>(slot, concurrency));
    }

    private void remove(Slot<C> removed) {
        this.execute(new Remove(removed));
    }

    @Override
    public void evict(Predicate<C> predicate, Handler<AsyncResult<List<C>>> handler) {
        this.execute(new Evict<C>(predicate, handler));
    }

    @Override
    public void acquire(ContextInternal context, PoolWaiter.Listener<C> listener, int kind, Handler<AsyncResult<Lease<C>>> handler) {
        this.execute(new Acquire<C>(context, listener, this.capacityFactors[kind], handler));
    }

    @Override
    public void acquire(ContextInternal context, int kind, Handler<AsyncResult<Lease<C>>> handler) {
        this.acquire(context, PoolWaiter.NULL_LISTENER, kind, handler);
    }

    @Override
    public void cancel(PoolWaiter<C> waiter, Handler<AsyncResult<Boolean>> handler) {
        this.execute(new Cancel<C>(waiter, handler));
    }

    private void recycle(LeaseImpl<C> lease) {
        if (((LeaseImpl)lease).recycled) {
            throw new IllegalStateException("Attempt to recycle more than permitted");
        }
        ((LeaseImpl)lease).recycled = true;
        this.execute(new Recycle(((LeaseImpl)lease).slot));
    }

    @Override
    public int waiters() {
        return this.waiters.size();
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int requests() {
        return this.requests;
    }

    @Override
    public void close(Handler<AsyncResult<List<Future<C>>>> handler) {
        this.execute(new Close(handler));
    }

    class ListImpl
    extends AbstractList<PoolConnection<C>> {
        ListImpl() {
        }

        @Override
        public PoolConnection<C> get(int index2) {
            return SimpleConnectionPool.this.slots[index2];
        }

        @Override
        public int size() {
            return SimpleConnectionPool.this.size;
        }
    }

    private static class Waiters<C>
    implements Iterable<PoolWaiter<C>> {
        private final PoolWaiter<C> head = new PoolWaiter(null, null, 0, null);
        private int size;

        public Waiters() {
            this.head.prev = this.head;
            this.head.next = this.head.prev;
        }

        PoolWaiter<C> poll() {
            if (this.head.next == this.head) {
                return null;
            }
            PoolWaiter node2 = this.head.next;
            this.remove(node2);
            return node2;
        }

        void addLast(PoolWaiter<C> node2) {
            if (node2.queued) {
                throw new IllegalStateException();
            }
            node2.queued = true;
            node2.prev = this.head.prev;
            node2.next = this.head;
            this.head.prev.next = node2;
            this.head.prev = node2;
            ++this.size;
        }

        void addFirst(PoolWaiter<C> node2) {
            if (node2.queued) {
                throw new IllegalStateException();
            }
            node2.queued = true;
            node2.prev = this.head;
            node2.next = this.head.prev;
            this.head.next.prev = node2;
            this.head.next = node2;
            ++this.size;
        }

        boolean remove(PoolWaiter<C> node2) {
            if (!node2.queued) {
                return false;
            }
            node2.next.prev = node2.prev;
            node2.prev.next = node2.next;
            node2.prev = null;
            node2.next = null;
            node2.queued = false;
            --this.size;
            return true;
        }

        List<PoolWaiter<C>> clear() {
            ArrayList<PoolWaiter<C>> lst = new ArrayList<PoolWaiter<C>>(this.size);
            this.forEach(lst::add);
            this.size = 0;
            this.head.prev = this.head;
            this.head.next = this.head.prev;
            return lst;
        }

        int size() {
            return this.size;
        }

        @Override
        public Iterator<PoolWaiter<C>> iterator() {
            return new Iterator<PoolWaiter<C>>(){
                PoolWaiter<C> current;
                {
                    this.current = head;
                }

                @Override
                public boolean hasNext() {
                    return this.current.next != head;
                }

                @Override
                public PoolWaiter<C> next() {
                    if (this.current.next == head) {
                        throw new NoSuchElementException();
                    }
                    try {
                        PoolWaiter poolWaiter = this.current.next;
                        return poolWaiter;
                    }
                    finally {
                        this.current = this.current.next;
                    }
                }
            };
        }
    }

    private static class Close<C>
    implements Executor.Action<SimpleConnectionPool<C>> {
        private final Handler<AsyncResult<List<Future<C>>>> handler;

        private Close(Handler<AsyncResult<List<Future<C>>>> handler) {
            this.handler = handler;
        }

        @Override
        public Task execute(SimpleConnectionPool<C> pool) {
            if (((SimpleConnectionPool)pool).closed) {
                return new Task(){

                    @Override
                    public void run() {
                        handler.handle(POOL_CLOSED);
                    }
                };
            }
            ((SimpleConnectionPool)pool).closed = true;
            final List waiters = ((SimpleConnectionPool)pool).waiters.clear();
            final ArrayList list = new ArrayList();
            for (int i = 0; i < ((SimpleConnectionPool)pool).size; ++i) {
                Slot slot = ((SimpleConnectionPool)pool).slots[i];
                ((SimpleConnectionPool)pool).slots[i] = null;
                PoolWaiter waiter = slot.initiator;
                if (waiter != null) {
                    waiters.add(slot.initiator);
                    ((Slot)slot).initiator.disposed = true;
                    slot.initiator = null;
                }
                SimpleConnectionPool<C> simpleConnectionPool = pool;
                ((SimpleConnectionPool)simpleConnectionPool).capacity = ((SimpleConnectionPool)simpleConnectionPool).capacity - slot.capacity;
                list.add(slot.result.future());
            }
            ((SimpleConnectionPool)pool).size = 0;
            return new Task(){

                @Override
                public void run() {
                    waiters.forEach(w -> w.context.emit(POOL_CLOSED, w.handler));
                    handler.handle(Future.succeededFuture(list));
                }
            };
        }
    }

    private static class Recycle<C>
    implements Executor.Action<SimpleConnectionPool<C>> {
        private final Slot<C> slot;

        public Recycle(Slot<C> slot) {
            this.slot = slot;
        }

        @Override
        public Task execute(SimpleConnectionPool<C> pool) {
            if (!((SimpleConnectionPool)pool).closed && ((Slot)this.slot).connection != null) {
                PoolWaiter waiter;
                if ((long)((Slot)this.slot).usage <= ((Slot)this.slot).concurrency && (waiter = ((SimpleConnectionPool)pool).waiters.poll()) != null) {
                    final LeaseImpl<C> lease = new LeaseImpl<C>(this.slot, waiter.handler);
                    return new Task(){

                        @Override
                        public void run() {
                            lease.emit();
                        }
                    };
                }
                ((Slot)this.slot).usage--;
            }
            return null;
        }
    }

    static class LeaseImpl<C>
    implements Lease<C> {
        private final Handler<AsyncResult<Lease<C>>> handler;
        private final Slot<C> slot;
        private final C connection;
        private boolean recycled;

        public LeaseImpl(Slot<C> slot, Handler<AsyncResult<Lease<C>>> handler) {
            this.handler = handler;
            this.slot = slot;
            this.connection = ((Slot)slot).connection;
        }

        @Override
        public C get() {
            return this.connection;
        }

        @Override
        public void recycle() {
            ((Slot)this.slot).pool.recycle(this);
        }

        void emit() {
            ((Slot)this.slot).context.emit(Future.succeededFuture(this), this.handler);
        }
    }

    private static class Cancel<C>
    extends Task
    implements Executor.Action<SimpleConnectionPool<C>> {
        private final PoolWaiter<C> waiter;
        private final Handler<AsyncResult<Boolean>> handler;
        private boolean cancelled;

        public Cancel(PoolWaiter<C> waiter, Handler<AsyncResult<Boolean>> handler) {
            this.waiter = waiter;
            this.handler = handler;
        }

        @Override
        public Task execute(SimpleConnectionPool<C> pool) {
            if (((SimpleConnectionPool)pool).closed) {
                return new Task(){

                    @Override
                    public void run() {
                        handler.handle(POOL_CLOSED);
                    }
                };
            }
            if (((SimpleConnectionPool)pool).waiters.remove(this.waiter)) {
                this.cancelled = true;
                this.waiter.disposed = true;
            } else if (!this.waiter.disposed) {
                this.waiter.disposed = true;
                this.cancelled = true;
            } else {
                this.cancelled = false;
            }
            return this;
        }

        @Override
        public void run() {
            this.handler.handle(Future.succeededFuture(this.cancelled));
        }
    }

    private static class Acquire<C>
    extends PoolWaiter<C>
    implements Executor.Action<SimpleConnectionPool<C>> {
        public Acquire(ContextInternal context, PoolWaiter.Listener<C> listener, int capacity, Handler<AsyncResult<Lease<C>>> handler) {
            super(listener, context, capacity, handler);
        }

        @Override
        public Task execute(final SimpleConnectionPool<C> pool) {
            if (((SimpleConnectionPool)pool).closed) {
                return new Task(){

                    @Override
                    public void run() {
                        context.emit(POOL_CLOSED, handler);
                    }
                };
            }
            Slot slot1 = (Slot)((SimpleConnectionPool)pool).selector.apply(this, ((SimpleConnectionPool)pool).list);
            if (slot1 != null) {
                slot1.usage++;
                final LeaseImpl lease = new LeaseImpl(slot1, this.handler);
                return new Task(){

                    @Override
                    public void run() {
                        lease.emit();
                    }
                };
            }
            if (((SimpleConnectionPool)pool).capacity < ((SimpleConnectionPool)pool).maxCapacity) {
                Slot<C> slot2;
                SimpleConnectionPool<C> lease = pool;
                ((SimpleConnectionPool)lease).capacity = ((SimpleConnectionPool)lease).capacity + this.capacity;
                EventLoopContext connectionContext = (EventLoopContext)((SimpleConnectionPool)pool).contextProvider.apply(this.context);
                ((SimpleConnectionPool)pool).slots[((SimpleConnectionPool)pool).size++] = slot2 = new Slot<C>(pool, connectionContext, ((SimpleConnectionPool)pool).size, this.capacity);
                ((SimpleConnectionPool)pool).requests++;
                return new Task(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onConnect(this);
                        }
                        pool.connect(slot2, this);
                    }
                };
            }
            Slot slot3 = (Slot)((SimpleConnectionPool)pool).fallbackSelector.apply(this, ((SimpleConnectionPool)pool).list);
            if (slot3 != null) {
                slot3.usage++;
                final LeaseImpl lease = new LeaseImpl(slot3, this.handler);
                return new Task(){

                    @Override
                    public void run() {
                        lease.emit();
                    }
                };
            }
            if (((SimpleConnectionPool)pool).maxWaiters == -1 || ((SimpleConnectionPool)pool).waiters.size() + ((SimpleConnectionPool)pool).requests < ((SimpleConnectionPool)pool).maxWaiters) {
                ((SimpleConnectionPool)pool).waiters.addLast(this);
                if (this.listener != null) {
                    return new Task(){

                        @Override
                        public void run() {
                            listener.onEnqueue(this);
                        }
                    };
                }
                return null;
            }
            return new Task(){

                @Override
                public void run() {
                    context.emit(Future.failedFuture(new ConnectionPoolTooBusyException("Connection pool reached max wait queue size of " + pool.maxWaiters)), handler);
                }
            };
        }
    }

    private static class Evict<C>
    implements Executor.Action<SimpleConnectionPool<C>> {
        private final Predicate<C> predicate;
        private final Handler<AsyncResult<List<C>>> handler;

        public Evict(Predicate<C> predicate, Handler<AsyncResult<List<C>>> handler) {
            this.predicate = predicate;
            this.handler = handler;
        }

        @Override
        public Task execute(SimpleConnectionPool<C> pool) {
            if (((SimpleConnectionPool)pool).closed) {
                return new Task(){

                    @Override
                    public void run() {
                        handler.handle(POOL_CLOSED);
                    }
                };
            }
            final ArrayList<Object> res = new ArrayList<Object>();
            ArrayList<Slot> removed = new ArrayList<Slot>();
            for (int i = ((SimpleConnectionPool)pool).size - 1; i >= 0; --i) {
                Slot slot = ((SimpleConnectionPool)pool).slots[i];
                if (slot.connection == null || slot.usage != 0 || !this.predicate.test(slot.connection)) continue;
                removed.add(slot);
                res.add(slot.connection);
            }
            for (Slot slot : removed) {
                ((SimpleConnectionPool)pool).remove(slot);
            }
            return new Task(){

                @Override
                public void run() {
                    handler.handle(Future.succeededFuture(res));
                }
            };
        }
    }

    private static class SetConcurrency<C>
    implements Executor.Action<SimpleConnectionPool<C>> {
        private final Slot<C> slot;
        private final long concurrency;

        SetConcurrency(Slot<C> slot, long concurrency) {
            this.slot = slot;
            this.concurrency = concurrency;
        }

        @Override
        public Task execute(SimpleConnectionPool<C> pool) {
            if (((Slot)this.slot).connection != null) {
                long diff2 = this.concurrency - ((Slot)this.slot).concurrency;
                Slot<C> slot = this.slot;
                ((Slot)slot).concurrency = ((Slot)slot).concurrency + diff2;
                if (diff2 > 0L) {
                    int m4 = (int)Math.min(((Slot)this.slot).concurrency - (long)((Slot)this.slot).usage, (long)((SimpleConnectionPool)pool).waiters.size());
                    if (m4 > 0) {
                        final LeaseImpl[] extra = new LeaseImpl[m4];
                        for (int i = 0; i < m4; ++i) {
                            extra[i] = new LeaseImpl<C>(this.slot, ((SimpleConnectionPool)pool).waiters.poll().handler);
                        }
                        Slot<C> slot2 = this.slot;
                        ((Slot)slot2).usage = ((Slot)slot2).usage + m4;
                        return new Task(){

                            @Override
                            public void run() {
                                for (LeaseImpl lease : extra) {
                                    lease.emit();
                                }
                            }
                        };
                    }
                    return null;
                }
                return null;
            }
            return null;
        }
    }

    private static class Remove<C>
    implements Executor.Action<SimpleConnectionPool<C>> {
        protected final Slot<C> removed;

        private Remove(Slot<C> removed) {
            this.removed = removed;
        }

        @Override
        public Task execute(final SimpleConnectionPool<C> pool) {
            if (((SimpleConnectionPool)pool).closed || ((SimpleConnectionPool)pool).slots[((Slot)this.removed).index] != this.removed) {
                return null;
            }
            int w = ((Slot)this.removed).capacity;
            ((Slot)this.removed).usage = 0;
            ((Slot)this.removed).concurrency = 0L;
            ((Slot)this.removed).connection = null;
            ((Slot)this.removed).capacity = 0;
            final PoolWaiter waiter = ((SimpleConnectionPool)pool).waiters.poll();
            if (waiter != null) {
                EventLoopContext connectionContext = (EventLoopContext)((SimpleConnectionPool)pool).contextProvider.apply(waiter.context);
                final Slot<C> slot = new Slot<C>(pool, connectionContext, ((Slot)this.removed).index, waiter.capacity);
                SimpleConnectionPool<C> simpleConnectionPool = pool;
                ((SimpleConnectionPool)simpleConnectionPool).capacity = ((SimpleConnectionPool)simpleConnectionPool).capacity - w;
                simpleConnectionPool = pool;
                ((SimpleConnectionPool)simpleConnectionPool).capacity = ((SimpleConnectionPool)simpleConnectionPool).capacity + waiter.capacity;
                ((SimpleConnectionPool)pool).slots[((Slot)this.removed).index] = slot;
                ((SimpleConnectionPool)pool).requests++;
                return new Task(){

                    @Override
                    public void run() {
                        if (waiter.listener != null) {
                            waiter.listener.onConnect(waiter);
                        }
                        pool.connect(slot, waiter);
                    }
                };
            }
            if (((SimpleConnectionPool)pool).size > 1) {
                Slot tmp = ((SimpleConnectionPool)pool).slots[((SimpleConnectionPool)pool).size - 1];
                tmp.index = ((Slot)this.removed).index;
                ((SimpleConnectionPool)pool).slots[((Slot)this.removed).index] = tmp;
                ((SimpleConnectionPool)pool).slots[((SimpleConnectionPool)pool).size - 1] = null;
                ((SimpleConnectionPool)pool).size--;
                SimpleConnectionPool<C> simpleConnectionPool = pool;
                ((SimpleConnectionPool)simpleConnectionPool).capacity = ((SimpleConnectionPool)simpleConnectionPool).capacity - w;
                return null;
            }
            ((SimpleConnectionPool)pool).slots[0] = null;
            ((SimpleConnectionPool)pool).size--;
            SimpleConnectionPool<C> simpleConnectionPool = pool;
            ((SimpleConnectionPool)simpleConnectionPool).capacity = ((SimpleConnectionPool)simpleConnectionPool).capacity - w;
            return null;
        }
    }

    private static class ConnectFailed<C>
    implements Executor.Action<SimpleConnectionPool<C>> {
        private final Slot<C> removed;
        private final Throwable cause;
        private PoolWaiter<C> waiter;

        public ConnectFailed(Slot<C> removed, Throwable cause, PoolWaiter<C> waiter) {
            this.removed = removed;
            this.cause = cause;
            this.waiter = waiter;
        }

        @Override
        public Task execute(final SimpleConnectionPool<C> pool) {
            ((SimpleConnectionPool)pool).requests--;
            if (this.waiter.disposed) {
                this.waiter = null;
            } else {
                this.waiter.disposed = true;
            }
            if (!((SimpleConnectionPool)pool).closed) {
                ((SimpleConnectionPool)pool).remove(this.removed);
            }
            return new Task(){

                @Override
                public void run() {
                    if (waiter != null) {
                        Future waiterFailure = pool.closed ? POOL_CLOSED : Future.failedFuture(cause);
                        removed.context.emit(waiterFailure, ((ConnectFailed)this).waiter.handler);
                    }
                    removed.result.fail(cause);
                }
            };
        }
    }

    private static class ConnectSuccess<C>
    implements Executor.Action<SimpleConnectionPool<C>> {
        private final Slot<C> slot;
        private final ConnectResult<C> result;
        private PoolWaiter<C> waiter;

        private ConnectSuccess(Slot<C> slot, ConnectResult<C> result2, PoolWaiter<C> waiter) {
            this.slot = slot;
            this.result = result2;
            this.waiter = waiter;
        }

        @Override
        public Task execute(SimpleConnectionPool<C> pool) {
            LeaseImpl[] leases;
            int c;
            LeaseImpl<C> lease;
            int capacity = ((SimpleConnectionPool)pool).capacityFactors[(int)this.result.weight()];
            int initialCapacity = ((Slot)this.slot).capacity;
            ((Slot)this.slot).connection = this.result.connection();
            ((Slot)this.slot).concurrency = this.result.concurrency();
            ((Slot)this.slot).capacity = capacity;
            ((Slot)this.slot).usage = 0;
            ((SimpleConnectionPool)pool).requests--;
            SimpleConnectionPool<C> simpleConnectionPool = pool;
            ((SimpleConnectionPool)simpleConnectionPool).capacity = ((SimpleConnectionPool)simpleConnectionPool).capacity + (capacity - initialCapacity);
            if (((SimpleConnectionPool)pool).closed) {
                if (this.waiter.disposed) {
                    this.waiter = null;
                } else {
                    this.waiter.disposed = true;
                }
                return new Task(){

                    @Override
                    public void run() {
                        if (waiter != null) {
                            slot.context.emit(POOL_CLOSED, ((ConnectSuccess)this).waiter.handler);
                        }
                        slot.result.complete(slot.connection);
                    }
                };
            }
            long acquisitions = ((Slot)this.slot).concurrency;
            if (acquisitions == 0L) {
                if (!this.waiter.disposed) {
                    ((SimpleConnectionPool)pool).waiters.addFirst(this.waiter);
                }
                return null;
            }
            if (this.waiter.disposed) {
                lease = null;
                c = 0;
            } else {
                lease = new LeaseImpl<C>(this.slot, this.waiter.handler);
                c = 1;
                this.waiter.disposed = true;
                --acquisitions;
            }
            int m4 = (int)Math.min(acquisitions, (long)((SimpleConnectionPool)pool).waiters.size());
            if (m4 > 0) {
                c += m4;
                leases = new LeaseImpl[m4];
                for (int i = 0; i < m4; ++i) {
                    leases[i] = new LeaseImpl<C>(this.slot, ((SimpleConnectionPool)pool).waiters.poll().handler);
                }
            } else {
                leases = null;
            }
            ((Slot)this.slot).usage = c;
            return new Task(){

                @Override
                public void run() {
                    if (lease != null) {
                        lease.emit();
                    }
                    if (leases != null) {
                        for (LeaseImpl lease2 : leases) {
                            lease2.emit();
                        }
                    }
                    slot.result.complete(slot.connection);
                }
            };
        }
    }

    static class Slot<C>
    implements PoolConnector.Listener,
    PoolConnection<C> {
        private final SimpleConnectionPool<C> pool;
        private final EventLoopContext context;
        private final Promise<C> result;
        private PoolWaiter<C> initiator;
        private C connection;
        private int index;
        private int usage;
        private long concurrency;
        private int capacity;

        public Slot(SimpleConnectionPool<C> pool, EventLoopContext context, int index2, int capacity) {
            this.pool = pool;
            this.context = context;
            this.connection = null;
            this.usage = 0;
            this.index = index2;
            this.capacity = capacity;
            this.result = context.promise();
        }

        @Override
        public void onRemove() {
            ((SimpleConnectionPool)this.pool).remove(this);
        }

        @Override
        public void onConcurrencyChange(long concurrency) {
            ((SimpleConnectionPool)this.pool).setConcurrency(this, concurrency);
        }

        @Override
        public ContextInternal context() {
            return this.context;
        }

        @Override
        public C get() {
            return this.connection;
        }

        @Override
        public int usage() {
            return this.usage;
        }

        @Override
        public long available() {
            return this.concurrency - (long)this.usage;
        }

        @Override
        public long concurrency() {
            return this.concurrency;
        }
    }
}

