/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.impl.PartialPooledByteBufAllocator;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.AsyncResolveConnectHelper;
import io.vertx.core.net.impl.NetServerImpl;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.ServerChannelLoadBalancer;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.net.impl.SslChannelProvider;
import io.vertx.core.net.impl.SslContextProvider;
import io.vertx.core.net.impl.SslContextUpdate;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.TCPMetrics;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public abstract class TCPServerBase
implements Closeable,
MetricsProvider {
    private static final Logger log = LoggerFactory.getLogger(NetServerImpl.class);
    protected final Context creatingContext;
    protected final VertxInternal vertx;
    protected final NetServerOptions options;
    private EventLoop eventLoop;
    private BiConsumer<Channel, SslChannelProvider> childHandler;
    private Handler<Channel> worker;
    private volatile boolean listening;
    private ContextInternal listenContext;
    private TCPServerBase actualServer;
    private SSLHelper sslHelper;
    private volatile Future<SslContextUpdate> sslChannelProvider;
    private ServerChannelLoadBalancer channelBalancer;
    private Future<Channel> bindFuture;
    private Set<TCPServerBase> servers;
    private TCPMetrics<?> metrics;
    private volatile int actualPort;

    public TCPServerBase(VertxInternal vertx, NetServerOptions options2) {
        this.vertx = vertx;
        this.options = new NetServerOptions(options2);
        this.creatingContext = vertx.getContext();
    }

    public SslContextProvider sslContextProvider() {
        SslContextUpdate update2 = this.sslChannelProvider.result();
        if (update2 != null) {
            return update2.sslChannelProvider().sslContextProvider();
        }
        return null;
    }

    public int actualPort() {
        TCPServerBase server2 = this.actualServer;
        return server2 != null ? server2.actualPort : this.actualPort;
    }

    protected abstract BiConsumer<Channel, SslChannelProvider> childHandler(ContextInternal var1, SocketAddress var2);

    protected SSLHelper createSSLHelper() {
        return new SSLHelper(this.options, null);
    }

    public Future<Void> updateSSLOptions(SSLOptions options2) {
        TCPServerBase server2 = this.actualServer;
        if (server2 != null && server2 != this) {
            return server2.updateSSLOptions(options2);
        }
        ContextInternal ctx = this.vertx.getOrCreateContext();
        Future<SslContextUpdate> update2 = this.sslHelper.updateSslContext(new SSLOptions(options2), ctx);
        this.sslChannelProvider = update2;
        return update2.transform(ar -> {
            if (ar.failed()) {
                return ctx.failedFuture(ar.cause());
            }
            if (ar.succeeded() && ((SslContextUpdate)ar.result()).error() != null) {
                return ctx.failedFuture(((SslContextUpdate)ar.result()).error());
            }
            return ctx.succeededFuture();
        });
    }

    public Future<TCPServerBase> bind(SocketAddress address) {
        ContextInternal listenContext = this.vertx.getOrCreateContext();
        return this.listen(address, listenContext).map(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Future<Channel> listen(SocketAddress localAddress, ContextInternal context) {
        Map<ServerID, ?> sharedNetServers;
        if (this.listening) {
            throw new IllegalStateException("Listen already called");
        }
        this.listenContext = context;
        this.listening = true;
        this.eventLoop = context.nettyEventLoop();
        Map<ServerID, ?> map2 = sharedNetServers = this.vertx.sharedTCPServers(this.getClass());
        synchronized (map2) {
            SocketAddress bindAddress;
            boolean shared;
            TCPServerBase main2;
            ServerID id;
            String hostOrPath;
            this.actualPort = localAddress.port();
            String string2 = hostOrPath = localAddress.isInetSocket() ? localAddress.host() : localAddress.path();
            if (this.actualPort > 0 || localAddress.isDomainSocket()) {
                id = new ServerID(this.actualPort, hostOrPath);
                main2 = (TCPServerBase)sharedNetServers.get(id);
                shared = true;
                bindAddress = localAddress;
            } else if (this.actualPort < 0) {
                id = new ServerID(this.actualPort, hostOrPath + "/" + -this.actualPort);
                main2 = (TCPServerBase)sharedNetServers.get(id);
                shared = true;
                bindAddress = SocketAddress.inetSocketAddress(0, localAddress.host());
            } else {
                id = new ServerID(this.actualPort, hostOrPath);
                main2 = null;
                shared = false;
                bindAddress = localAddress;
            }
            PromiseInternal<Channel> promise2 = this.listenContext.promise();
            if (main2 == null) {
                this.actualServer = this;
                this.bindFuture = promise2;
                this.sslHelper = this.createSSLHelper();
                this.childHandler = this.childHandler(this.listenContext, localAddress);
                this.worker = ch -> this.childHandler.accept((Channel)ch, this.sslChannelProvider.result().sslChannelProvider());
                this.servers = new HashSet<TCPServerBase>();
                this.servers.add(this);
                this.channelBalancer = new ServerChannelLoadBalancer(this.vertx.getAcceptorEventLoopGroup().next());
                if (shared) {
                    sharedNetServers.put(id, this);
                }
                this.listenContext.addCloseHook(this);
                this.sslChannelProvider = this.sslHelper.updateSslContext(this.options.getSslOptions(), this.listenContext).onComplete(ar -> {
                    if (ar.succeeded()) {
                        this.channelBalancer.addWorker(this.eventLoop, this.worker);
                        ServerBootstrap bootstrap = new ServerBootstrap();
                        bootstrap.group(this.vertx.getAcceptorEventLoopGroup(), this.channelBalancer.workers());
                        if (this.options.isSsl()) {
                            bootstrap.childOption(ChannelOption.ALLOCATOR, PartialPooledByteBufAllocator.INSTANCE);
                        } else {
                            bootstrap.childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
                        }
                        bootstrap.childHandler(this.channelBalancer);
                        this.applyConnectionOptions(localAddress.isDomainSocket(), bootstrap);
                        io.netty.util.concurrent.Future<Channel> bindFuture = AsyncResolveConnectHelper.doBind(this.vertx, bindAddress, bootstrap);
                        bindFuture.addListener(res -> {
                            if (res.isSuccess()) {
                                Channel ch = (Channel)res.getNow();
                                log.trace("Net server listening on " + hostOrPath + ":" + ch.localAddress());
                                if (shared) {
                                    ch.closeFuture().addListener(channelFuture -> {
                                        Map map2 = sharedNetServers;
                                        synchronized (map2) {
                                            sharedNetServers.remove(id);
                                        }
                                    });
                                }
                                if (bindAddress.isInetSocket()) {
                                    this.actualPort = ((InetSocketAddress)ch.localAddress()).getPort();
                                }
                                this.metrics = this.createMetrics(localAddress);
                                promise2.complete(ch);
                            } else {
                                promise2.fail(res.cause());
                            }
                        });
                    } else {
                        promise2.fail(ar.cause());
                    }
                });
                this.bindFuture.onFailure(err -> {
                    if (shared) {
                        Map map2 = sharedNetServers;
                        synchronized (map2) {
                            sharedNetServers.remove(id);
                        }
                    }
                    this.listening = false;
                });
                return this.bindFuture;
            }
            this.actualServer = main2;
            this.metrics = main2.metrics;
            this.sslChannelProvider = main2.sslChannelProvider;
            this.childHandler = this.childHandler(this.listenContext, localAddress);
            this.worker = ch -> this.childHandler.accept((Channel)ch, this.sslChannelProvider.result().sslChannelProvider());
            this.actualServer.servers.add(this);
            this.actualServer.channelBalancer.addWorker(this.eventLoop, this.worker);
            this.listenContext.addCloseHook(this);
            main2.bindFuture.onComplete(promise2);
            return promise2.future();
        }
    }

    public boolean isListening() {
        return this.listening;
    }

    protected TCPMetrics<?> createMetrics(SocketAddress localAddress) {
        return null;
    }

    private void applyConnectionOptions(boolean domainSocket, ServerBootstrap bootstrap) {
        this.vertx.transport().configure(this.options, domainSocket, bootstrap);
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    @Override
    public synchronized TCPMetrics<?> getMetrics() {
        return this.actualServer != null ? this.actualServer.metrics : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close(Promise<Void> completion) {
        Map<ServerID, ?> servers;
        if (!this.listening) {
            completion.complete();
            return;
        }
        this.listening = false;
        this.listenContext.removeCloseHook(this);
        Map<ServerID, ?> map2 = servers = this.vertx.sharedTCPServers(this.getClass());
        synchronized (map2) {
            ServerChannelLoadBalancer balancer = this.actualServer.channelBalancer;
            balancer.removeWorker(this.eventLoop, this.worker);
            if (balancer.hasHandlers()) {
                completion.complete();
            } else {
                this.actualServer.actualClose(completion);
            }
        }
    }

    private void actualClose(Promise<Void> done) {
        this.channelBalancer.close();
        this.bindFuture.onComplete(ar -> {
            if (ar.succeeded()) {
                Channel channel = (Channel)ar.result();
                ChannelFuture a = channel.close();
                if (this.metrics != null) {
                    a.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)cg -> this.metrics.close()));
                }
                a.addListener((PromiseInternal)done);
            } else {
                done.complete();
            }
        });
    }

    public abstract Future<Void> close();
}

