/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslProvider;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.ClientOptionsBase;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.SslChannelProvider;
import io.vertx.core.net.impl.SslContextProvider;
import io.vertx.core.net.impl.SslContextUpdate;
import io.vertx.core.spi.tls.DefaultSslContextFactory;
import io.vertx.core.spi.tls.SslContextFactory;
import java.io.ByteArrayInputStream;
import java.security.cert.CRL;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SSLHelper {
    static final EnumMap<ClientAuth, io.netty.handler.ssl.ClientAuth> CLIENT_AUTH_MAPPING = new EnumMap(ClientAuth.class);
    private final boolean ssl;
    private final boolean sni;
    private final boolean trustAll;
    private final ClientAuth clientAuth;
    private final boolean client;
    private final boolean useAlpn;
    private final String endpointIdentificationAlgorithm;
    private final SSLEngineOptions sslEngineOptions;
    private final List<String> applicationProtocols;
    private KeyManagerFactory keyManagerFactory;
    private TrustManagerFactory trustManagerFactory;
    private Function<String, KeyManagerFactory> keyManagerFactoryMapper;
    private Function<String, TrustManager[]> trustManagerMapper;
    private List<CRL> crls;
    private Future<CachedProvider> cachedProvider;

    public static SSLEngineOptions resolveEngineOptions(SSLEngineOptions engineOptions, boolean useAlpn) {
        if (engineOptions == null && useAlpn) {
            if (JdkSSLEngineOptions.isAlpnAvailable()) {
                engineOptions = new JdkSSLEngineOptions();
            } else if (OpenSSLEngineOptions.isAlpnAvailable()) {
                engineOptions = new OpenSSLEngineOptions();
            }
        }
        if (engineOptions == null) {
            engineOptions = new JdkSSLEngineOptions();
        } else if (engineOptions instanceof OpenSSLEngineOptions && !OpenSsl.isAvailable()) {
            VertxException ex = new VertxException("OpenSSL is not available");
            Throwable cause = OpenSsl.unavailabilityCause();
            if (cause != null) {
                ex.initCause(cause);
            }
            throw ex;
        }
        if (useAlpn) {
            if (engineOptions instanceof JdkSSLEngineOptions && !JdkSSLEngineOptions.isAlpnAvailable()) {
                throw new VertxException("ALPN not available for JDK SSL/TLS engine");
            }
            if (engineOptions instanceof OpenSSLEngineOptions && !OpenSSLEngineOptions.isAlpnAvailable()) {
                throw new VertxException("ALPN is not available for OpenSSL SSL/TLS engine");
            }
        }
        return engineOptions;
    }

    public SSLHelper(TCPSSLOptions options2, List<String> applicationProtocols) {
        this.sslEngineOptions = options2.getSslEngineOptions();
        this.ssl = options2.isSsl();
        this.useAlpn = options2.isUseAlpn();
        this.client = options2 instanceof ClientOptionsBase;
        this.trustAll = options2 instanceof ClientOptionsBase && ((ClientOptionsBase)options2).isTrustAll();
        this.clientAuth = options2 instanceof NetServerOptions ? ((NetServerOptions)options2).getClientAuth() : ClientAuth.NONE;
        this.endpointIdentificationAlgorithm = options2 instanceof NetClientOptions ? ((NetClientOptions)options2).getHostnameVerificationAlgorithm() : "";
        this.sni = options2 instanceof NetServerOptions && ((NetServerOptions)options2).isSni();
        this.applicationProtocols = applicationProtocols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<SslContextUpdate> updateSslContext(SSLOptions options2, ContextInternal ctx) {
        SSLHelper sSLHelper = this;
        synchronized (sSLHelper) {
            this.cachedProvider = this.cachedProvider == null ? this.buildChannelProvider(options2, ctx).map(a -> new CachedProvider(options2, (SslChannelProvider)a, null)) : this.cachedProvider.transform(prev2 -> {
                if (prev2.succeeded() && ((CachedProvider)prev2.result()).options.equals(options2)) {
                    return Future.succeededFuture(prev2.result());
                }
                return this.buildChannelProvider(options2, ctx).transform(ar -> {
                    if (ar.succeeded()) {
                        return ctx.succeededFuture(new CachedProvider(options2, (SslChannelProvider)ar.result(), null));
                    }
                    if (prev2.succeeded()) {
                        return ctx.succeededFuture(new CachedProvider(((CachedProvider)prev2.result()).options, ((CachedProvider)prev2.result()).sslChannelProvider, ar.cause()));
                    }
                    return ctx.failedFuture(prev2.cause());
                });
            });
            return this.cachedProvider.map(c -> new SslContextUpdate(c.sslChannelProvider, c.failure));
        }
    }

    public Future<SslContextProvider> buildContextProvider(SSLOptions sslOptions, ContextInternal ctx) {
        return this.build(new SSLOptions(sslOptions), ctx).map(EngineConfig::sslContextProvider);
    }

    public Future<SslChannelProvider> buildChannelProvider(SSLOptions sslOptions, ContextInternal ctx) {
        return this.build(new SSLOptions(sslOptions), ctx).map(c -> new SslChannelProvider(c.sslContextProvider(), ((EngineConfig)c).sslOptions.getSslHandshakeTimeout(), ((EngineConfig)c).sslOptions.getSslHandshakeTimeoutUnit(), this.sni, this.trustAll, this.useAlpn, ctx.owner().getInternalWorkerPool().executor(), ((EngineConfig)c).useWorkerPool));
    }

    private Future<EngineConfig> build(SSLOptions sslOptions, ContextInternal ctx) {
        Future<EngineConfig> sslContextFactorySupplier;
        KeyCertOptions keyCertOptions = sslOptions.getKeyCertOptions();
        TrustOptions trustOptions = sslOptions.getTrustOptions();
        if (keyCertOptions != null || trustOptions != null || this.trustAll || this.ssl) {
            Promise promise2 = Promise.promise();
            sslContextFactorySupplier = promise2.future();
            ctx.executeBlockingInternal(p -> {
                try {
                    if (sslOptions.getKeyCertOptions() != null) {
                        this.keyManagerFactory = sslOptions.getKeyCertOptions().getKeyManagerFactory(ctx.owner());
                        this.keyManagerFactoryMapper = sslOptions.getKeyCertOptions().keyManagerFactoryMapper(ctx.owner());
                    }
                    if (sslOptions.getTrustOptions() != null) {
                        this.trustManagerFactory = sslOptions.getTrustOptions().getTrustManagerFactory(ctx.owner());
                        this.trustManagerMapper = sslOptions.getTrustOptions().trustManagerMapper(ctx.owner());
                    }
                    this.crls = new ArrayList<CRL>();
                    ArrayList<Buffer> tmp = new ArrayList<Buffer>();
                    if (sslOptions.getCrlPaths() != null) {
                        tmp.addAll(sslOptions.getCrlPaths().stream().map(path2 -> ctx.owner().resolveFile((String)path2).getAbsolutePath()).map(ctx.owner().fileSystem()::readFileBlocking).collect(Collectors.toList()));
                    }
                    if (sslOptions.getCrlValues() != null) {
                        tmp.addAll(sslOptions.getCrlValues());
                    }
                    CertificateFactory certificatefactory = CertificateFactory.getInstance("X.509");
                    for (Buffer crlValue : tmp) {
                        this.crls.addAll(certificatefactory.generateCRLs(new ByteArrayInputStream(crlValue.getBytes())));
                    }
                }
                catch (Exception e2) {
                    p.fail(e2);
                    return;
                }
                if (this.client || sslOptions.getKeyCertOptions() != null) {
                    p.complete();
                } else {
                    p.fail("Key/certificate is mandatory for SSL");
                }
            }).compose(v2 -> ctx.executeBlockingInternal(p -> {
                boolean useWorkerPool;
                Supplier<SslContextFactory> supplier;
                try {
                    SSLEngineOptions resolvedEngineOptions = SSLHelper.resolveEngineOptions(this.sslEngineOptions, this.useAlpn);
                    supplier = resolvedEngineOptions::sslContextFactory;
                    useWorkerPool = resolvedEngineOptions.getUseWorkerThread();
                }
                catch (Exception e2) {
                    p.fail(e2);
                    return;
                }
                p.complete(new EngineConfig(sslOptions, supplier, useWorkerPool));
            })).onComplete(promise2);
        } else {
            sslContextFactorySupplier = Future.succeededFuture(new EngineConfig(sslOptions, () -> new DefaultSslContextFactory(SslProvider.JDK, false), false));
        }
        return sslContextFactorySupplier;
    }

    static {
        CLIENT_AUTH_MAPPING.put(ClientAuth.REQUIRED, io.netty.handler.ssl.ClientAuth.REQUIRE);
        CLIENT_AUTH_MAPPING.put(ClientAuth.REQUEST, io.netty.handler.ssl.ClientAuth.OPTIONAL);
        CLIENT_AUTH_MAPPING.put(ClientAuth.NONE, io.netty.handler.ssl.ClientAuth.NONE);
    }

    private class EngineConfig {
        private final SSLOptions sslOptions;
        private final Supplier<SslContextFactory> supplier;
        private final boolean useWorkerPool;

        public EngineConfig(SSLOptions sslOptions, Supplier<SslContextFactory> supplier, boolean useWorkerPool) {
            this.sslOptions = sslOptions;
            this.supplier = supplier;
            this.useWorkerPool = useWorkerPool;
        }

        SslContextProvider sslContextProvider() {
            return new SslContextProvider(SSLHelper.this.clientAuth, SSLHelper.this.endpointIdentificationAlgorithm, SSLHelper.this.applicationProtocols, this.sslOptions.getEnabledCipherSuites(), this.sslOptions.getEnabledSecureTransportProtocols(), SSLHelper.this.keyManagerFactory, SSLHelper.this.keyManagerFactoryMapper, SSLHelper.this.trustManagerFactory, SSLHelper.this.trustManagerMapper, SSLHelper.this.crls, this.supplier);
        }
    }

    private static class CachedProvider {
        final SSLOptions options;
        final SslChannelProvider sslChannelProvider;
        final Throwable failure;

        CachedProvider(SSLOptions options2, SslChannelProvider sslChannelProvider, Throwable failure) {
            this.options = options2;
            this.sslChannelProvider = sslChannelProvider;
            this.failure = failure;
        }
    }
}

