/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.VoidChannelPromise;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedNioFile;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SslHandshakeCompletionHandler;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.NetworkMetrics;
import io.vertx.core.spi.metrics.TCPMetrics;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

public abstract class ConnectionBase {
    private static final long METRICS_REPORTED_BYTES_LOW_MASK = 4095L;
    private static final long METRICS_REPORTED_BYTES_HIGH_MASK = -4096L;
    public static final VertxException CLOSED_EXCEPTION = new VertxException("Connection was closed", true);
    public static final AttributeKey<SocketAddress> REMOTE_ADDRESS_OVERRIDE = AttributeKey.valueOf("RemoteAddressOverride");
    public static final AttributeKey<SocketAddress> LOCAL_ADDRESS_OVERRIDE = AttributeKey.valueOf("LocalAddressOverride");
    private static final Logger log = LoggerFactory.getLogger(ConnectionBase.class);
    private static final int MAX_REGION_SIZE = 0x100000;
    public final VoidChannelPromise voidPromise;
    protected final VertxInternal vertx;
    protected final ChannelHandlerContext chctx;
    protected final ContextInternal context;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> closeHandler;
    private int writeInProgress;
    private Object metric;
    private SocketAddress remoteAddress;
    private SocketAddress realRemoteAddress;
    private SocketAddress localAddress;
    private SocketAddress realLocalAddress;
    private ChannelPromise closePromise;
    private Future<Void> closeFuture;
    private long remainingBytesRead;
    private long remainingBytesWritten;
    private boolean read;
    private boolean needsFlush;
    private boolean closed;

    protected ConnectionBase(ContextInternal context, ChannelHandlerContext chctx) {
        this.vertx = context.owner();
        this.chctx = chctx;
        this.context = context;
        this.voidPromise = new VoidChannelPromise(chctx.channel(), false);
        this.closePromise = chctx.newPromise();
        PromiseInternal p = context.promise();
        this.closePromise.addListener(p);
        this.closeFuture = p.future();
        this.closeFuture.onComplete(this::checkCloseHandler);
    }

    public Future<Void> closeFuture() {
        return this.closeFuture;
    }

    public void fail(Throwable error2) {
        this.chctx.pipeline().fireExceptionCaught(error2);
    }

    void close(ChannelPromise promise2) {
        this.closePromise.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)l -> {
            if (l.isSuccess()) {
                promise2.setSuccess();
            } else {
                promise2.setFailure(l.cause());
            }
        }));
        this.close();
    }

    final void endReadAndFlush() {
        if (this.read) {
            this.read = false;
            if (this.needsFlush) {
                this.needsFlush = false;
                this.chctx.flush();
            }
        }
    }

    final void read(Object msg) {
        this.read = true;
        if (Metrics.METRICS_ENABLED) {
            this.reportBytesRead(msg);
        }
        this.handleMessage(msg);
    }

    private void write(Object msg, Boolean flush2, ChannelPromise promise2) {
        if (Metrics.METRICS_ENABLED) {
            this.reportsBytesWritten(msg);
        }
        boolean writeAndFlush = flush2 == null ? !this.read : flush2;
        boolean bl = this.needsFlush = !writeAndFlush;
        if (writeAndFlush) {
            this.chctx.writeAndFlush(msg, promise2);
        } else {
            this.chctx.write(msg, promise2);
        }
    }

    private void writeClose(PromiseInternal<Void> promise2) {
        if (this.closed) {
            promise2.complete();
            return;
        }
        this.closed = true;
        ChannelPromise channelPromise = this.chctx.newPromise().addListener(f -> this.chctx.close().addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)promise2));
        this.writeToChannel(Unpooled.EMPTY_BUFFER, true, channelPromise);
    }

    private ChannelPromise wrap(FutureListener<Void> handler) {
        ChannelPromise promise2 = this.chctx.newPromise();
        promise2.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)handler);
        return promise2;
    }

    public final void writeToChannel(Object msg, FutureListener<Void> listener) {
        this.writeToChannel(msg, listener == null ? this.voidPromise : this.wrap(listener));
    }

    public final void writeToChannel(Object msg, ChannelPromise promise2) {
        this.writeToChannel(msg, false, promise2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeToChannel(Object msg, boolean forceFlush, ChannelPromise promise2) {
        ConnectionBase connectionBase = this;
        synchronized (connectionBase) {
            if (!this.chctx.executor().inEventLoop() || this.writeInProgress > 0) {
                this.queueForWrite(msg, forceFlush, promise2);
                return;
            }
        }
        this.write(msg, forceFlush ? Boolean.valueOf(true) : null, promise2);
    }

    private void queueForWrite(Object msg, boolean forceFlush, ChannelPromise promise2) {
        ++this.writeInProgress;
        this.chctx.executor().execute(() -> {
            boolean flush2;
            if (forceFlush) {
                flush2 = true;
            } else {
                ConnectionBase connectionBase = this;
                synchronized (connectionBase) {
                    flush2 = --this.writeInProgress == 0;
                }
            }
            this.write(msg, flush2, promise2);
        });
    }

    public void writeToChannel(Object obj2) {
        this.writeToChannel(obj2, this.voidPromise);
    }

    public final void flush() {
        this.flush(this.voidPromise);
    }

    public final void flush(ChannelPromise promise2) {
        this.writeToChannel(Unpooled.EMPTY_BUFFER, true, promise2);
    }

    public boolean isNotWritable() {
        return !this.chctx.channel().isWritable();
    }

    public Future<Void> close() {
        PromiseInternal<Void> promise2 = this.context.promise();
        EventExecutor exec = this.chctx.executor();
        if (exec.inEventLoop()) {
            this.writeClose(promise2);
        } else {
            exec.execute(() -> this.writeClose(promise2));
        }
        return promise2.future();
    }

    public final void close(Handler<AsyncResult<Void>> handler) {
        this.close().onComplete(handler);
    }

    public synchronized ConnectionBase closeHandler(Handler<Void> handler) {
        this.closeHandler = handler;
        return this;
    }

    public synchronized ConnectionBase exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    protected synchronized Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    public void doPause() {
        this.chctx.channel().config().setAutoRead(false);
    }

    public void doResume() {
        this.chctx.channel().config().setAutoRead(true);
    }

    public void doSetWriteQueueMaxSize(int size) {
        ChannelConfig config = this.chctx.channel().config();
        config.setWriteBufferWaterMark(new WriteBufferWaterMark(size / 2, size));
    }

    public final Channel channel() {
        return this.chctx.channel();
    }

    public final ChannelHandlerContext channelHandlerContext() {
        return this.chctx;
    }

    public final ContextInternal getContext() {
        return this.context;
    }

    public final synchronized void metric(Object metric2) {
        this.metric = metric2;
    }

    public final synchronized Object metric() {
        return this.metric;
    }

    public abstract NetworkMetrics metrics();

    protected void handleException(Throwable t3) {
        NetworkMetrics metrics = this.metrics();
        if (metrics != null) {
            metrics.exceptionOccurred(this.metric, this.remoteAddress(), t3);
        }
        this.context.emit(t3, err -> {
            Handler<Throwable> handler;
            ConnectionBase connectionBase = this;
            synchronized (connectionBase) {
                handler = this.exceptionHandler;
            }
            if (handler != null) {
                handler.handle((Throwable)err);
            } else if (log.isDebugEnabled()) {
                log.error(t3.getMessage(), t3);
            } else {
                log.error(t3.getMessage());
            }
        });
    }

    protected void handleClosed() {
        this.closed = true;
        NetworkMetrics metrics = this.metrics();
        if (metrics != null) {
            this.flushBytesRead();
            this.flushBytesWritten();
            if (metrics instanceof TCPMetrics) {
                ((TCPMetrics)metrics).disconnected(this.metric(), this.remoteAddress());
            }
        }
        this.closePromise.setSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCloseHandler(AsyncResult<Void> ar) {
        Handler<Void> handler;
        ConnectionBase connectionBase = this;
        synchronized (connectionBase) {
            handler = this.closeHandler;
        }
        if (handler != null) {
            handler.handle(null);
        }
    }

    protected void handleEvent(Object evt) {
        ReferenceCountUtil.release(evt);
    }

    protected void handleIdle(IdleStateEvent event) {
        log.debug("The connection will be closed due to timeout");
        this.chctx.close();
    }

    protected abstract void handleInterestedOpsChanged();

    protected boolean supportsFileRegion() {
        return this.vertx.transport().supportFileRegion() && !this.isSsl();
    }

    public final void reportBytesRead(Object msg) {
        NetworkMetrics metrics = this.metrics();
        if (metrics != null) {
            this.doReportBytesRead(msg, metrics);
        }
    }

    private void doReportBytesRead(Object msg, NetworkMetrics metrics) {
        long bytes2 = this.remainingBytesRead;
        long numberOfBytes = this.sizeof(msg);
        long val2 = (bytes2 += numberOfBytes) & 0xFFFFFFFFFFFFF000L;
        if (val2 > 0L) {
            bytes2 &= 0xFFFL;
            metrics.bytesRead(this.metric(), this.remoteAddress(), val2);
        }
        this.remainingBytesRead = bytes2;
    }

    protected long sizeof(Object msg) {
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).readableBytes();
        }
        return 0L;
    }

    public final void reportBytesRead(long numberOfBytes) {
        if (numberOfBytes < 0L) {
            throw new IllegalArgumentException();
        }
        NetworkMetrics metrics = this.metrics();
        if (metrics != null) {
            long bytes2 = this.remainingBytesRead;
            long val2 = (bytes2 += numberOfBytes) & 0xFFFFFFFFFFFFF000L;
            if (val2 > 0L) {
                bytes2 &= 0xFFFL;
                metrics.bytesRead(this.metric(), this.remoteAddress(), val2);
            }
            this.remainingBytesRead = bytes2;
        }
    }

    public final void reportsBytesWritten(Object msg) {
        NetworkMetrics metrics = this.metrics();
        if (metrics != null) {
            long numberOfBytes = this.sizeof(msg);
            long bytes2 = this.remainingBytesWritten;
            long val2 = (bytes2 += numberOfBytes) & 0xFFFFFFFFFFFFF000L;
            if (val2 > 0L) {
                bytes2 &= 0xFFFL;
                metrics.bytesWritten(this.metric, this.remoteAddress(), val2);
            }
            this.remainingBytesWritten = bytes2;
        }
    }

    public final void reportBytesWritten(long numberOfBytes) {
        if (numberOfBytes < 0L) {
            throw new IllegalArgumentException();
        }
        NetworkMetrics metrics = this.metrics();
        if (metrics != null) {
            long bytes2 = this.remainingBytesWritten;
            long val2 = (bytes2 += numberOfBytes) & 0xFFFFFFFFFFFFF000L;
            if (val2 > 0L) {
                bytes2 &= 0xFFFL;
                metrics.bytesWritten(this.metric, this.remoteAddress(), val2);
            }
            this.remainingBytesWritten = bytes2;
        }
    }

    public void flushBytesRead() {
        long val2;
        NetworkMetrics metrics = this.metrics();
        if (metrics != null && (val2 = this.remainingBytesRead) > 0L) {
            this.remainingBytesRead = 0L;
            metrics.bytesRead(this.metric(), this.remoteAddress(), val2);
        }
    }

    public void flushBytesWritten() {
        long val2;
        NetworkMetrics metrics = this.metrics();
        if (metrics != null && (val2 = this.remainingBytesWritten) > 0L) {
            this.remainingBytesWritten = 0L;
            metrics.bytesWritten(this.metric(), this.remoteAddress(), val2);
        }
    }

    private void sendFileRegion(RandomAccessFile file2, long offset, long length, ChannelPromise writeFuture) {
        if (length < 0x100000L) {
            this.writeToChannel((Object)new DefaultFileRegion(file2.getChannel(), offset, length), writeFuture);
        } else {
            ChannelPromise promise2 = this.chctx.newPromise();
            DefaultFileRegion region = new DefaultFileRegion(file2.getChannel(), offset, 0x100000L);
            region.retain();
            this.writeToChannel((Object)region, promise2);
            promise2.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)future2 -> {
                if (future2.isSuccess()) {
                    this.sendFileRegion(file2, offset + 0x100000L, length - 0x100000L, writeFuture);
                } else {
                    log.error(future2.cause().getMessage(), future2.cause());
                    writeFuture.setFailure(future2.cause());
                }
            }));
        }
    }

    public final ChannelFuture sendFile(RandomAccessFile raf, long offset, long length) throws IOException {
        ChannelPromise writeFuture = this.chctx.newPromise();
        if (!this.supportsFileRegion()) {
            this.writeToChannel((Object)new ChunkedNioFile(raf.getChannel(), offset, length, 8192), writeFuture);
        } else {
            this.sendFileRegion(raf, offset, length, writeFuture);
        }
        if (writeFuture != null) {
            writeFuture.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)fut -> raf.close()));
        } else {
            raf.close();
        }
        return writeFuture;
    }

    public boolean isSsl() {
        return this.chctx.pipeline().get(SslHandler.class) != null;
    }

    public SSLSession sslSession() {
        ChannelHandlerContext sslHandlerContext = this.chctx.pipeline().context(SslHandler.class);
        if (sslHandlerContext != null) {
            SslHandler sslHandler = (SslHandler)sslHandlerContext.handler();
            return sslHandler.engine().getSession();
        }
        return null;
    }

    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        SSLSession session = this.sslSession();
        if (session != null) {
            return session.getPeerCertificateChain();
        }
        return null;
    }

    public List<Certificate> peerCertificates() throws SSLPeerUnverifiedException {
        SSLSession session = this.sslSession();
        if (session != null) {
            return Arrays.asList(session.getPeerCertificates());
        }
        return null;
    }

    public String indicatedServerName() {
        if (this.chctx.channel().hasAttr(SslHandshakeCompletionHandler.SERVER_NAME_ATTR)) {
            return this.chctx.channel().attr(SslHandshakeCompletionHandler.SERVER_NAME_ATTR).get();
        }
        return null;
    }

    public ChannelPromise channelFuture() {
        return this.chctx.newPromise();
    }

    public String remoteName() {
        java.net.SocketAddress addr = this.chctx.channel().remoteAddress();
        if (addr instanceof InetSocketAddress) {
            return ((InetSocketAddress)addr).getHostString();
        }
        return null;
    }

    private SocketAddress channelRemoteAddress() {
        java.net.SocketAddress addr = this.chctx.channel().remoteAddress();
        return addr != null ? this.vertx.transport().convert(addr) : null;
    }

    private SocketAddress socketAdressOverride(AttributeKey<SocketAddress> key2) {
        Channel ch = this.chctx.channel();
        return ch.hasAttr(key2) ? (SocketAddress)ch.attr(key2).getAndSet(null) : null;
    }

    public SocketAddress remoteAddress() {
        SocketAddress address = this.remoteAddress;
        if (address == null) {
            address = this.socketAdressOverride(REMOTE_ADDRESS_OVERRIDE);
            if (address == null) {
                address = this.channelRemoteAddress();
            }
            if (address != null) {
                this.remoteAddress = address;
            }
        }
        return address;
    }

    public SocketAddress remoteAddress(boolean real) {
        if (real) {
            SocketAddress address = this.realRemoteAddress;
            if (address == null) {
                address = this.channelRemoteAddress();
            }
            if (address != null) {
                this.realRemoteAddress = address;
            }
            return address;
        }
        return this.remoteAddress();
    }

    private SocketAddress channelLocalAddress() {
        java.net.SocketAddress addr = this.chctx.channel().localAddress();
        if (addr == null && this.channel().getClass().getSimpleName().endsWith("DomainSocketChannel")) {
            return SocketAddress.domainSocketAddress("");
        }
        return addr != null ? this.vertx.transport().convert(addr) : null;
    }

    public SocketAddress localAddress() {
        SocketAddress address = this.localAddress;
        if (address == null) {
            address = this.socketAdressOverride(LOCAL_ADDRESS_OVERRIDE);
            if (address == null) {
                address = this.channelLocalAddress();
            }
            if (address != null) {
                this.localAddress = address;
            }
        }
        return address;
    }

    public SocketAddress localAddress(boolean real) {
        if (real) {
            SocketAddress address = this.realLocalAddress;
            if (address == null) {
                address = this.channelLocalAddress();
            }
            if (address != null) {
                this.realLocalAddress = address;
            }
            return address;
        }
        return this.localAddress();
    }

    protected void handleMessage(Object msg) {
    }
}

