/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class AsyncResolveConnectHelper {
    public static io.netty.util.concurrent.Future<Channel> doBind(VertxInternal vertx, SocketAddress socketAddress, ServerBootstrap bootstrap) {
        Promise<Channel> promise2 = vertx.getAcceptorEventLoopGroup().next().newPromise();
        try {
            bootstrap.channelFactory(vertx.transport().serverChannelFactory(socketAddress.isDomainSocket()));
        }
        catch (Exception e2) {
            promise2.setFailure(e2);
            return promise2;
        }
        if (socketAddress.isDomainSocket()) {
            java.net.SocketAddress converted = vertx.transport().convert(socketAddress);
            ChannelFuture future2 = bootstrap.bind(converted);
            future2.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)f -> {
                if (f.isSuccess()) {
                    promise2.setSuccess(future2.channel());
                } else {
                    promise2.setFailure(f.cause());
                }
            }));
        } else {
            SocketAddressImpl impl2 = (SocketAddressImpl)socketAddress;
            Handler<AsyncResult<InetAddress>> cont = res -> {
                if (res.succeeded()) {
                    InetSocketAddress t3 = new InetSocketAddress((InetAddress)res.result(), socketAddress.port());
                    ChannelFuture future2 = bootstrap.bind(t3);
                    future2.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)f -> {
                        if (f.isSuccess()) {
                            promise2.setSuccess(future2.channel());
                        } else {
                            promise2.setFailure(f.cause());
                        }
                    }));
                } else {
                    promise2.setFailure(res.cause());
                }
            };
            if (impl2.ipAddress() != null) {
                cont.handle(Future.succeededFuture(impl2.ipAddress()));
            } else {
                vertx.resolveAddress(socketAddress.host(), cont);
            }
        }
        return promise2;
    }
}

