/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.net.SSLOptions;
import java.util.Base64;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class SSLOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, SSLOptions obj2) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "crlPaths": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj2.addCrlPath((String)item);
                        }
                    });
                    break;
                }
                case "crlValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj2.addCrlValue(Buffer.buffer(BASE64_DECODER.decode((String)item)));
                        }
                    });
                    break;
                }
                case "enabledCipherSuites": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj2.addEnabledCipherSuite((String)item);
                        }
                    });
                    break;
                }
                case "enabledSecureTransportProtocols": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<String> list = new LinkedHashSet<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj2.setEnabledSecureTransportProtocols(list);
                    break;
                }
                case "sslHandshakeTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setSslHandshakeTimeout(((Number)member.getValue()).longValue());
                    break;
                }
                case "sslHandshakeTimeoutUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setSslHandshakeTimeoutUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "useAlpn": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setUseAlpn((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(SSLOptions obj2, JsonObject json) {
        SSLOptionsConverter.toJson(obj2, json.getMap());
    }

    static void toJson(SSLOptions obj2, Map<String, Object> json) {
        JsonArray array2;
        if (obj2.getCrlPaths() != null) {
            array2 = new JsonArray();
            obj2.getCrlPaths().forEach(item -> array2.add(item));
            json.put("crlPaths", array2);
        }
        if (obj2.getCrlValues() != null) {
            array2 = new JsonArray();
            obj2.getCrlValues().forEach(item -> array2.add(BASE64_ENCODER.encodeToString(item.getBytes())));
            json.put("crlValues", array2);
        }
        if (obj2.getEnabledCipherSuites() != null) {
            array2 = new JsonArray();
            obj2.getEnabledCipherSuites().forEach(item -> array2.add(item));
            json.put("enabledCipherSuites", array2);
        }
        if (obj2.getEnabledSecureTransportProtocols() != null) {
            array2 = new JsonArray();
            obj2.getEnabledSecureTransportProtocols().forEach(item -> array2.add(item));
            json.put("enabledSecureTransportProtocols", array2);
        }
        json.put("sslHandshakeTimeout", obj2.getSslHandshakeTimeout());
        if (obj2.getSslHandshakeTimeoutUnit() != null) {
            json.put("sslHandshakeTimeoutUnit", obj2.getSslHandshakeTimeoutUnit().name());
        }
        json.put("useAlpn", obj2.isUseAlpn());
    }
}

