/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.net.PfxOptions;
import java.util.Base64;
import java.util.Map;

public class PfxOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, PfxOptions obj2) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "alias": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setAlias((String)member.getValue());
                    break;
                }
                case "aliasPassword": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setAliasPassword((String)member.getValue());
                    break;
                }
                case "password": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setPassword((String)member.getValue());
                    break;
                }
                case "path": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setPath((String)member.getValue());
                    break;
                }
                case "value": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setValue(Buffer.buffer(BASE64_DECODER.decode((String)member.getValue())));
                }
            }
        }
    }

    static void toJson(PfxOptions obj2, JsonObject json) {
        PfxOptionsConverter.toJson(obj2, json.getMap());
    }

    static void toJson(PfxOptions obj2, Map<String, Object> json) {
        if (obj2.getAlias() != null) {
            json.put("alias", obj2.getAlias());
        }
        if (obj2.getAliasPassword() != null) {
            json.put("aliasPassword", obj2.getAliasPassword());
        }
        if (obj2.getPassword() != null) {
            json.put("password", obj2.getPassword());
        }
        if (obj2.getPath() != null) {
            json.put("path", obj2.getPath());
        }
        if (obj2.getValue() != null) {
            json.put("value", BASE64_ENCODER.encodeToString(obj2.getValue().getBytes()));
        }
    }
}

