/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.net.PemKeyCertOptions;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;

public class PemKeyCertOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, PemKeyCertOptions obj2) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "certPath": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setCertPath((String)member.getValue());
                    break;
                }
                case "certPaths": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj2.setCertPaths(list);
                    break;
                }
                case "certValue": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setCertValue(Buffer.buffer(BASE64_DECODER.decode((String)member.getValue())));
                    break;
                }
                case "certValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)((Object)Buffer.buffer(BASE64_DECODER.decode((String)item))));
                        }
                    });
                    obj2.setCertValues(list);
                    break;
                }
                case "keyPath": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setKeyPath((String)member.getValue());
                    break;
                }
                case "keyPaths": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj2.setKeyPaths(list);
                    break;
                }
                case "keyValue": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setKeyValue(Buffer.buffer(BASE64_DECODER.decode((String)member.getValue())));
                    break;
                }
                case "keyValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)((Object)Buffer.buffer(BASE64_DECODER.decode((String)item))));
                        }
                    });
                    obj2.setKeyValues(list);
                }
            }
        }
    }

    static void toJson(PemKeyCertOptions obj2, JsonObject json) {
        PemKeyCertOptionsConverter.toJson(obj2, json.getMap());
    }

    static void toJson(PemKeyCertOptions obj2, Map<String, Object> json) {
        JsonArray array2;
        if (obj2.getCertPaths() != null) {
            array2 = new JsonArray();
            obj2.getCertPaths().forEach(item -> array2.add(item));
            json.put("certPaths", array2);
        }
        if (obj2.getCertValues() != null) {
            array2 = new JsonArray();
            obj2.getCertValues().forEach(item -> array2.add(BASE64_ENCODER.encodeToString(item.getBytes())));
            json.put("certValues", array2);
        }
        if (obj2.getKeyPaths() != null) {
            array2 = new JsonArray();
            obj2.getKeyPaths().forEach(item -> array2.add(item));
            json.put("keyPaths", array2);
        }
        if (obj2.getKeyValues() != null) {
            array2 = new JsonArray();
            obj2.getKeyValues().forEach(item -> array2.add(BASE64_ENCODER.encodeToString(item.getBytes())));
            json.put("keyValues", array2);
        }
    }
}

