/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.netty.handler.logging.ByteBufFormat;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.net.NetworkOptions;
import java.util.Base64;
import java.util.Map;

public class NetworkOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, NetworkOptions obj2) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "activityLogDataFormat": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setActivityLogDataFormat(ByteBufFormat.valueOf((String)member.getValue()));
                    break;
                }
                case "logActivity": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setLogActivity((Boolean)member.getValue());
                    break;
                }
                case "receiveBufferSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setReceiveBufferSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "reuseAddress": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setReuseAddress((Boolean)member.getValue());
                    break;
                }
                case "reusePort": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setReusePort((Boolean)member.getValue());
                    break;
                }
                case "sendBufferSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setSendBufferSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "trafficClass": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setTrafficClass(((Number)member.getValue()).intValue());
                }
            }
        }
    }

    static void toJson(NetworkOptions obj2, JsonObject json) {
        NetworkOptionsConverter.toJson(obj2, json.getMap());
    }

    static void toJson(NetworkOptions obj2, Map<String, Object> json) {
        if (obj2.getActivityLogDataFormat() != null) {
            json.put("activityLogDataFormat", obj2.getActivityLogDataFormat().name());
        }
        json.put("logActivity", obj2.getLogActivity());
        json.put("receiveBufferSize", obj2.getReceiveBufferSize());
        json.put("reuseAddress", obj2.isReuseAddress());
        json.put("reusePort", obj2.isReusePort());
        json.put("sendBufferSize", obj2.getSendBufferSize());
        json.put("trafficClass", obj2.getTrafficClass());
    }
}

