/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.http.ClientAuth;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.net.NetServerOptions;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class NetServerOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, NetServerOptions obj2) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "acceptBacklog": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setAcceptBacklog(((Number)member.getValue()).intValue());
                    break;
                }
                case "clientAuth": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setClientAuth(ClientAuth.valueOf((String)member.getValue()));
                    break;
                }
                case "host": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setHost((String)member.getValue());
                    break;
                }
                case "port": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setPort(((Number)member.getValue()).intValue());
                    break;
                }
                case "proxyProtocolTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setProxyProtocolTimeout(((Number)member.getValue()).longValue());
                    break;
                }
                case "proxyProtocolTimeoutUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setProxyProtocolTimeoutUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "registerWriteHandler": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setRegisterWriteHandler((Boolean)member.getValue());
                    break;
                }
                case "sni": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setSni((Boolean)member.getValue());
                    break;
                }
                case "useProxyProtocol": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setUseProxyProtocol((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(NetServerOptions obj2, JsonObject json) {
        NetServerOptionsConverter.toJson(obj2, json.getMap());
    }

    static void toJson(NetServerOptions obj2, Map<String, Object> json) {
        json.put("acceptBacklog", obj2.getAcceptBacklog());
        if (obj2.getClientAuth() != null) {
            json.put("clientAuth", obj2.getClientAuth().name());
        }
        if (obj2.getHost() != null) {
            json.put("host", obj2.getHost());
        }
        json.put("port", obj2.getPort());
        json.put("proxyProtocolTimeout", obj2.getProxyProtocolTimeout());
        if (obj2.getProxyProtocolTimeoutUnit() != null) {
            json.put("proxyProtocolTimeoutUnit", obj2.getProxyProtocolTimeoutUnit().name());
        }
        json.put("registerWriteHandler", obj2.isRegisterWriteHandler());
        json.put("sni", obj2.isSni());
        json.put("useProxyProtocol", obj2.isUseProxyProtocol());
    }
}

