/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.net.NetClientOptions;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;

public class NetClientOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, NetClientOptions obj2) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "applicationLayerProtocols": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj2.setApplicationLayerProtocols(list);
                    break;
                }
                case "hostnameVerificationAlgorithm": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setHostnameVerificationAlgorithm((String)member.getValue());
                    break;
                }
                case "reconnectAttempts": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setReconnectAttempts(((Number)member.getValue()).intValue());
                    break;
                }
                case "reconnectInterval": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setReconnectInterval(((Number)member.getValue()).longValue());
                    break;
                }
                case "registerWriteHandler": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setRegisterWriteHandler((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(NetClientOptions obj2, JsonObject json) {
        NetClientOptionsConverter.toJson(obj2, json.getMap());
    }

    static void toJson(NetClientOptions obj2, Map<String, Object> json) {
        if (obj2.getApplicationLayerProtocols() != null) {
            JsonArray array2 = new JsonArray();
            obj2.getApplicationLayerProtocols().forEach(item -> array2.add(item));
            json.put("applicationLayerProtocols", array2);
        }
        if (obj2.getHostnameVerificationAlgorithm() != null) {
            json.put("hostnameVerificationAlgorithm", obj2.getHostnameVerificationAlgorithm());
        }
        json.put("reconnectAttempts", obj2.getReconnectAttempts());
        json.put("reconnectInterval", obj2.getReconnectInterval());
        json.put("registerWriteHandler", obj2.isRegisterWriteHandler());
    }
}

