/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.net.ClientOptionsBase;
import io.vertx.core.net.ProxyOptions;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;

public class ClientOptionsBaseConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, ClientOptionsBase obj2) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "connectTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj2.setConnectTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "localAddress": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setLocalAddress((String)member.getValue());
                    break;
                }
                case "metricsName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj2.setMetricsName((String)member.getValue());
                    break;
                }
                case "nonProxyHosts": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj2.setNonProxyHosts(list);
                    break;
                }
                case "proxyOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj2.setProxyOptions(new ProxyOptions((JsonObject)member.getValue()));
                    break;
                }
                case "trustAll": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj2.setTrustAll((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(ClientOptionsBase obj2, JsonObject json) {
        ClientOptionsBaseConverter.toJson(obj2, json.getMap());
    }

    static void toJson(ClientOptionsBase obj2, Map<String, Object> json) {
        json.put("connectTimeout", obj2.getConnectTimeout());
        if (obj2.getLocalAddress() != null) {
            json.put("localAddress", obj2.getLocalAddress());
        }
        if (obj2.getMetricsName() != null) {
            json.put("metricsName", obj2.getMetricsName());
        }
        if (obj2.getNonProxyHosts() != null) {
            JsonArray array2 = new JsonArray();
            obj2.getNonProxyHosts().forEach(item -> array2.add(item));
            json.put("nonProxyHosts", array2);
        }
        if (obj2.getProxyOptions() != null) {
            json.put("proxyOptions", obj2.getProxyOptions().toJson());
        }
        json.put("trustAll", obj2.isTrustAll());
    }
}

