/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.logging;

import io.vertx.core.logging.Logger;
import io.vertx.core.spi.logging.LogDelegate;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

public class SLF4JLogDelegate
implements LogDelegate {
    private static final Object[] EMPTY_PARAMETERS = new Object[0];
    private static final String FQCN = Logger.class.getCanonicalName();
    private final org.slf4j.Logger logger;

    SLF4JLogDelegate(String name2) {
        this.logger = LoggerFactory.getLogger(name2);
    }

    public SLF4JLogDelegate(Object logger2) {
        this.logger = (org.slf4j.Logger)logger2;
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void fatal(Object message) {
        this.log(40, message);
    }

    @Override
    public void fatal(Object message, Throwable t3) {
        this.log(40, message, t3);
    }

    @Override
    public void error(Object message) {
        this.log(40, message);
    }

    @Override
    public void error(Object message, Object ... params) {
        this.log(40, message, null, params);
    }

    @Override
    public void error(Object message, Throwable t3) {
        this.log(40, message, t3);
    }

    @Override
    public void error(Object message, Throwable t3, Object ... params) {
        this.log(40, message, t3, params);
    }

    @Override
    public void warn(Object message) {
        this.log(30, message);
    }

    @Override
    public void warn(Object message, Object ... params) {
        this.log(30, message, null, params);
    }

    @Override
    public void warn(Object message, Throwable t3) {
        this.log(30, message, t3);
    }

    @Override
    public void warn(Object message, Throwable t3, Object ... params) {
        this.log(30, message, t3, params);
    }

    @Override
    public void info(Object message) {
        this.log(20, message);
    }

    @Override
    public void info(Object message, Object ... params) {
        this.log(20, message, null, params);
    }

    @Override
    public void info(Object message, Throwable t3) {
        this.log(20, message, t3);
    }

    @Override
    public void info(Object message, Throwable t3, Object ... params) {
        this.log(20, message, t3, params);
    }

    @Override
    public void debug(Object message) {
        this.log(10, message);
    }

    @Override
    public void debug(Object message, Object ... params) {
        this.log(10, message, null, params);
    }

    @Override
    public void debug(Object message, Throwable t3) {
        this.log(10, message, t3);
    }

    @Override
    public void debug(Object message, Throwable t3, Object ... params) {
        this.log(10, message, t3, params);
    }

    @Override
    public void trace(Object message) {
        this.log(0, message);
    }

    @Override
    public void trace(Object message, Object ... params) {
        this.log(0, message, null, params);
    }

    @Override
    public void trace(Object message, Throwable t3) {
        this.log(0, message, t3);
    }

    @Override
    public void trace(Object message, Throwable t3, Object ... params) {
        this.log(0, message, t3, params);
    }

    private void log(int level, Object message) {
        this.log(level, message, null);
    }

    private void log(int level, Object message, Throwable t3) {
        this.log(level, message, t3, null);
    }

    private void log(int level, Object message, Throwable t3, Object ... params) {
        Object[] parameters2;
        String msg;
        String string2 = msg = message == null ? "NULL" : message.toString();
        if (params == null) {
            parameters2 = t3 == null ? EMPTY_PARAMETERS : new Object[]{t3};
        } else if (t3 == null) {
            parameters2 = params;
        } else {
            parameters2 = new Object[params.length + 1];
            System.arraycopy(params, 0, parameters2, 0, params.length);
            parameters2[params.length] = t3;
        }
        if (this.logger instanceof LocationAwareLogger) {
            if (level == 0 && this.logger.isTraceEnabled() || level == 10 && this.logger.isDebugEnabled() || level == 20 && this.logger.isInfoEnabled() || level == 30 && this.logger.isWarnEnabled() || level == 40 && this.logger.isErrorEnabled()) {
                LocationAwareLogger l = (LocationAwareLogger)this.logger;
                FormattingTuple ft = MessageFormatter.arrayFormat(msg, parameters2);
                l.log(null, FQCN, level, ft.getMessage(), null, ft.getThrowable());
            }
        } else {
            switch (level) {
                case 0: {
                    this.logger.trace(msg, parameters2);
                    break;
                }
                case 10: {
                    this.logger.debug(msg, parameters2);
                    break;
                }
                case 20: {
                    this.logger.info(msg, parameters2);
                    break;
                }
                case 30: {
                    this.logger.warn(msg, parameters2);
                    break;
                }
                case 40: {
                    this.logger.error(msg, parameters2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown log level " + level);
                }
            }
        }
    }

    @Override
    public Object unwrap() {
        return this.logger;
    }
}

