/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.logging;

import io.vertx.core.logging.JULLogDelegateFactory;
import io.vertx.core.logging.Logger;
import io.vertx.core.spi.logging.LogDelegate;
import io.vertx.core.spi.logging.LogDelegateFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LoggerFactory {
    public static final String LOGGER_DELEGATE_FACTORY_CLASS_NAME = "vertx.logger-delegate-factory-class-name";
    private static volatile LogDelegateFactory delegateFactory;
    private static final ConcurrentMap<String, Logger> loggers;

    public static synchronized void initialise() {
        String className;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            className = System.getProperty(LOGGER_DELEGATE_FACTORY_CLASS_NAME);
        }
        catch (Exception ignore) {
            className = null;
        }
        if (className != null && LoggerFactory.configureWith(className, false, loader)) {
            return;
        }
        if (loader.getResource("vertx-default-jul-logging.properties") == null && (LoggerFactory.configureWith("SLF4J", true, loader) || LoggerFactory.configureWith("Log4j2", true, loader))) {
            return;
        }
        delegateFactory = new JULLogDelegateFactory();
    }

    private static boolean configureWith(String name2, boolean shortName, ClassLoader loader) {
        try {
            Class<?> clazz = Class.forName(shortName ? "io.vertx.core.logging." + name2 + "LogDelegateFactory" : name2, true, loader);
            LogDelegateFactory factory = (LogDelegateFactory)clazz.newInstance();
            if (!factory.isAvailable()) {
                return false;
            }
            delegateFactory = factory;
            return true;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    @Deprecated
    public static Logger getLogger(Class<?> clazz) {
        String name2 = clazz.isAnonymousClass() ? clazz.getEnclosingClass().getCanonicalName() : clazz.getCanonicalName();
        return LoggerFactory.getLogger(name2);
    }

    @Deprecated
    public static Logger getLogger(String name2) {
        LogDelegate delegate;
        Logger oldLogger;
        Logger logger2 = (Logger)loggers.get(name2);
        if (logger2 == null && (oldLogger = loggers.putIfAbsent(name2, logger2 = new Logger(delegate = delegateFactory.createDelegate(name2)))) != null) {
            logger2 = oldLogger;
        }
        return logger2;
    }

    @Deprecated
    public static void removeLogger(String name2) {
        loggers.remove(name2);
    }

    static {
        loggers = new ConcurrentHashMap<String, Logger>();
        LoggerFactory.initialise();
        LogDelegate log2 = delegateFactory.createDelegate(LoggerFactory.class.getName());
        log2.debug("Using " + delegateFactory.getClass().getName());
    }
}

