/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.logging;

import io.vertx.core.logging.Logger;
import io.vertx.core.spi.logging.LogDelegate;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class Log4j2LogDelegate
implements LogDelegate {
    final ExtendedLogger logger;
    static final String FQCN = Logger.class.getCanonicalName();

    Log4j2LogDelegate(String name2) {
        this.logger = (ExtendedLogger)LogManager.getLogger((String)name2);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void fatal(Object message) {
        this.log(Level.FATAL, message);
    }

    @Override
    public void fatal(Object message, Throwable t3) {
        this.log(Level.FATAL, message, t3);
    }

    @Override
    public void error(Object message) {
        this.log(Level.ERROR, message);
    }

    @Override
    public void error(Object message, Object ... params) {
        this.log(Level.ERROR, message.toString(), params);
    }

    @Override
    public void error(Object message, Throwable t3) {
        this.log(Level.ERROR, message, t3);
    }

    @Override
    public void error(Object message, Throwable t3, Object ... params) {
        this.log(Level.ERROR, message.toString(), t3, params);
    }

    @Override
    public void warn(Object message) {
        this.log(Level.WARN, message);
    }

    @Override
    public void warn(Object message, Object ... params) {
        this.log(Level.WARN, message.toString(), params);
    }

    @Override
    public void warn(Object message, Throwable t3) {
        this.log(Level.WARN, message, t3);
    }

    @Override
    public void warn(Object message, Throwable t3, Object ... params) {
        this.log(Level.WARN, message.toString(), t3, params);
    }

    @Override
    public void info(Object message) {
        this.log(Level.INFO, message);
    }

    @Override
    public void info(Object message, Object ... params) {
        this.log(Level.INFO, message.toString(), params);
    }

    @Override
    public void info(Object message, Throwable t3) {
        this.log(Level.INFO, message, t3);
    }

    @Override
    public void info(Object message, Throwable t3, Object ... params) {
        this.log(Level.INFO, message.toString(), t3, params);
    }

    @Override
    public void debug(Object message) {
        this.log(Level.DEBUG, message);
    }

    @Override
    public void debug(Object message, Object ... params) {
        this.log(Level.DEBUG, message.toString(), params);
    }

    @Override
    public void debug(Object message, Throwable t3) {
        this.log(Level.DEBUG, message, t3);
    }

    @Override
    public void debug(Object message, Throwable t3, Object ... params) {
        this.log(Level.DEBUG, message.toString(), t3, params);
    }

    @Override
    public void trace(Object message) {
        this.log(Level.TRACE, message);
    }

    @Override
    public void trace(Object message, Object ... params) {
        this.log(Level.TRACE, message.toString(), params);
    }

    @Override
    public void trace(Object message, Throwable t3) {
        this.log(Level.TRACE, (Object)message.toString(), t3);
    }

    @Override
    public void trace(Object message, Throwable t3, Object ... params) {
        this.log(Level.TRACE, message.toString(), t3, params);
    }

    private void log(Level level, Object message) {
        this.log(level, message, null);
    }

    private void log(Level level, Object message, Throwable t3) {
        if (message instanceof Message) {
            this.logger.logIfEnabled(FQCN, level, null, (Message)message, t3);
        } else {
            this.logger.logIfEnabled(FQCN, level, null, message, t3);
        }
    }

    private void log(Level level, String message, Object ... params) {
        this.logger.logIfEnabled(FQCN, level, null, message, params);
    }

    private void log(Level level, String message, Throwable t3, Object ... params) {
        this.logger.logIfEnabled(FQCN, level, null, (Message)new FormattedMessage(message, params), t3);
    }

    @Override
    public Object unwrap() {
        return this.logger;
    }
}

