/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.logging;

import io.vertx.core.spi.logging.LogDelegate;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JULLogDelegate
implements LogDelegate {
    private final Logger logger;

    JULLogDelegate(String name2) {
        this.logger = Logger.getLogger(name2);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    @Override
    public void fatal(Object message) {
        this.log(Level.SEVERE, message);
    }

    @Override
    public void fatal(Object message, Throwable t3) {
        this.log(Level.SEVERE, message, t3);
    }

    @Override
    public void error(Object message) {
        this.log(Level.SEVERE, message);
    }

    @Override
    public void error(Object message, Object ... params) {
        this.log(Level.SEVERE, message, null, params);
    }

    @Override
    public void error(Object message, Throwable t3) {
        this.log(Level.SEVERE, message, t3);
    }

    @Override
    public void error(Object message, Throwable t3, Object ... params) {
        this.log(Level.SEVERE, message, t3, params);
    }

    @Override
    public void warn(Object message) {
        this.log(Level.WARNING, message);
    }

    @Override
    public void warn(Object message, Object ... params) {
        this.log(Level.WARNING, message, null, params);
    }

    @Override
    public void warn(Object message, Throwable t3) {
        this.log(Level.WARNING, message, t3);
    }

    @Override
    public void warn(Object message, Throwable t3, Object ... params) {
        this.log(Level.WARNING, message, t3, params);
    }

    @Override
    public void info(Object message) {
        this.log(Level.INFO, message);
    }

    @Override
    public void info(Object message, Object ... params) {
        this.log(Level.INFO, message, null, params);
    }

    @Override
    public void info(Object message, Throwable t3) {
        this.log(Level.INFO, message, t3);
    }

    @Override
    public void info(Object message, Throwable t3, Object ... params) {
        this.log(Level.INFO, message, t3, params);
    }

    @Override
    public void debug(Object message) {
        this.log(Level.FINE, message);
    }

    @Override
    public void debug(Object message, Object ... params) {
        this.log(Level.FINE, message, null, params);
    }

    @Override
    public void debug(Object message, Throwable t3) {
        this.log(Level.FINE, message, t3);
    }

    @Override
    public void debug(Object message, Throwable t3, Object ... params) {
        this.log(Level.FINE, message, t3, params);
    }

    @Override
    public void trace(Object message) {
        this.log(Level.FINEST, message);
    }

    @Override
    public void trace(Object message, Object ... params) {
        this.log(Level.FINEST, message, null, params);
    }

    @Override
    public void trace(Object message, Throwable t3) {
        this.log(Level.FINEST, message, t3);
    }

    @Override
    public void trace(Object message, Throwable t3, Object ... params) {
        this.log(Level.FINEST, message, t3, params);
    }

    private void log(Level level, Object message) {
        this.log(level, message, null);
    }

    private void log(Level level, Object message, Throwable t3, Object ... params) {
        if (!this.logger.isLoggable(level)) {
            return;
        }
        String msg = message == null ? "NULL" : message.toString();
        LogRecord record2 = new LogRecord(level, msg);
        record2.setLoggerName(this.logger.getName());
        if (t3 != null) {
            record2.setThrown(t3);
        } else if (params != null && params.length != 0 && params[params.length - 1] instanceof Throwable) {
            record2.setThrown((Throwable)params[params.length - 1]);
        }
        record2.setSourceClassName(null);
        record2.setParameters(params);
        this.logger.log(record2);
    }

    private void log(Level level, Object message, Throwable t3) {
        this.log(level, message, t3, null);
    }

    @Override
    public Object unwrap() {
        return this.logger;
    }
}

