/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.EncodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.json.jackson.JacksonFactory;
import io.vertx.core.spi.json.JsonCodec;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JacksonCodec
implements JsonCodec {
    private static final JsonFactory factory = new JsonFactory();

    @Override
    public <T> T fromString(String json, Class<T> clazz) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(json), clazz);
    }

    public <T> T fromString(String str2, TypeReference<T> typeRef) throws DecodeException {
        return this.fromString(str2, JacksonCodec.classTypeOf(typeRef));
    }

    @Override
    public <T> T fromBuffer(Buffer json, Class<T> clazz) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(json), clazz);
    }

    public <T> T fromBuffer(Buffer buf, TypeReference<T> typeRef) throws DecodeException {
        return this.fromBuffer(buf, JacksonCodec.classTypeOf(typeRef));
    }

    @Override
    public <T> T fromValue(Object json, Class<T> toValueType) {
        throw new DecodeException("Mapping " + toValueType.getName() + "  is not available without Jackson Databind on the classpath");
    }

    public <T> T fromValue(Object json, TypeReference<T> type2) {
        throw new DecodeException("Mapping " + type2.getType().getTypeName() + " is not available without Jackson Databind on the classpath");
    }

    @Override
    public String toString(Object object, boolean pretty) throws EncodeException {
        StringWriter sw = new StringWriter();
        JsonGenerator generator = JacksonCodec.createGenerator(sw, pretty);
        try {
            JacksonCodec.encodeJson(object, generator);
            generator.flush();
            String string2 = sw.toString();
            return string2;
        }
        catch (IOException e2) {
            throw new EncodeException(e2.getMessage(), e2);
        }
        finally {
            JacksonCodec.close(generator);
        }
    }

    @Override
    public Buffer toBuffer(Object object, boolean pretty) throws EncodeException {
        ByteBuf buf = Unpooled.buffer();
        ByteBufOutputStream out = new ByteBufOutputStream(buf);
        JsonGenerator generator = JacksonCodec.createGenerator(out, pretty);
        try {
            JacksonCodec.encodeJson(object, generator);
            generator.flush();
            Buffer buffer = Buffer.buffer(buf);
            return buffer;
        }
        catch (IOException e2) {
            throw new EncodeException(e2.getMessage(), e2);
        }
        finally {
            JacksonCodec.close(generator);
        }
    }

    public static JsonParser createParser(String str2) {
        try {
            return factory.createParser(str2);
        }
        catch (IOException e2) {
            throw new DecodeException("Failed to decode:" + e2.getMessage(), e2);
        }
    }

    public static JsonParser createParser(Buffer buf) {
        try {
            return factory.createParser(new ByteBufInputStream(buf.getByteBuf()));
        }
        catch (IOException e2) {
            throw new DecodeException("Failed to decode:" + e2.getMessage(), e2);
        }
    }

    private static JsonGenerator createGenerator(Writer out, boolean pretty) {
        try {
            JsonGenerator generator = factory.createGenerator(out);
            if (pretty) {
                generator.useDefaultPrettyPrinter();
            }
            return generator;
        }
        catch (IOException e2) {
            throw new DecodeException("Failed to decode:" + e2.getMessage(), e2);
        }
    }

    private static JsonGenerator createGenerator(OutputStream out, boolean pretty) {
        try {
            JsonGenerator generator = factory.createGenerator(out);
            if (pretty) {
                generator.useDefaultPrettyPrinter();
            }
            return generator;
        }
        catch (IOException e2) {
            throw new DecodeException("Failed to decode:" + e2.getMessage(), e2);
        }
    }

    public Object fromString(String str2) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(str2), Object.class);
    }

    public Object fromBuffer(Buffer buf) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(buf), Object.class);
    }

    public static <T> T fromParser(JsonParser parser, Class<T> type2) throws DecodeException {
        JsonToken remaining;
        Object res;
        try {
            parser.nextToken();
            res = JacksonCodec.parseAny(parser);
            remaining = parser.nextToken();
        }
        catch (IOException e2) {
            throw new DecodeException(e2.getMessage(), e2);
        }
        finally {
            JacksonCodec.close(parser);
        }
        if (remaining != null) {
            throw new DecodeException("Unexpected trailing token");
        }
        return JacksonCodec.cast(res, type2);
    }

    private static Object parseAny(JsonParser parser) throws IOException, DecodeException {
        switch (parser.getCurrentTokenId()) {
            case 1: {
                return JacksonCodec.parseObject(parser);
            }
            case 3: {
                return JacksonCodec.parseArray(parser);
            }
            case 6: {
                return parser.getText();
            }
            case 7: 
            case 8: {
                return parser.getNumberValue();
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 11: {
                return null;
            }
        }
        throw new DecodeException("Unexpected token");
    }

    private static Map<String, Object> parseObject(JsonParser parser) throws IOException {
        String key1 = parser.nextFieldName();
        if (key1 == null) {
            return new LinkedHashMap<String, Object>(2);
        }
        parser.nextToken();
        Object value1 = JacksonCodec.parseAny(parser);
        String key2 = parser.nextFieldName();
        if (key2 == null) {
            LinkedHashMap<String, Object> obj2 = new LinkedHashMap<String, Object>(2);
            obj2.put(key1, value1);
            return obj2;
        }
        parser.nextToken();
        Object value2 = JacksonCodec.parseAny(parser);
        String key3 = parser.nextFieldName();
        if (key3 == null) {
            LinkedHashMap<String, Object> obj3 = new LinkedHashMap<String, Object>(2);
            obj3.put(key1, value1);
            obj3.put(key2, value2);
            return obj3;
        }
        LinkedHashMap<String, Object> obj4 = new LinkedHashMap<String, Object>();
        obj4.put(key1, value1);
        obj4.put(key2, value2);
        do {
            parser.nextToken();
            Object value = JacksonCodec.parseAny(parser);
            obj4.put(key3, value);
        } while ((key3 = parser.nextFieldName()) != null);
        return obj4;
    }

    private static List<Object> parseArray(JsonParser parser) throws IOException {
        ArrayList<Object> array2 = new ArrayList<Object>();
        while (true) {
            parser.nextToken();
            int tokenId = parser.getCurrentTokenId();
            if (tokenId == 5) {
                throw new UnsupportedOperationException();
            }
            if (tokenId == 4) {
                return array2;
            }
            Object value = JacksonCodec.parseAny(parser);
            array2.add(value);
        }
    }

    static void close(Closeable parser) {
        try {
            parser.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void encodeJson(Object json, JsonGenerator generator) throws EncodeException {
        block33: {
            try {
                if (json instanceof JsonObject) {
                    json = ((JsonObject)json).getMap();
                } else if (json instanceof JsonArray) {
                    json = ((JsonArray)json).getList();
                }
                if (json instanceof Map) {
                    generator.writeStartObject();
                    for (Map.Entry e2 : ((Map)json).entrySet()) {
                        generator.writeFieldName((String)e2.getKey());
                        JacksonCodec.encodeJson(e2.getValue(), generator);
                    }
                    generator.writeEndObject();
                    break block33;
                }
                if (json instanceof List) {
                    generator.writeStartArray();
                    for (Object item : (List)json) {
                        JacksonCodec.encodeJson(item, generator);
                    }
                    generator.writeEndArray();
                    break block33;
                }
                if (json instanceof String) {
                    generator.writeString((String)json);
                    break block33;
                }
                if (json instanceof Number) {
                    if (json instanceof Short) {
                        generator.writeNumber((Short)json);
                    } else if (json instanceof Integer) {
                        generator.writeNumber((Integer)json);
                    } else if (json instanceof Long) {
                        generator.writeNumber((Long)json);
                    } else if (json instanceof Float) {
                        generator.writeNumber(((Float)json).floatValue());
                    } else if (json instanceof Double) {
                        generator.writeNumber((Double)json);
                    } else if (json instanceof Byte) {
                        generator.writeNumber(((Byte)json).byteValue());
                    } else if (json instanceof BigInteger) {
                        generator.writeNumber((BigInteger)json);
                    } else if (json instanceof BigDecimal) {
                        generator.writeNumber((BigDecimal)json);
                    } else {
                        generator.writeNumber(((Number)json).doubleValue());
                    }
                    break block33;
                }
                if (json instanceof Boolean) {
                    generator.writeBoolean((Boolean)json);
                    break block33;
                }
                if (json instanceof Instant) {
                    generator.writeString(DateTimeFormatter.ISO_INSTANT.format((Instant)json));
                    break block33;
                }
                if (json instanceof byte[]) {
                    generator.writeString(JsonUtil.BASE64_ENCODER.encodeToString((byte[])json));
                    break block33;
                }
                if (json instanceof Buffer) {
                    generator.writeString(JsonUtil.BASE64_ENCODER.encodeToString(((Buffer)json).getBytes()));
                    break block33;
                }
                if (json instanceof Enum) {
                    generator.writeString(((Enum)json).name());
                    break block33;
                }
                if (json == null) {
                    generator.writeNull();
                    break block33;
                }
                throw new EncodeException("Mapping " + json.getClass().getName() + "  is not available without Jackson Databind on the classpath");
            }
            catch (IOException e3) {
                throw new EncodeException(e3.getMessage(), e3);
            }
        }
    }

    private static <T> Class<T> classTypeOf(TypeReference<T> typeRef) {
        Type type2 = typeRef.getType();
        if (type2 instanceof Class) {
            return (Class)type2;
        }
        if (type2 instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type2).getRawType();
        }
        throw new DecodeException();
    }

    private static <T> T cast(Object o, Class<T> clazz) {
        if (o instanceof Map) {
            if (!clazz.isAssignableFrom(Map.class)) {
                throw new DecodeException("Failed to decode");
            }
            if (clazz == Object.class) {
                o = new JsonObject((Map)o);
            }
            return clazz.cast(o);
        }
        if (o instanceof List) {
            if (!clazz.isAssignableFrom(List.class)) {
                throw new DecodeException("Failed to decode");
            }
            if (clazz == Object.class) {
                o = new JsonArray((List)o);
            }
            return clazz.cast(o);
        }
        if (o instanceof String) {
            String str2 = (String)o;
            if (clazz.isEnum()) {
                o = Enum.valueOf(clazz, str2);
            } else if (clazz == byte[].class) {
                o = JsonUtil.BASE64_DECODER.decode(str2);
            } else if (clazz == Buffer.class) {
                o = Buffer.buffer(JsonUtil.BASE64_DECODER.decode(str2));
            } else if (clazz == Instant.class) {
                o = Instant.from(DateTimeFormatter.ISO_INSTANT.parse(str2));
            } else if (!clazz.isAssignableFrom(String.class)) {
                throw new DecodeException("Failed to decode");
            }
            return clazz.cast(o);
        }
        if (o instanceof Boolean) {
            if (!clazz.isAssignableFrom(Boolean.class)) {
                throw new DecodeException("Failed to decode");
            }
            return clazz.cast(o);
        }
        if (o == null) {
            return null;
        }
        Number number2 = (Number)o;
        if (clazz == Integer.class) {
            o = number2.intValue();
        } else if (clazz == Long.class) {
            o = number2.longValue();
        } else if (clazz == Float.class) {
            o = Float.valueOf(number2.floatValue());
        } else if (clazz == Double.class) {
            o = number2.doubleValue();
        } else if (clazz == Byte.class) {
            o = number2.byteValue();
        } else if (clazz == Short.class) {
            o = number2.shortValue();
        } else if (clazz != Object.class && !clazz.isAssignableFrom(Number.class)) {
            throw new DecodeException("Failed to decode");
        }
        return clazz.cast(o);
    }

    public static <T> T decodeValue(String str2, TypeReference<T> type2) throws DecodeException {
        return JacksonFactory.CODEC.fromString(str2, type2);
    }

    public static <T> T decodeValue(Buffer buf, TypeReference<T> type2) throws DecodeException {
        return JacksonFactory.CODEC.fromBuffer(buf, type2);
    }

    static {
        factory.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    }
}

