/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.netty.buffer.ByteBufInputStream;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.EncodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.jackson.JacksonCodec;
import io.vertx.core.json.jackson.VertxModule;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class DatabindCodec
extends JacksonCodec {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final ObjectMapper prettyMapper = new ObjectMapper();

    private static void initialize() {
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        prettyMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        prettyMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        VertxModule module = new VertxModule();
        mapper.registerModule(module);
        prettyMapper.registerModule(module);
    }

    public static ObjectMapper mapper() {
        return mapper;
    }

    public static ObjectMapper prettyMapper() {
        return prettyMapper;
    }

    @Override
    public <T> T fromValue(Object json, Class<T> clazz) {
        Object value = mapper.convertValue(json, clazz);
        if (clazz == Object.class) {
            value = DatabindCodec.adapt(value);
        }
        return value;
    }

    @Override
    public <T> T fromValue(Object json, TypeReference<T> type2) {
        Object value = mapper.convertValue(json, type2);
        if (type2.getType() == Object.class) {
            value = DatabindCodec.adapt(value);
        }
        return value;
    }

    @Override
    public <T> T fromString(String str2, Class<T> clazz) throws DecodeException {
        return DatabindCodec.fromParser(DatabindCodec.createParser(str2), clazz);
    }

    @Override
    public <T> T fromString(String str2, TypeReference<T> typeRef) throws DecodeException {
        return DatabindCodec.fromParser(DatabindCodec.createParser(str2), typeRef);
    }

    @Override
    public <T> T fromBuffer(Buffer buf, Class<T> clazz) throws DecodeException {
        return DatabindCodec.fromParser(DatabindCodec.createParser(buf), clazz);
    }

    @Override
    public <T> T fromBuffer(Buffer buf, TypeReference<T> typeRef) throws DecodeException {
        return DatabindCodec.fromParser(DatabindCodec.createParser(buf), typeRef);
    }

    public static JsonParser createParser(Buffer buf) {
        try {
            return mapper.getFactory().createParser(new ByteBufInputStream(buf.getByteBuf()));
        }
        catch (IOException e2) {
            throw new DecodeException("Failed to decode:" + e2.getMessage(), e2);
        }
    }

    public static JsonParser createParser(String str2) {
        try {
            return mapper.getFactory().createParser(str2);
        }
        catch (IOException e2) {
            throw new DecodeException("Failed to decode:" + e2.getMessage(), e2);
        }
    }

    public static <T> T fromParser(JsonParser parser, Class<T> type2) throws DecodeException {
        JsonToken remaining;
        Object value;
        try {
            value = mapper.readValue(parser, type2);
            remaining = parser.nextToken();
        }
        catch (Exception e2) {
            throw new DecodeException("Failed to decode:" + e2.getMessage(), e2);
        }
        finally {
            DatabindCodec.close(parser);
        }
        if (remaining != null) {
            throw new DecodeException("Unexpected trailing token");
        }
        if (type2 == Object.class) {
            value = DatabindCodec.adapt(value);
        }
        return value;
    }

    private static <T> T fromParser(JsonParser parser, TypeReference<T> type2) throws DecodeException {
        Object value;
        try {
            value = mapper.readValue(parser, type2);
        }
        catch (Exception e2) {
            throw new DecodeException("Failed to decode:" + e2.getMessage(), e2);
        }
        finally {
            DatabindCodec.close(parser);
        }
        if (type2.getType() == Object.class) {
            value = DatabindCodec.adapt(value);
        }
        return value;
    }

    @Override
    public String toString(Object object, boolean pretty) throws EncodeException {
        try {
            ObjectMapper mapper2 = pretty ? prettyMapper : mapper;
            return mapper2.writeValueAsString(object);
        }
        catch (Exception e2) {
            throw new EncodeException("Failed to encode as JSON: " + e2.getMessage());
        }
    }

    @Override
    public Buffer toBuffer(Object object, boolean pretty) throws EncodeException {
        try {
            ObjectMapper mapper2 = pretty ? prettyMapper : mapper;
            return Buffer.buffer(mapper2.writeValueAsBytes(object));
        }
        catch (Exception e2) {
            throw new EncodeException("Failed to encode as JSON: " + e2.getMessage());
        }
    }

    private static Object adapt(Object o) {
        try {
            if (o instanceof List) {
                List list = (List)o;
                return new JsonArray(list);
            }
            if (o instanceof Map) {
                Map map2 = (Map)o;
                return new JsonObject(map2);
            }
            return o;
        }
        catch (Exception e2) {
            throw new DecodeException("Failed to decode: " + e2.getMessage());
        }
    }

    static {
        DatabindCodec.initialize();
    }
}

