/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.Shareable;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class JsonUtil {
    public static final Base64.Encoder BASE64_ENCODER;
    public static final Base64.Decoder BASE64_DECODER;
    public static final Function<Object, ?> DEFAULT_CLONER;

    public static Object wrapJsonValue(Object val2) {
        if (val2 == null) {
            return null;
        }
        if (val2 instanceof Map) {
            val2 = new JsonObject((Map)val2);
        } else if (val2 instanceof List) {
            val2 = new JsonArray((List)val2);
        } else if (val2 instanceof Instant) {
            val2 = DateTimeFormatter.ISO_INSTANT.format((Instant)val2);
        } else if (val2 instanceof byte[]) {
            val2 = BASE64_ENCODER.encodeToString((byte[])val2);
        } else if (val2 instanceof Buffer) {
            val2 = BASE64_ENCODER.encodeToString(((Buffer)val2).getBytes());
        } else if (val2 instanceof Enum) {
            val2 = ((Enum)val2).name();
        }
        return val2;
    }

    public static Object deepCopy(Object val2, Function<Object, ?> copier) {
        if (!(val2 == null || val2 instanceof Number || val2 instanceof Boolean || val2 instanceof String || val2 instanceof Character)) {
            if (val2 instanceof CharSequence) {
                val2 = val2.toString();
            } else if (val2 instanceof Shareable) {
                val2 = ((Shareable)val2).copy();
            } else if (val2 instanceof Map) {
                val2 = new JsonObject((Map)val2).copy(copier);
            } else if (val2 instanceof List) {
                val2 = new JsonArray((List)val2).copy(copier);
            } else if (!(val2 instanceof byte[] || val2 instanceof Instant || val2 instanceof Enum)) {
                val2 = copier.apply(val2);
            }
        }
        return val2;
    }

    public static <T> Stream<T> asStream(Iterator<T> sourceIterator) {
        Iterable iterable = () -> sourceIterator;
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    static {
        if ("legacy".equalsIgnoreCase(System.getProperty("vertx.json.base64"))) {
            BASE64_ENCODER = Base64.getEncoder();
            BASE64_DECODER = Base64.getDecoder();
        } else {
            BASE64_ENCODER = Base64.getUrlEncoder().withoutPadding();
            BASE64_DECODER = Base64.getUrlDecoder();
        }
        DEFAULT_CLONER = o -> {
            throw new IllegalStateException("Illegal type in Json: " + o.getClass());
        };
    }
}

