/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.shareddata.ClusterSerializable;
import io.vertx.core.shareddata.Shareable;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public class JsonObject
implements Iterable<Map.Entry<String, Object>>,
ClusterSerializable,
Shareable {
    private Map<String, Object> map;

    public JsonObject(String json) {
        if (json == null) {
            throw new NullPointerException();
        }
        this.fromJson(json);
        if (this.map == null) {
            throw new DecodeException("Invalid JSON object: " + json);
        }
    }

    public JsonObject() {
        this.map = new LinkedHashMap<String, Object>();
    }

    public JsonObject(Map<String, Object> map2) {
        if (map2 == null) {
            throw new NullPointerException();
        }
        this.map = map2;
    }

    public JsonObject(Buffer buf) {
        if (buf == null) {
            throw new NullPointerException();
        }
        this.fromBuffer(buf);
        if (this.map == null) {
            throw new DecodeException("Invalid JSON object: " + buf);
        }
    }

    public static JsonObject of() {
        return new JsonObject();
    }

    public static JsonObject of(String k1, Object v1) {
        JsonObject obj2 = new JsonObject(new LinkedHashMap<String, Object>(1));
        obj2.put(k1, v1);
        return obj2;
    }

    public static JsonObject of(String k1, Object v1, String k2, Object v2) {
        JsonObject obj2 = new JsonObject(new LinkedHashMap<String, Object>(2));
        obj2.put(k1, v1);
        obj2.put(k2, v2);
        return obj2;
    }

    public static JsonObject of(String k1, Object v1, String k2, Object v2, String k3, Object v3) {
        JsonObject obj2 = new JsonObject(new LinkedHashMap<String, Object>(3));
        obj2.put(k1, v1);
        obj2.put(k2, v2);
        obj2.put(k3, v3);
        return obj2;
    }

    public static JsonObject of(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        JsonObject obj2 = new JsonObject(new LinkedHashMap<String, Object>(4));
        obj2.put(k1, v1);
        obj2.put(k2, v2);
        obj2.put(k3, v3);
        obj2.put(k4, v4);
        return obj2;
    }

    public static JsonObject of(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4, String k5, Object v5) {
        JsonObject obj2 = new JsonObject(new LinkedHashMap<String, Object>(5));
        obj2.put(k1, v1);
        obj2.put(k2, v2);
        obj2.put(k3, v3);
        obj2.put(k4, v4);
        obj2.put(k5, v5);
        return obj2;
    }

    public static JsonObject of(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4, String k5, Object v5, String k6, Object v6) {
        JsonObject obj2 = new JsonObject(new LinkedHashMap<String, Object>(6));
        obj2.put(k1, v1);
        obj2.put(k2, v2);
        obj2.put(k3, v3);
        obj2.put(k4, v4);
        obj2.put(k5, v5);
        obj2.put(k6, v6);
        return obj2;
    }

    public static JsonObject of(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4, String k5, Object v5, String k6, Object v6, String k7, Object v7) {
        JsonObject obj2 = new JsonObject(new LinkedHashMap<String, Object>(7));
        obj2.put(k1, v1);
        obj2.put(k2, v2);
        obj2.put(k3, v3);
        obj2.put(k4, v4);
        obj2.put(k5, v5);
        obj2.put(k6, v6);
        obj2.put(k7, v7);
        return obj2;
    }

    public static JsonObject of(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4, String k5, Object v5, String k6, Object v6, String k7, Object v7, String k8, Object v8) {
        JsonObject obj2 = new JsonObject(new LinkedHashMap<String, Object>(8));
        obj2.put(k1, v1);
        obj2.put(k2, v2);
        obj2.put(k3, v3);
        obj2.put(k4, v4);
        obj2.put(k5, v5);
        obj2.put(k6, v6);
        obj2.put(k7, v7);
        obj2.put(k8, v8);
        return obj2;
    }

    public static JsonObject of(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4, String k5, Object v5, String k6, Object v6, String k7, Object v7, String k8, Object v8, String k9, Object v9) {
        JsonObject obj2 = new JsonObject(new LinkedHashMap<String, Object>(9));
        obj2.put(k1, v1);
        obj2.put(k2, v2);
        obj2.put(k3, v3);
        obj2.put(k4, v4);
        obj2.put(k5, v5);
        obj2.put(k6, v6);
        obj2.put(k7, v7);
        obj2.put(k8, v8);
        obj2.put(k9, v9);
        return obj2;
    }

    public static JsonObject of(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4, String k5, Object v5, String k6, Object v6, String k7, Object v7, String k8, Object v8, String k9, Object v9, String k10, Object v10) {
        JsonObject obj2 = new JsonObject(new LinkedHashMap<String, Object>(10));
        obj2.put(k1, v1);
        obj2.put(k2, v2);
        obj2.put(k3, v3);
        obj2.put(k4, v4);
        obj2.put(k5, v5);
        obj2.put(k6, v6);
        obj2.put(k7, v7);
        obj2.put(k8, v8);
        obj2.put(k9, v9);
        obj2.put(k10, v10);
        return obj2;
    }

    public static JsonObject mapFrom(Object obj2) {
        if (obj2 == null) {
            return null;
        }
        return new JsonObject(Json.CODEC.fromValue(obj2, Map.class));
    }

    public <T> T mapTo(Class<T> type2) {
        return Json.CODEC.fromValue(this.map, type2);
    }

    public String getString(String key2) {
        Objects.requireNonNull(key2);
        Object val2 = this.map.get(key2);
        if (val2 == null) {
            return null;
        }
        if (val2 instanceof Instant) {
            return DateTimeFormatter.ISO_INSTANT.format((Instant)val2);
        }
        if (val2 instanceof byte[]) {
            return JsonUtil.BASE64_ENCODER.encodeToString((byte[])val2);
        }
        if (val2 instanceof Buffer) {
            return JsonUtil.BASE64_ENCODER.encodeToString(((Buffer)val2).getBytes());
        }
        if (val2 instanceof Enum) {
            return ((Enum)val2).name();
        }
        return val2.toString();
    }

    public Number getNumber(String key2) {
        Objects.requireNonNull(key2);
        return (Number)this.map.get(key2);
    }

    public Integer getInteger(String key2) {
        Objects.requireNonNull(key2);
        Number number2 = (Number)this.map.get(key2);
        if (number2 == null) {
            return null;
        }
        if (number2 instanceof Integer) {
            return (Integer)number2;
        }
        return number2.intValue();
    }

    public Long getLong(String key2) {
        Objects.requireNonNull(key2);
        Number number2 = (Number)this.map.get(key2);
        if (number2 == null) {
            return null;
        }
        if (number2 instanceof Long) {
            return (Long)number2;
        }
        return number2.longValue();
    }

    public Double getDouble(String key2) {
        Objects.requireNonNull(key2);
        Number number2 = (Number)this.map.get(key2);
        if (number2 == null) {
            return null;
        }
        if (number2 instanceof Double) {
            return (Double)number2;
        }
        return number2.doubleValue();
    }

    public Float getFloat(String key2) {
        Objects.requireNonNull(key2);
        Number number2 = (Number)this.map.get(key2);
        if (number2 == null) {
            return null;
        }
        if (number2 instanceof Float) {
            return (Float)number2;
        }
        return Float.valueOf(number2.floatValue());
    }

    public Boolean getBoolean(String key2) {
        Objects.requireNonNull(key2);
        return (Boolean)this.map.get(key2);
    }

    public JsonObject getJsonObject(String key2) {
        Objects.requireNonNull(key2);
        Object val2 = this.map.get(key2);
        if (val2 instanceof Map) {
            val2 = new JsonObject((Map)val2);
        }
        return (JsonObject)val2;
    }

    public JsonArray getJsonArray(String key2) {
        Objects.requireNonNull(key2);
        Object val2 = this.map.get(key2);
        if (val2 instanceof List) {
            val2 = new JsonArray((List)val2);
        }
        return (JsonArray)val2;
    }

    public byte[] getBinary(String key2) {
        Objects.requireNonNull(key2);
        Object val2 = this.map.get(key2);
        if (val2 == null) {
            return null;
        }
        if (val2 instanceof byte[]) {
            return (byte[])val2;
        }
        if (val2 instanceof Buffer) {
            return ((Buffer)val2).getBytes();
        }
        String encoded = (String)val2;
        return JsonUtil.BASE64_DECODER.decode(encoded);
    }

    public Buffer getBuffer(String key2) {
        Objects.requireNonNull(key2);
        Object val2 = this.map.get(key2);
        if (val2 == null) {
            return null;
        }
        if (val2 instanceof Buffer) {
            return (Buffer)val2;
        }
        if (val2 instanceof byte[]) {
            return Buffer.buffer((byte[])val2);
        }
        String encoded = (String)val2;
        return Buffer.buffer(JsonUtil.BASE64_DECODER.decode(encoded));
    }

    public Instant getInstant(String key2) {
        Objects.requireNonNull(key2);
        Object val2 = this.map.get(key2);
        if (val2 == null) {
            return null;
        }
        if (val2 instanceof Instant) {
            return (Instant)val2;
        }
        String encoded = (String)val2;
        return Instant.from(DateTimeFormatter.ISO_INSTANT.parse(encoded));
    }

    public Object getValue(String key2) {
        Objects.requireNonNull(key2);
        return JsonUtil.wrapJsonValue(this.map.get(key2));
    }

    public String getString(String key2, String def2) {
        Objects.requireNonNull(key2);
        if (this.map.containsKey(key2)) {
            return this.getString(key2);
        }
        return def2;
    }

    public Number getNumber(String key2, Number def2) {
        Objects.requireNonNull(key2);
        if (this.map.containsKey(key2)) {
            return this.getNumber(key2);
        }
        return def2;
    }

    public Integer getInteger(String key2, Integer def2) {
        Objects.requireNonNull(key2);
        if (this.map.containsKey(key2)) {
            return this.getInteger(key2);
        }
        return def2;
    }

    public Long getLong(String key2, Long def2) {
        Objects.requireNonNull(key2);
        if (this.map.containsKey(key2)) {
            return this.getLong(key2);
        }
        return def2;
    }

    public Double getDouble(String key2, Double def2) {
        Objects.requireNonNull(key2);
        if (this.map.containsKey(key2)) {
            return this.getDouble(key2);
        }
        return def2;
    }

    public Float getFloat(String key2, Float def2) {
        Objects.requireNonNull(key2);
        if (this.map.containsKey(key2)) {
            return this.getFloat(key2);
        }
        return def2;
    }

    public Boolean getBoolean(String key2, Boolean def2) {
        Objects.requireNonNull(key2);
        if (this.map.containsKey(key2)) {
            return this.getBoolean(key2);
        }
        return def2;
    }

    public JsonObject getJsonObject(String key2, JsonObject def2) {
        Objects.requireNonNull(key2);
        if (this.map.containsKey(key2)) {
            return this.getJsonObject(key2);
        }
        return def2;
    }

    public JsonArray getJsonArray(String key2, JsonArray def2) {
        Objects.requireNonNull(key2);
        if (this.map.containsKey(key2)) {
            return this.getJsonArray(key2);
        }
        return def2;
    }

    public byte[] getBinary(String key2, byte[] def2) {
        Objects.requireNonNull(key2);
        if (this.map.containsKey(key2)) {
            return this.getBinary(key2);
        }
        return def2;
    }

    public Buffer getBuffer(String key2, Buffer def2) {
        Objects.requireNonNull(key2);
        if (this.map.containsKey(key2)) {
            return this.getBuffer(key2);
        }
        return def2;
    }

    public Instant getInstant(String key2, Instant def2) {
        Objects.requireNonNull(key2);
        if (this.map.containsKey(key2)) {
            return this.getInstant(key2);
        }
        return def2;
    }

    public Object getValue(String key2, Object def2) {
        Objects.requireNonNull(key2);
        if (this.map.containsKey(key2)) {
            return this.getValue(key2);
        }
        return def2;
    }

    public boolean containsKey(String key2) {
        Objects.requireNonNull(key2);
        return this.map.containsKey(key2);
    }

    public Set<String> fieldNames() {
        return this.map.keySet();
    }

    public JsonObject putNull(String key2) {
        Objects.requireNonNull(key2);
        this.map.put(key2, null);
        return this;
    }

    public JsonObject put(String key2, Object value) {
        Objects.requireNonNull(key2);
        this.map.put(key2, value);
        return this;
    }

    public Object remove(String key2) {
        Objects.requireNonNull(key2);
        return JsonUtil.wrapJsonValue(this.map.remove(key2));
    }

    public JsonObject mergeIn(JsonObject other) {
        return this.mergeIn(other, false);
    }

    public JsonObject mergeIn(JsonObject other, boolean deep) {
        return this.mergeIn(other, deep ? Integer.MAX_VALUE : 1);
    }

    public JsonObject mergeIn(JsonObject other, int depth) {
        if (depth < 1) {
            return this;
        }
        if (depth == 1) {
            this.map.putAll(other.map);
            return this;
        }
        for (Map.Entry<String, Object> e2 : other.map.entrySet()) {
            if (e2.getValue() == null) {
                this.map.put(e2.getKey(), null);
                continue;
            }
            this.map.merge(e2.getKey(), e2.getValue(), (oldVal, newVal) -> {
                if (oldVal instanceof Map) {
                    oldVal = new JsonObject((Map)oldVal);
                }
                if (newVal instanceof Map) {
                    newVal = new JsonObject((Map)newVal);
                }
                if (oldVal instanceof JsonObject && newVal instanceof JsonObject) {
                    return ((JsonObject)oldVal).mergeIn((JsonObject)newVal, depth - 1);
                }
                return newVal;
            });
        }
        return this;
    }

    public String encode() {
        return Json.CODEC.toString(this, false);
    }

    public String encodePrettily() {
        return Json.CODEC.toString(this, true);
    }

    public Buffer toBuffer() {
        return Json.CODEC.toBuffer(this, false);
    }

    @Override
    public JsonObject copy() {
        return this.copy(JsonUtil.DEFAULT_CLONER);
    }

    public JsonObject copy(Function<Object, ?> cloner) {
        HashMap copiedMap = this.map instanceof LinkedHashMap ? new LinkedHashMap(this.map.size()) : new HashMap(this.map.size());
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            Object val2 = JsonUtil.deepCopy(entry.getValue(), cloner);
            copiedMap.put((String)entry.getKey(), (Object)val2);
        }
        return new JsonObject(copiedMap);
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    public Stream<Map.Entry<String, Object>> stream() {
        return JsonUtil.asStream(this.iterator());
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return new Iter(this.map.entrySet().iterator());
    }

    public int size() {
        return this.map.size();
    }

    public JsonObject clear() {
        this.map.clear();
        return this;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String toString() {
        return this.encode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        JsonObject other = (JsonObject)o;
        if (this.size() != other.size()) {
            return false;
        }
        for (String key2 : this.map.keySet()) {
            Object otherValue;
            if (!other.containsKey(key2)) {
                return false;
            }
            Object thisValue = this.getValue(key2);
            if (thisValue == (otherValue = other.getValue(key2))) continue;
            if (thisValue instanceof Number && otherValue instanceof Number && thisValue.getClass() != otherValue.getClass()) {
                Number n1 = (Number)thisValue;
                Number n2 = (Number)otherValue;
                if ((thisValue instanceof Float || thisValue instanceof Double || otherValue instanceof Float || otherValue instanceof Double) && n1.doubleValue() == n2.doubleValue() || (thisValue instanceof Integer || thisValue instanceof Long || otherValue instanceof Integer || otherValue instanceof Long) && n1.longValue() == n2.longValue()) continue;
            }
            if (thisValue instanceof CharSequence && otherValue instanceof CharSequence && thisValue.getClass() != otherValue.getClass()) {
                CharSequence s1 = (CharSequence)thisValue;
                CharSequence s2 = (CharSequence)otherValue;
                if (Objects.equals(s1.toString(), s2.toString())) continue;
            }
            if (Objects.equals(thisValue, otherValue)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public void writeToBuffer(Buffer buffer) {
        Buffer buf = this.toBuffer();
        buffer.appendInt(buf.length());
        buffer.appendBuffer(buf);
    }

    @Override
    public int readFromBuffer(int pos, Buffer buffer) {
        int length = buffer.getInt(pos);
        int start2 = pos + 4;
        Buffer buf = buffer.getBuffer(start2, start2 + length);
        this.fromBuffer(buf);
        return pos + length + 4;
    }

    private void fromJson(String json) {
        this.map = Json.CODEC.fromString(json, Map.class);
    }

    private void fromBuffer(Buffer buf) {
        this.map = Json.CODEC.fromBuffer(buf, Map.class);
    }

    private static final class Entry
    implements Map.Entry<String, Object> {
        final String key;
        final Object value;

        public Entry(String key2, Object value) {
            this.key = key2;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }

    private static class Iter
    implements Iterator<Map.Entry<String, Object>> {
        final Iterator<Map.Entry<String, Object>> mapIter;

        Iter(Iterator<Map.Entry<String, Object>> mapIter) {
            this.mapIter = mapIter;
        }

        @Override
        public boolean hasNext() {
            return this.mapIter.hasNext();
        }

        @Override
        public Map.Entry<String, Object> next() {
            Object wrapped;
            Map.Entry<String, Object> entry = this.mapIter.next();
            Object val2 = entry.getValue();
            if (val2 != (wrapped = JsonUtil.wrapJsonValue(val2))) {
                return new Entry(entry.getKey(), wrapped);
            }
            return entry;
        }

        @Override
        public void remove() {
            this.mapIter.remove();
        }
    }
}

