/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.shareddata.ClusterSerializable;
import io.vertx.core.shareddata.Shareable;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

public class JsonArray
implements Iterable<Object>,
ClusterSerializable,
Shareable {
    private List<Object> list;

    public JsonArray(String json) {
        if (json == null) {
            throw new NullPointerException();
        }
        this.fromJson(json);
        if (this.list == null) {
            throw new DecodeException("Invalid JSON array: " + json);
        }
    }

    public JsonArray() {
        this.list = new ArrayList<Object>();
    }

    public JsonArray(List list) {
        if (list == null) {
            throw new NullPointerException();
        }
        this.list = list;
    }

    public JsonArray(Buffer buf) {
        if (buf == null) {
            throw new NullPointerException();
        }
        this.fromBuffer(buf);
        if (this.list == null) {
            throw new DecodeException("Invalid JSON array: " + buf);
        }
    }

    public static JsonArray of(Object ... values2) {
        if (values2.length == 0) {
            return new JsonArray();
        }
        JsonArray arr = new JsonArray(new ArrayList(values2.length));
        for (int i = 0; i < values2.length; ++i) {
            arr.add(values2[i]);
        }
        return arr;
    }

    public String getString(int pos) {
        Object val2 = this.list.get(pos);
        if (val2 == null) {
            return null;
        }
        if (val2 instanceof Instant) {
            return DateTimeFormatter.ISO_INSTANT.format((Instant)val2);
        }
        if (val2 instanceof byte[]) {
            return JsonUtil.BASE64_ENCODER.encodeToString((byte[])val2);
        }
        if (val2 instanceof Buffer) {
            return JsonUtil.BASE64_ENCODER.encodeToString(((Buffer)val2).getBytes());
        }
        if (val2 instanceof Enum) {
            return ((Enum)val2).name();
        }
        return val2.toString();
    }

    public Number getNumber(int pos) {
        return (Number)this.list.get(pos);
    }

    public Integer getInteger(int pos) {
        Number number2 = (Number)this.list.get(pos);
        if (number2 == null) {
            return null;
        }
        if (number2 instanceof Integer) {
            return (Integer)number2;
        }
        return number2.intValue();
    }

    public Long getLong(int pos) {
        Number number2 = (Number)this.list.get(pos);
        if (number2 == null) {
            return null;
        }
        if (number2 instanceof Long) {
            return (Long)number2;
        }
        return number2.longValue();
    }

    public Double getDouble(int pos) {
        Number number2 = (Number)this.list.get(pos);
        if (number2 == null) {
            return null;
        }
        if (number2 instanceof Double) {
            return (Double)number2;
        }
        return number2.doubleValue();
    }

    public Float getFloat(int pos) {
        Number number2 = (Number)this.list.get(pos);
        if (number2 == null) {
            return null;
        }
        if (number2 instanceof Float) {
            return (Float)number2;
        }
        return Float.valueOf(number2.floatValue());
    }

    public Boolean getBoolean(int pos) {
        return (Boolean)this.list.get(pos);
    }

    public JsonObject getJsonObject(int pos) {
        Object val2 = this.list.get(pos);
        if (val2 instanceof Map) {
            val2 = new JsonObject((Map)val2);
        }
        return (JsonObject)val2;
    }

    public JsonArray getJsonArray(int pos) {
        Object val2 = this.list.get(pos);
        if (val2 instanceof List) {
            val2 = new JsonArray((List)val2);
        }
        return (JsonArray)val2;
    }

    public byte[] getBinary(int pos) {
        Object val2 = this.list.get(pos);
        if (val2 == null) {
            return null;
        }
        if (val2 instanceof byte[]) {
            return (byte[])val2;
        }
        if (val2 instanceof Buffer) {
            return ((Buffer)val2).getBytes();
        }
        String encoded = (String)val2;
        return JsonUtil.BASE64_DECODER.decode(encoded);
    }

    public Buffer getBuffer(int pos) {
        Object val2 = this.list.get(pos);
        if (val2 == null) {
            return null;
        }
        if (val2 instanceof Buffer) {
            return (Buffer)val2;
        }
        if (val2 instanceof byte[]) {
            return Buffer.buffer((byte[])val2);
        }
        String encoded = (String)val2;
        return Buffer.buffer(JsonUtil.BASE64_DECODER.decode(encoded));
    }

    public Instant getInstant(int pos) {
        Object val2 = this.list.get(pos);
        if (val2 == null) {
            return null;
        }
        if (val2 instanceof Instant) {
            return (Instant)val2;
        }
        String encoded = (String)val2;
        return Instant.from(DateTimeFormatter.ISO_INSTANT.parse(encoded));
    }

    public Object getValue(int pos) {
        return JsonUtil.wrapJsonValue(this.list.get(pos));
    }

    public boolean hasNull(int pos) {
        return this.list.get(pos) == null;
    }

    public JsonArray addNull() {
        this.list.add(null);
        return this;
    }

    public JsonArray add(Object value) {
        this.list.add(value);
        return this;
    }

    public JsonArray add(int pos, Object value) {
        this.list.add(pos, value);
        return this;
    }

    public JsonArray addAll(JsonArray array2) {
        this.list.addAll(array2.list);
        return this;
    }

    public JsonArray setNull(int pos) {
        this.list.set(pos, null);
        return this;
    }

    public JsonArray set(int pos, Object value) {
        this.list.set(pos, value);
        return this;
    }

    public boolean contains(Object value) {
        return this.list.contains(value);
    }

    public boolean remove(Object value) {
        Object wrappedValue = JsonUtil.wrapJsonValue(value);
        for (int i = 0; i < this.list.size(); ++i) {
            Object otherWrapperValue = this.getValue(i);
            if (wrappedValue == null) {
                if (otherWrapperValue != null) continue;
                this.list.remove(i);
                return true;
            }
            if (!wrappedValue.equals(otherWrapperValue)) continue;
            this.list.remove(i);
            return true;
        }
        return false;
    }

    public Object remove(int pos) {
        return JsonUtil.wrapJsonValue(this.list.remove(pos));
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public List getList() {
        return this.list;
    }

    public JsonArray clear() {
        this.list.clear();
        return this;
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iter(this.list.iterator());
    }

    public String encode() {
        return Json.CODEC.toString(this, false);
    }

    public Buffer toBuffer() {
        return Json.CODEC.toBuffer(this, false);
    }

    public String encodePrettily() {
        return Json.CODEC.toString(this, true);
    }

    @Override
    public JsonArray copy() {
        return this.copy(JsonUtil.DEFAULT_CLONER);
    }

    public JsonArray copy(Function<Object, ?> cloner) {
        ArrayList<Object> copiedList = new ArrayList<Object>(this.list.size());
        for (Object val2 : this.list) {
            copiedList.add(JsonUtil.deepCopy(val2, cloner));
        }
        return new JsonArray(copiedList);
    }

    public Stream<Object> stream() {
        return JsonUtil.asStream(this.iterator());
    }

    public String toString() {
        return this.encode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        JsonArray other = (JsonArray)o;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            Object otherValue;
            Object thisValue = this.getValue(i);
            if (thisValue == (otherValue = other.getValue(i))) continue;
            if (thisValue instanceof Number && otherValue instanceof Number && thisValue.getClass() != otherValue.getClass()) {
                Number n1 = (Number)thisValue;
                Number n2 = (Number)otherValue;
                if ((thisValue instanceof Float || thisValue instanceof Double || otherValue instanceof Float || otherValue instanceof Double) && n1.doubleValue() == n2.doubleValue() || (thisValue instanceof Integer || thisValue instanceof Long || otherValue instanceof Integer || otherValue instanceof Long) && n1.longValue() == n2.longValue()) continue;
            }
            if (thisValue instanceof CharSequence && otherValue instanceof CharSequence && thisValue.getClass() != otherValue.getClass()) {
                CharSequence s1 = (CharSequence)thisValue;
                CharSequence s2 = (CharSequence)otherValue;
                if (Objects.equals(s1.toString(), s2.toString())) continue;
            }
            if (Objects.equals(thisValue, otherValue)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public void writeToBuffer(Buffer buffer) {
        Buffer buf = this.toBuffer();
        buffer.appendInt(buf.length());
        buffer.appendBuffer(buf);
    }

    @Override
    public int readFromBuffer(int pos, Buffer buffer) {
        int length = buffer.getInt(pos);
        int start2 = pos + 4;
        Buffer buf = buffer.getBuffer(start2, start2 + length);
        this.fromBuffer(buf);
        return pos + length + 4;
    }

    private void fromJson(String json) {
        this.list = Json.CODEC.fromString(json, List.class);
    }

    private void fromBuffer(Buffer buf) {
        this.list = Json.CODEC.fromBuffer(buf, List.class);
    }

    private static class Iter
    implements Iterator<Object> {
        final Iterator<Object> listIter;

        Iter(Iterator<Object> listIter) {
            this.listIter = listIter;
        }

        @Override
        public boolean hasNext() {
            return this.listIter.hasNext();
        }

        @Override
        public Object next() {
            return JsonUtil.wrapJsonValue(this.listIter.next());
        }

        @Override
        public void remove() {
            this.listIter.remove();
        }
    }
}

