/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.verticle;

import io.vertx.core.impl.verticle.CustomJavaFileObject;
import io.vertx.core.impl.verticle.PackageHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;

public class MemoryFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private final Map<String, ByteArrayOutputStream> compiledClasses = new HashMap<String, ByteArrayOutputStream>();
    private final PackageHelper helper;

    public MemoryFileManager(ClassLoader classLoader, JavaFileManager fileManager) {
        super(fileManager);
        this.helper = new PackageHelper(classLoader);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, final String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        try {
            return new SimpleJavaFileObject(new URI(""), kind){

                @Override
                public OutputStream openOutputStream() throws IOException {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    MemoryFileManager.this.compiledClasses.put(className, outputStream);
                    return outputStream;
                }
            };
        }
        catch (URISyntaxException e2) {
            throw new RuntimeException(e2);
        }
    }

    public byte[] getCompiledClass(String name2) {
        ByteArrayOutputStream bytes2 = this.compiledClasses.get(name2);
        if (bytes2 == null) {
            return null;
        }
        return bytes2.toByteArray();
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file2) {
        if (file2 instanceof CustomJavaFileObject) {
            return ((CustomJavaFileObject)file2).binaryName();
        }
        return super.inferBinaryName(location, file2);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        if (location == StandardLocation.CLASS_PATH && kinds.contains((Object)JavaFileObject.Kind.CLASS)) {
            return this.helper.find(packageName);
        }
        return super.list(location, packageName, kinds, recurse);
    }
}

