/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.verticle;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import javax.tools.JavaFileObject;

public class JavaSourceContext {
    private final String className;
    private final File sourceRoot;

    public JavaSourceContext(File file2) {
        String packageName = JavaSourceContext.parsePackage(file2);
        File rootDirectory = file2.getParentFile();
        if (packageName != null) {
            String[] pathTokens = packageName.split("\\.");
            for (int i = pathTokens.length - 1; i >= 0; --i) {
                String token2 = pathTokens[i];
                if (!token2.equals(rootDirectory.getName())) {
                    throw new RuntimeException("Package structure does not match directory structure: " + token2 + " != " + rootDirectory.getName());
                }
                rootDirectory = rootDirectory.getParentFile();
            }
        }
        this.sourceRoot = rootDirectory;
        String fileName = file2.getName();
        String className = fileName.substring(0, fileName.length() - JavaFileObject.Kind.SOURCE.extension.length());
        if (packageName != null) {
            className = packageName + '.' + className;
        }
        this.className = className;
    }

    public File getSourceRoot() {
        return this.sourceRoot;
    }

    public String getClassName() {
        return this.className;
    }

    private static String parsePackage(File file2) {
        try {
            String source2 = new String(Files.readAllBytes(file2.toPath()), StandardCharsets.UTF_8);
            source2 = source2.replaceAll("//.*|(\"(?:\\\\[^\"]|\\\\\"|.)*?\")|(?s)/\\*.*?\\*/", "$1 ");
            for (String line : source2.split("\\r?\\n")) {
                if ((line = line.trim()).isEmpty()) continue;
                int idx = line.indexOf("package ");
                if (idx != -1) {
                    return line.substring(line.indexOf(32, idx), line.indexOf(59, idx)).trim();
                }
                return null;
            }
            return null;
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }
}

