/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.resolver;

import io.netty.channel.EventLoop;
import io.netty.channel.socket.SocketChannel;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.HostsFileEntries;
import io.netty.resolver.HostsFileEntriesResolver;
import io.netty.resolver.HostsFileParser;
import io.netty.resolver.NameResolver;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.resolver.RoundRobinInetAddressResolver;
import io.netty.resolver.dns.DefaultDnsCache;
import io.netty.resolver.dns.DefaultDnsServerAddressStreamProvider;
import io.netty.resolver.dns.DnsAddressResolverGroup;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsServerAddressStream;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.resolver.dns.DnsServerAddresses;
import io.netty.util.NetUtil;
import io.netty.util.internal.ObjectUtil;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.impl.AddressResolver;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.spi.resolver.ResolverProvider;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;

public class DnsResolverProvider
implements ResolverProvider {
    private final Vertx vertx;
    private final List<ResolverRegistration> resolvers = Collections.synchronizedList(new ArrayList());
    private AddressResolverGroup<InetSocketAddress> resolverGroup;
    private final List<InetSocketAddress> serverList = new ArrayList<InetSocketAddress>();

    public List<InetSocketAddress> nameServerAddresses() {
        return this.serverList;
    }

    public DnsResolverProvider(VertxImpl vertx, final AddressResolverOptions options2) {
        HostsFileEntries entries2;
        List<String> dnsServers = options2.getServers();
        if (dnsServers != null && dnsServers.size() > 0) {
            for (String dnsServer : dnsServers) {
                int port;
                String ipAddress;
                int sep = dnsServer.indexOf(58);
                if (sep != -1) {
                    ipAddress = dnsServer.substring(0, sep);
                    port = Integer.parseInt(dnsServer.substring(sep + 1));
                } else {
                    ipAddress = dnsServer;
                    port = 53;
                }
                try {
                    this.serverList.add(new InetSocketAddress(InetAddress.getByAddress(NetUtil.createByteArrayFromIpAddressString(ipAddress)), port));
                }
                catch (UnknownHostException e2) {
                    throw new VertxException(e2);
                }
            }
        } else {
            InetSocketAddress address;
            DnsServerAddressStream stream = DefaultDnsServerAddressStreamProvider.defaultAddresses().stream();
            HashSet<InetSocketAddress> all = new HashSet<InetSocketAddress>();
            while (!all.contains(address = stream.next())) {
                this.serverList.add(address);
                all.add(address);
            }
        }
        DnsServerAddresses nameServerAddresses = options2.isRotateServers() ? DnsServerAddresses.rotational(this.serverList) : DnsServerAddresses.sequential(this.serverList);
        DnsServerAddressStreamProvider nameServerAddressProvider = hostname -> nameServerAddresses.stream();
        if (options2.getHostsPath() != null) {
            File file2 = vertx.resolveFile(options2.getHostsPath()).getAbsoluteFile();
            try {
                if (!file2.exists() || !file2.isFile()) {
                    throw new IOException();
                }
                entries2 = HostsFileParser.parse(file2);
            }
            catch (IOException e3) {
                throw new VertxException("Cannot read hosts file " + file2.getAbsolutePath());
            }
        } else if (options2.getHostsValue() != null) {
            try {
                entries2 = HostsFileParser.parse(new StringReader(options2.getHostsValue().toString()));
            }
            catch (IOException e4) {
                throw new VertxException("Cannot read hosts config ", e4);
            }
        } else {
            entries2 = HostsFileParser.parseSilently();
        }
        int minTtl = ObjectUtil.intValue(options2.getCacheMinTimeToLive(), 0);
        int maxTtl = ObjectUtil.intValue(options2.getCacheMaxTimeToLive(), Integer.MAX_VALUE);
        int negativeTtl = ObjectUtil.intValue(options2.getCacheNegativeTimeToLive(), 0);
        DefaultDnsCache resolveCache = new DefaultDnsCache(minTtl, maxTtl, negativeTtl);
        DefaultDnsCache authoritativeDnsServerCache = new DefaultDnsCache(minTtl, maxTtl, negativeTtl);
        this.vertx = vertx;
        DnsNameResolverBuilder builder = new DnsNameResolverBuilder();
        builder.hostsFileEntriesResolver(new HostsFileEntriesResolver(){

            @Override
            public InetAddress address(String inetHost, ResolvedAddressTypes resolvedAddressTypes) {
                InetAddress address;
                if (inetHost.endsWith(".")) {
                    inetHost = inetHost.substring(0, inetHost.length() - 1);
                }
                if ((address = this.lookup(inetHost, resolvedAddressTypes)) == null) {
                    address = this.lookup(inetHost.toLowerCase(Locale.ENGLISH), resolvedAddressTypes);
                }
                return address;
            }

            InetAddress lookup(String inetHost, ResolvedAddressTypes resolvedAddressTypes) {
                switch (resolvedAddressTypes) {
                    case IPV4_ONLY: {
                        return entries2.inet4Entries().get(inetHost);
                    }
                    case IPV6_ONLY: {
                        return entries2.inet6Entries().get(inetHost);
                    }
                    case IPV4_PREFERRED: {
                        Inet4Address inet4Address = entries2.inet4Entries().get(inetHost);
                        return inet4Address != null ? inet4Address : (InetAddress)entries2.inet6Entries().get(inetHost);
                    }
                    case IPV6_PREFERRED: {
                        Inet6Address inet6Address = entries2.inet6Entries().get(inetHost);
                        return inet6Address != null ? inet6Address : (InetAddress)entries2.inet4Entries().get(inetHost);
                    }
                }
                throw new IllegalArgumentException("Unknown ResolvedAddressTypes " + (Object)((Object)resolvedAddressTypes));
            }
        });
        builder.channelFactory(() -> vertx.transport().datagramChannel());
        builder.socketChannelFactory(() -> (SocketChannel)vertx.transport().channelFactory(false).newChannel());
        builder.nameServerProvider(nameServerAddressProvider);
        builder.optResourceEnabled(options2.isOptResourceEnabled());
        builder.resolveCache(resolveCache);
        builder.authoritativeDnsServerCache(authoritativeDnsServerCache);
        builder.queryTimeoutMillis(options2.getQueryTimeout());
        builder.maxQueriesPerResolve(options2.getMaxQueries());
        builder.recursionDesired(options2.getRdFlag());
        if (options2.getSearchDomains() != null) {
            builder.searchDomains(options2.getSearchDomains());
            int ndots = options2.getNdots();
            if (ndots == -1) {
                ndots = AddressResolver.DEFAULT_NDOTS_RESOLV_OPTION;
            }
            builder.ndots(ndots);
        }
        this.resolverGroup = new DnsAddressResolverGroup(builder){

            @Override
            protected io.netty.resolver.AddressResolver<InetSocketAddress> newAddressResolver(EventLoop eventLoop, NameResolver<InetAddress> resolver) throws Exception {
                io.netty.resolver.AddressResolver<InetSocketAddress> addressResolver = options2.isRoundRobinInetAddress() ? new RoundRobinInetAddressResolver(eventLoop, resolver).asAddressResolver() : super.newAddressResolver(eventLoop, resolver);
                DnsResolverProvider.this.resolvers.add(new ResolverRegistration(addressResolver, eventLoop));
                return addressResolver;
            }
        };
    }

    @Override
    public AddressResolverGroup<InetSocketAddress> resolver(AddressResolverOptions options2) {
        return this.resolverGroup;
    }

    @Override
    public void close(Handler<Void> doneHandler) {
        Context context = this.vertx.getOrCreateContext();
        ResolverRegistration[] registrations = this.resolvers.toArray(new ResolverRegistration[0]);
        if (registrations.length == 0) {
            context.runOnContext(doneHandler);
            return;
        }
        AtomicInteger count2 = new AtomicInteger(registrations.length);
        for (ResolverRegistration registration : registrations) {
            Runnable task = () -> {
                registration.resolver.close();
                if (count2.decrementAndGet() == 0) {
                    context.runOnContext(doneHandler);
                }
            };
            if (registration.executor.inEventLoop()) {
                task.run();
                continue;
            }
            registration.executor.execute(task);
        }
    }

    private static class ResolverRegistration {
        private final io.netty.resolver.AddressResolver<InetSocketAddress> resolver;
        private final EventLoop executor;

        ResolverRegistration(io.netty.resolver.AddressResolver<InetSocketAddress> resolver, EventLoop executor) {
            this.resolver = resolver;
            this.executor = executor;
        }
    }
}

