/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.future;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.FutureInternal;
import io.vertx.core.impl.future.Listener;
import io.vertx.core.impl.future.Operation;
import java.util.function.Function;

class Transformation<T, U>
extends Operation<U>
implements Listener<T> {
    private final Future<T> future;
    private final Function<AsyncResult<T>, Future<U>> mapper;

    Transformation(ContextInternal context, Future<T> future2, Function<AsyncResult<T>, Future<U>> mapper2) {
        super(context);
        this.future = future2;
        this.mapper = mapper2;
    }

    @Override
    public void onSuccess(T value) {
        FutureInternal future2;
        try {
            future2 = (FutureInternal)this.mapper.apply(this.future);
        }
        catch (Throwable e2) {
            this.tryFail(e2);
            return;
        }
        future2.addListener(this.newListener());
    }

    @Override
    public void onFailure(Throwable failure) {
        FutureInternal future2;
        try {
            future2 = (FutureInternal)this.mapper.apply(this.future);
        }
        catch (Throwable e2) {
            this.tryFail(e2);
            return;
        }
        future2.addListener(this.newListener());
    }

    private Listener<U> newListener() {
        return new Listener<U>(){

            @Override
            public void onSuccess(U value) {
                Transformation.this.tryComplete(value);
            }

            @Override
            public void onFailure(Throwable failure) {
                Transformation.this.tryFail(failure);
            }
        };
    }
}

