/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextBase;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.spi.metrics.PoolMetrics;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public class WorkerContext
extends ContextBase {
    private Executor executor;

    WorkerContext(VertxInternal vertx, WorkerPool internalBlockingPool, WorkerPool workerPool, Deployment deployment, CloseFuture closeFuture, ClassLoader tccl) {
        super(vertx, vertx.getEventLoopGroup().next(), internalBlockingPool, workerPool, deployment, closeFuture, tccl);
    }

    @Override
    protected void runOnContext(ContextInternal ctx, Handler<Void> action) {
        try {
            this.run(ctx, null, action);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    protected <T> void execute(ContextInternal ctx, T argument, Handler<T> task) {
        this.execute(this.orderedTasks, argument, task);
    }

    @Override
    protected <T> void emit(ContextInternal ctx, T argument, Handler<T> task) {
        this.execute(this.orderedTasks, argument, (T arg) -> ctx.dispatch(arg, task));
    }

    @Override
    protected <T> void execute(ContextInternal ctx, Runnable task) {
        this.execute(this, task, Runnable::run);
    }

    @Override
    public boolean isEventLoopContext() {
        return false;
    }

    @Override
    public boolean isWorkerContext() {
        return true;
    }

    @Override
    public Executor executor() {
        if (this.executor == null) {
            this.executor = command2 -> {
                PoolMetrics metrics = this.workerPool.metrics();
                Object queueMetric = metrics != null ? metrics.submitted() : null;
                this.orderedTasks.execute(() -> {
                    Object execMetric = null;
                    if (metrics != null) {
                        execMetric = metrics.begin(queueMetric);
                    }
                    try {
                        command2.run();
                    }
                    finally {
                        if (metrics != null) {
                            metrics.end(execMetric, true);
                        }
                    }
                }, this.workerPool.executor());
            };
        }
        return this.executor;
    }

    private <T> void run(ContextInternal ctx, T value, Handler<T> task) {
        Objects.requireNonNull(task, "Task handler must not be null");
        this.executor().execute(() -> ctx.dispatch(value, task));
    }

    private <T> void execute(TaskQueue queue2, T argument, Handler<T> task) {
        if (Context.isOnWorkerThread()) {
            task.handle(argument);
        } else {
            PoolMetrics metrics = this.workerPool.metrics();
            Object queueMetric = metrics != null ? metrics.submitted() : null;
            queue2.execute(() -> {
                Object execMetric = null;
                if (metrics != null) {
                    execMetric = metrics.begin(queueMetric);
                }
                try {
                    task.handle(argument);
                }
                finally {
                    if (metrics != null) {
                        metrics.end(execMetric, true);
                    }
                }
            }, this.workerPool.executor());
        }
    }

    @Override
    public boolean inThread() {
        return Context.isOnWorkerThread();
    }
}

