/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.TimeoutStream;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.datagram.impl.DatagramSocketImpl;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.dns.DnsClient;
import io.vertx.core.dns.DnsClientOptions;
import io.vertx.core.dns.impl.DnsClientImpl;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.impl.EventBusImpl;
import io.vertx.core.eventbus.impl.EventBusInternal;
import io.vertx.core.eventbus.impl.clustered.ClusteredEventBus;
import io.vertx.core.file.FileSystem;
import io.vertx.core.file.impl.FileSystemImpl;
import io.vertx.core.file.impl.WindowsFileSystem;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpServerImpl;
import io.vertx.core.http.impl.SharedHttpClient;
import io.vertx.core.impl.AddressResolver;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextBase;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.DeploymentManager;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.FailoverCompleteHandler;
import io.vertx.core.impl.HAManager;
import io.vertx.core.impl.Utils;
import io.vertx.core.impl.VerticleManager;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.VertxThread;
import io.vertx.core.impl.WorkerContext;
import io.vertx.core.impl.WorkerExecutorImpl;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.impl.btc.BlockedThreadChecker;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.impl.resolver.DnsResolverProvider;
import io.vertx.core.impl.transports.JDKTransport;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.impl.NetClientBuilder;
import io.vertx.core.net.impl.NetServerImpl;
import io.vertx.core.net.impl.ServerID;
import io.vertx.core.net.impl.TCPServerBase;
import io.vertx.core.shareddata.SharedData;
import io.vertx.core.shareddata.impl.SharedDataImpl;
import io.vertx.core.spi.ExecutorServiceFactory;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.core.spi.VertxThreadFactory;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeSelector;
import io.vertx.core.spi.file.FileResolver;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.spi.transport.Transport;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class VertxImpl
implements VertxInternal,
MetricsProvider {
    static final ThreadLocal<ContextDispatch> nonVertxContextDispatch = new ThreadLocal();
    private static final Logger log = LoggerFactory.getLogger(VertxImpl.class);
    private static final String CLUSTER_MAP_NAME = "__vertx.haInfo";
    private static final String NETTY_IO_RATIO_PROPERTY_NAME = "vertx.nettyIORatio";
    private static final int NETTY_IO_RATIO = Integer.getInteger("vertx.nettyIORatio", 50);
    private final FileSystem fileSystem = this.getFileSystem();
    private final SharedData sharedData;
    private final VertxMetrics metrics;
    private final ConcurrentMap<Long, InternalTimerHandler> timeouts = new ConcurrentHashMap<Long, InternalTimerHandler>();
    private final AtomicLong timeoutCounter = new AtomicLong(0L);
    private final ClusterManager clusterManager;
    private final NodeSelector nodeSelector;
    private final DeploymentManager deploymentManager;
    private final VerticleManager verticleManager;
    private final FileResolver fileResolver;
    private final Map<ServerID, HttpServerImpl> sharedHttpServers = new HashMap<ServerID, HttpServerImpl>();
    private final Map<ServerID, NetServerImpl> sharedNetServers = new HashMap<ServerID, NetServerImpl>();
    final WorkerPool workerPool;
    final WorkerPool internalWorkerPool;
    private final VertxThreadFactory threadFactory;
    private final ExecutorServiceFactory executorServiceFactory;
    private final ThreadFactory eventLoopThreadFactory;
    private final EventLoopGroup eventLoopGroup;
    private final EventLoopGroup acceptorEventLoopGroup;
    private final BlockedThreadChecker checker;
    private final AddressResolver addressResolver;
    private final AddressResolverOptions addressResolverOptions;
    private final EventBusInternal eventBus;
    private volatile HAManager haManager;
    private boolean closed;
    private volatile Handler<Throwable> exceptionHandler;
    private final Map<String, SharedWorkerPool> namedWorkerPools;
    private final int defaultWorkerPoolSize;
    private final long maxWorkerExecTime;
    private final TimeUnit maxWorkerExecTimeUnit;
    private final long maxEventLoopExecTime;
    private final TimeUnit maxEventLoopExecTimeUnit;
    private final CloseFuture closeFuture;
    private final Transport transport;
    private final VertxTracer tracer;
    private final ThreadLocal<WeakReference<ContextInternal>> stickyContext = new ThreadLocal();
    private final boolean disableTCCL;
    private final Boolean useDaemonThread;

    VertxImpl(VertxOptions options2, ClusterManager clusterManager, NodeSelector nodeSelector, VertxMetrics metrics, VertxTracer<?, ?> tracer, Transport transport, FileResolver fileResolver, VertxThreadFactory threadFactory, ExecutorServiceFactory executorServiceFactory) {
        if (Vertx.currentContext() != null) {
            log.warn("You're already on a Vert.x context, are you sure you want to create a new Vertx instance?");
        }
        Boolean useDaemonThread = options2.getUseDaemonThread();
        int workerPoolSize = options2.getWorkerPoolSize();
        int internalBlockingPoolSize = options2.getInternalBlockingPoolSize();
        BlockedThreadChecker checker2 = new BlockedThreadChecker(options2.getBlockedThreadCheckInterval(), options2.getBlockedThreadCheckIntervalUnit(), options2.getWarningExceptionTime(), options2.getWarningExceptionTimeUnit());
        long maxEventLoopExecuteTime = options2.getMaxEventLoopExecuteTime();
        TimeUnit maxEventLoopExecuteTimeUnit = options2.getMaxEventLoopExecuteTimeUnit();
        ThreadFactory acceptorEventLoopThreadFactory = VertxImpl.createThreadFactory(threadFactory, checker2, useDaemonThread, maxEventLoopExecuteTime, maxEventLoopExecuteTimeUnit, "vert.x-acceptor-thread-", false);
        TimeUnit maxWorkerExecuteTimeUnit = options2.getMaxWorkerExecuteTimeUnit();
        long maxWorkerExecuteTime = options2.getMaxWorkerExecuteTime();
        ThreadFactory workerThreadFactory = VertxImpl.createThreadFactory(threadFactory, checker2, useDaemonThread, maxWorkerExecuteTime, maxWorkerExecuteTimeUnit, "vert.x-worker-thread-", true);
        ExecutorService workerExec = executorServiceFactory.createExecutor(workerThreadFactory, workerPoolSize, workerPoolSize);
        PoolMetrics<?> workerPoolMetrics = metrics != null ? metrics.createPoolMetrics("worker", "vert.x-worker-thread", options2.getWorkerPoolSize()) : null;
        ThreadFactory internalWorkerThreadFactory = VertxImpl.createThreadFactory(threadFactory, checker2, useDaemonThread, maxWorkerExecuteTime, maxWorkerExecuteTimeUnit, "vert.x-internal-blocking-", true);
        ExecutorService internalWorkerExec = executorServiceFactory.createExecutor(internalWorkerThreadFactory, internalBlockingPoolSize, internalBlockingPoolSize);
        PoolMetrics<?> internalBlockingPoolMetrics = metrics != null ? metrics.createPoolMetrics("worker", "vert.x-internal-blocking", internalBlockingPoolSize) : null;
        this.closeFuture = new CloseFuture(log);
        this.maxEventLoopExecTime = maxEventLoopExecuteTime;
        this.maxEventLoopExecTimeUnit = maxEventLoopExecuteTimeUnit;
        this.eventLoopThreadFactory = VertxImpl.createThreadFactory(threadFactory, checker2, useDaemonThread, this.maxEventLoopExecTime, this.maxEventLoopExecTimeUnit, "vert.x-eventloop-thread-", false);
        this.eventLoopGroup = transport.eventLoopGroup(1, options2.getEventLoopPoolSize(), this.eventLoopThreadFactory, NETTY_IO_RATIO);
        this.acceptorEventLoopGroup = transport.eventLoopGroup(0, 1, acceptorEventLoopThreadFactory, 100);
        this.internalWorkerPool = new WorkerPool(internalWorkerExec, internalBlockingPoolMetrics);
        this.namedWorkerPools = new HashMap<String, SharedWorkerPool>();
        this.workerPool = new WorkerPool(workerExec, workerPoolMetrics);
        this.defaultWorkerPoolSize = options2.getWorkerPoolSize();
        this.maxWorkerExecTime = maxWorkerExecuteTime;
        this.maxWorkerExecTimeUnit = maxWorkerExecuteTimeUnit;
        this.disableTCCL = options2.getDisableTCCL();
        this.checker = checker2;
        this.useDaemonThread = useDaemonThread;
        this.executorServiceFactory = executorServiceFactory;
        this.threadFactory = threadFactory;
        this.metrics = metrics;
        this.transport = transport;
        this.fileResolver = fileResolver;
        this.addressResolverOptions = options2.getAddressResolverOptions();
        this.addressResolver = new AddressResolver(this, options2.getAddressResolverOptions());
        this.tracer = tracer == VertxTracer.NOOP ? null : tracer;
        this.clusterManager = clusterManager;
        this.nodeSelector = nodeSelector;
        this.eventBus = clusterManager != null ? new ClusteredEventBus(this, options2, clusterManager, nodeSelector) : new EventBusImpl(this);
        this.sharedData = new SharedDataImpl(this, clusterManager);
        this.deploymentManager = new DeploymentManager(this);
        this.verticleManager = new VerticleManager(this, this.deploymentManager);
    }

    void init() {
        this.eventBus.start(Promise.promise());
        if (this.metrics != null) {
            this.metrics.vertxCreated(this);
        }
    }

    void initClustered(VertxOptions options2, Handler<AsyncResult<Vertx>> resultHandler) {
        this.nodeSelector.init(this, this.clusterManager);
        this.clusterManager.init(this, this.nodeSelector);
        PromiseInternal initPromise = this.getOrCreateContext().promise();
        initPromise.future().onComplete(ar -> {
            if (ar.succeeded()) {
                if (this.metrics != null) {
                    this.metrics.vertxCreated(this);
                }
                resultHandler.handle(Future.succeededFuture(this));
            } else {
                log.error("Failed to initialize clustered Vert.x", ar.cause());
                this.close().onComplete(ignore -> resultHandler.handle(Future.failedFuture(ar.cause())));
            }
        });
        Promise<Void> joinPromise = Promise.promise();
        joinPromise.future().onComplete(ar -> {
            if (ar.succeeded()) {
                this.createHaManager(options2, initPromise);
            } else {
                initPromise.fail(ar.cause());
            }
        });
        this.clusterManager.join(joinPromise);
    }

    private void createHaManager(VertxOptions options2, Promise<Void> initPromise) {
        if (options2.isHAEnabled()) {
            this.executeBlocking(fut -> {
                this.haManager = new HAManager(this, this.deploymentManager, this.verticleManager, this.clusterManager, this.clusterManager.getSyncMap(CLUSTER_MAP_NAME), options2.getQuorumSize(), options2.getHAGroup());
                fut.complete(this.haManager);
            }, false, ar -> {
                if (ar.succeeded()) {
                    this.startEventBus(true, initPromise);
                } else {
                    initPromise.fail(ar.cause());
                }
            });
        } else {
            this.startEventBus(false, initPromise);
        }
    }

    private void startEventBus(boolean haEnabled, Promise<Void> initPromise) {
        Promise<Void> promise2 = Promise.promise();
        this.eventBus.start(promise2);
        promise2.future().onComplete(ar -> {
            if (ar.succeeded()) {
                if (haEnabled) {
                    this.initializeHaManager(initPromise);
                } else {
                    initPromise.complete();
                }
            } else {
                initPromise.fail(ar.cause());
            }
        });
    }

    private void initializeHaManager(Promise<Void> initPromise) {
        this.executeBlocking(fut -> {
            this.haManager.init();
            fut.complete();
        }, false, initPromise);
    }

    protected FileSystem getFileSystem() {
        return Utils.isWindows() ? new WindowsFileSystem(this) : new FileSystemImpl(this);
    }

    @Override
    public long maxEventLoopExecTime() {
        return this.maxEventLoopExecTime;
    }

    @Override
    public TimeUnit maxEventLoopExecTimeUnit() {
        return this.maxEventLoopExecTimeUnit;
    }

    @Override
    public DatagramSocket createDatagramSocket(DatagramSocketOptions options2) {
        CloseFuture closeFuture = new CloseFuture(log);
        DatagramSocketImpl so = DatagramSocketImpl.create(this, closeFuture, options2);
        closeFuture.add(so);
        CloseFuture fut = this.resolveCloseFuture();
        fut.add(closeFuture);
        return so;
    }

    @Override
    public NetServer createNetServer(NetServerOptions options2) {
        return new NetServerImpl(this, options2);
    }

    @Override
    public NetClient createNetClient(NetClientOptions options2) {
        CloseFuture closeFuture = new CloseFuture(log);
        CloseFuture fut = this.resolveCloseFuture();
        fut.add(closeFuture);
        NetClientBuilder builder = new NetClientBuilder(this, options2);
        builder.metrics(this.metricsSPI() != null ? this.metricsSPI().createNetClientMetrics(options2) : null);
        builder.closeFuture(closeFuture);
        return builder.build();
    }

    @Override
    public Transport transport() {
        return this.transport;
    }

    @Override
    public boolean isNativeTransportEnabled() {
        return !(this.transport instanceof JDKTransport);
    }

    @Override
    public Throwable unavailableNativeTransportCause() {
        if (this.isNativeTransportEnabled()) {
            return null;
        }
        return this.transport.unavailabilityCause();
    }

    @Override
    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    @Override
    public SharedData sharedData() {
        return this.sharedData;
    }

    @Override
    public HttpServer createHttpServer(HttpServerOptions serverOptions) {
        return new HttpServerImpl((VertxInternal)this, serverOptions);
    }

    @Override
    public HttpClient createHttpClient(HttpClientOptions options2, CloseFuture closeFuture) {
        HttpClientImpl client = new HttpClientImpl(this, options2, closeFuture);
        closeFuture.add(client);
        return client;
    }

    @Override
    public HttpClient createHttpClient(HttpClientOptions options2) {
        HttpClient client;
        CloseFuture closeFuture = new CloseFuture();
        if (options2.isShared()) {
            client = this.createSharedClient("__vertx.shared.httpClients", options2.getName(), closeFuture, cf -> this.createHttpClient(options2, (CloseFuture)cf));
            client = new SharedHttpClient(this, closeFuture, client);
        } else {
            client = this.createHttpClient(options2, closeFuture);
        }
        this.resolveCloseFuture().add(closeFuture);
        return client;
    }

    @Override
    public EventBus eventBus() {
        return this.eventBus;
    }

    @Override
    public long setPeriodic(long initialDelay, long delay2, Handler<Long> handler) {
        ContextInternal ctx = this.getOrCreateContext();
        return this.scheduleTimeout(ctx, true, initialDelay, delay2, TimeUnit.MILLISECONDS, ctx.isDeployment(), handler);
    }

    @Override
    public TimeoutStream periodicStream(long initialDelay, long delay2) {
        return new TimeoutStreamImpl(initialDelay, delay2, true);
    }

    @Override
    public long setTimer(long delay2, Handler<Long> handler) {
        ContextInternal ctx = this.getOrCreateContext();
        return this.scheduleTimeout(ctx, false, delay2, TimeUnit.MILLISECONDS, ctx.isDeployment(), handler);
    }

    @Override
    public TimeoutStream timerStream(long delay2) {
        return new TimeoutStreamImpl(delay2, false);
    }

    @Override
    public <T> PromiseInternal<T> promise() {
        ContextInternal context = this.getOrCreateContext();
        return context.promise();
    }

    @Override
    public <T> PromiseInternal<T> promise(Handler<AsyncResult<T>> handler) {
        PromiseInternal<T> promise2;
        if (handler instanceof PromiseInternal && (promise2 = (PromiseInternal<T>)handler).context() != null) {
            return promise2;
        }
        promise2 = this.promise();
        promise2.future().onComplete(handler);
        return promise2;
    }

    @Override
    public void runOnContext(Handler<Void> task) {
        ContextInternal context = this.getOrCreateContext();
        context.runOnContext(task);
    }

    @Override
    public WorkerPool getWorkerPool() {
        return this.workerPool;
    }

    @Override
    public WorkerPool getInternalWorkerPool() {
        return this.internalWorkerPool;
    }

    @Override
    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    @Override
    public EventLoopGroup getAcceptorEventLoopGroup() {
        return this.acceptorEventLoopGroup;
    }

    @Override
    public ContextInternal getOrCreateContext() {
        ContextInternal ctx = this.getContext();
        if (ctx == null) {
            ctx = this.createEventLoopContext();
            this.stickyContext.set(new WeakReference<ContextInternal>(ctx));
        }
        return ctx;
    }

    @Override
    public Map<ServerID, HttpServerImpl> sharedHttpServers() {
        return this.sharedHttpServers;
    }

    @Override
    public Map<ServerID, NetServerImpl> sharedNetServers() {
        return this.sharedNetServers;
    }

    @Override
    public <S extends TCPServerBase> Map<ServerID, S> sharedTCPServers(Class<S> type2) {
        if (NetServerImpl.class.isAssignableFrom(type2)) {
            return this.sharedNetServers;
        }
        if (HttpServerImpl.class.isAssignableFrom(type2)) {
            return this.sharedHttpServers;
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public boolean cancelTimer(long id) {
        InternalTimerHandler handler = (InternalTimerHandler)this.timeouts.get(id);
        if (handler != null) {
            return handler.cancel();
        }
        return false;
    }

    @Override
    public EventLoopContext createEventLoopContext(Deployment deployment, CloseFuture closeFuture, WorkerPool workerPool, ClassLoader tccl) {
        return new EventLoopContext(this, this.eventLoopGroup.next(), this.internalWorkerPool, workerPool != null ? workerPool : this.workerPool, deployment, closeFuture, this.disableTCCL ? null : tccl);
    }

    @Override
    public EventLoopContext createEventLoopContext(EventLoop eventLoop, WorkerPool workerPool, ClassLoader tccl) {
        return new EventLoopContext(this, eventLoop, this.internalWorkerPool, workerPool != null ? workerPool : this.workerPool, null, this.closeFuture, this.disableTCCL ? tccl : null);
    }

    @Override
    public EventLoopContext createEventLoopContext() {
        return this.createEventLoopContext(null, this.closeFuture, null, Thread.currentThread().getContextClassLoader());
    }

    @Override
    public WorkerContext createWorkerContext(Deployment deployment, CloseFuture closeFuture, WorkerPool workerPool, ClassLoader tccl) {
        return new WorkerContext(this, this.internalWorkerPool, workerPool != null ? workerPool : this.workerPool, deployment, closeFuture, this.disableTCCL ? null : tccl);
    }

    @Override
    public WorkerContext createWorkerContext() {
        return this.createWorkerContext(null, this.closeFuture, null, Thread.currentThread().getContextClassLoader());
    }

    @Override
    public DnsClient createDnsClient(int port, String host) {
        return this.createDnsClient(new DnsClientOptions().setHost(host).setPort(port));
    }

    @Override
    public DnsClient createDnsClient() {
        return this.createDnsClient(new DnsClientOptions());
    }

    @Override
    public DnsClient createDnsClient(DnsClientOptions options2) {
        String host = options2.getHost();
        int port = options2.getPort();
        if (host == null || port < 0) {
            DnsResolverProvider provider2 = new DnsResolverProvider(this, this.addressResolverOptions);
            InetSocketAddress address = provider2.nameServerAddresses().get(0);
            options2 = new DnsClientOptions(options2).setHost(address.getAddress().getHostAddress()).setPort(address.getPort());
        }
        return new DnsClientImpl(this, options2);
    }

    private long scheduleTimeout(ContextInternal context, boolean periodic, long initialDelay, long delay2, TimeUnit timeUnit, boolean addCloseHook, Handler<Long> handler) {
        if (delay2 < 1L) {
            throw new IllegalArgumentException("Cannot schedule a timer with delay < 1 ms");
        }
        if (initialDelay < 0L) {
            throw new IllegalArgumentException("Cannot schedule a timer with initialDelay < 0");
        }
        long timerId = this.timeoutCounter.getAndIncrement();
        InternalTimerHandler task = new InternalTimerHandler(timerId, handler, periodic, context);
        this.timeouts.put(timerId, task);
        if (addCloseHook) {
            context.addCloseHook(task);
        }
        EventLoop el = context.nettyEventLoop();
        if (periodic) {
            task.future = el.scheduleAtFixedRate(task, initialDelay, delay2, timeUnit);
        } else {
            task.future = el.schedule(task, delay2, timeUnit);
        }
        return task.id;
    }

    public long scheduleTimeout(ContextInternal context, boolean periodic, long delay2, TimeUnit timeUnit, boolean addCloseHook, Handler<Long> handler) {
        return this.scheduleTimeout(context, periodic, delay2, delay2, timeUnit, addCloseHook, handler);
    }

    @Override
    public ContextInternal getContext() {
        ContextInternal context = ContextInternal.current();
        if (context != null && context.owner() == this) {
            return context;
        }
        WeakReference<ContextInternal> ref2 = this.stickyContext.get();
        return ref2 != null ? (ContextInternal)ref2.get() : null;
    }

    @Override
    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    @Override
    public Future<Void> close() {
        Promise<Void> promise2 = Promise.promise();
        this.close(promise2);
        return promise2.future();
    }

    private void closeClusterManager(Handler<AsyncResult<Void>> completionHandler) {
        PromiseInternal<Void> leavePromise = this.getOrCreateContext().promise();
        if (this.clusterManager != null) {
            this.clusterManager.leave(leavePromise);
        } else {
            leavePromise.complete();
        }
        leavePromise.future().onComplete(ar -> {
            if (ar.failed()) {
                log.error("Failed to leave cluster", ar.cause());
            }
            if (completionHandler != null) {
                completionHandler.handle(Future.succeededFuture());
            }
        });
    }

    @Override
    public synchronized void close(Handler<AsyncResult<Void>> completionHandler) {
        if (this.closed || this.eventBus == null) {
            if (completionHandler != null) {
                completionHandler.handle(Future.succeededFuture());
            }
            return;
        }
        this.closed = true;
        this.closeFuture.close().onComplete(ar -> this.deploymentManager.undeployAll().onComplete(ar1 -> {
            HAManager haManager = this.haManager();
            Promise haPromise = Promise.promise();
            if (haManager != null) {
                this.executeBlocking(fut -> {
                    haManager.stop();
                    fut.complete();
                }, false, haPromise);
            } else {
                haPromise.complete();
            }
            haPromise.future().onComplete(ar2 -> this.addressResolver.close((Void ar3) -> {
                PromiseInternal<Void> ebClose = this.getOrCreateContext().promise();
                this.eventBus.close(ebClose);
                ebClose.future().onComplete(ar4 -> this.closeClusterManager(ar5 -> this.deleteCacheDirAndShutdown(completionHandler)));
            }));
        }));
    }

    @Override
    public Future<String> deployVerticle(String name2, DeploymentOptions options2) {
        if (options2.isHa() && this.haManager() != null) {
            PromiseInternal<String> promise2 = this.getOrCreateContext().promise();
            this.haManager().deployVerticle(name2, options2, promise2);
            return promise2.future();
        }
        return this.verticleManager.deployVerticle(name2, options2).map(Deployment::deploymentID);
    }

    @Override
    public void deployVerticle(String name2, DeploymentOptions options2, Handler<AsyncResult<String>> completionHandler) {
        Future<String> fut = this.deployVerticle(name2, options2);
        if (completionHandler != null) {
            fut.onComplete(completionHandler);
        }
    }

    @Override
    public void deployVerticle(Verticle verticle, Handler<AsyncResult<String>> completionHandler) {
        Future<String> fut = this.deployVerticle(verticle);
        if (completionHandler != null) {
            fut.onComplete(completionHandler);
        }
    }

    @Override
    public Future<String> deployVerticle(Verticle verticle, DeploymentOptions options2) {
        if (options2.getInstances() != 1) {
            throw new IllegalArgumentException("Can't specify > 1 instances for already created verticle");
        }
        return this.deployVerticle(() -> verticle, options2);
    }

    @Override
    public void deployVerticle(Verticle verticle, DeploymentOptions options2, Handler<AsyncResult<String>> completionHandler) {
        Future<String> fut = this.deployVerticle(verticle, options2);
        if (completionHandler != null) {
            fut.onComplete(completionHandler);
        }
    }

    @Override
    public Future<String> deployVerticle(Class<? extends Verticle> verticleClass, DeploymentOptions options2) {
        return this.deployVerticle(verticleClass::newInstance, options2);
    }

    @Override
    public void deployVerticle(Class<? extends Verticle> verticleClass, DeploymentOptions options2, Handler<AsyncResult<String>> completionHandler) {
        Future<String> fut = this.deployVerticle(verticleClass, options2);
        if (completionHandler != null) {
            fut.onComplete(completionHandler);
        }
    }

    @Override
    public Future<String> deployVerticle(Supplier<Verticle> verticleSupplier, DeploymentOptions options2) {
        return this.deployVerticle(verticleSupplier::get, options2);
    }

    @Override
    public void deployVerticle(Supplier<Verticle> verticleSupplier, DeploymentOptions options2, Handler<AsyncResult<String>> completionHandler) {
        Future<String> fut = this.deployVerticle(verticleSupplier, options2);
        if (completionHandler != null) {
            fut.onComplete(completionHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<String> deployVerticle(Callable<Verticle> verticleSupplier, DeploymentOptions options2) {
        boolean closed;
        VertxImpl vertxImpl = this;
        synchronized (vertxImpl) {
            closed = this.closed;
        }
        if (closed) {
            return Future.failedFuture("Vert.x closed");
        }
        return this.deploymentManager.deployVerticle(verticleSupplier, options2);
    }

    @Override
    public Future<Void> undeploy(String deploymentID) {
        HAManager haManager = this.haManager();
        Future<Void> future2 = haManager != null ? this.executeBlocking((Promise<T> fut) -> {
            haManager.removeFromHA(deploymentID);
            fut.complete();
        }, false) : this.getOrCreateContext().succeededFuture();
        return future2.compose(v -> this.deploymentManager.undeployVerticle(deploymentID));
    }

    @Override
    public void undeploy(String deploymentID, Handler<AsyncResult<Void>> completionHandler) {
        Future<Void> fut = this.undeploy(deploymentID);
        if (completionHandler != null) {
            fut.onComplete(completionHandler);
        }
    }

    @Override
    public Set<String> deploymentIDs() {
        return this.deploymentManager.deployments();
    }

    @Override
    public void registerVerticleFactory(VerticleFactory factory) {
        this.verticleManager.registerVerticleFactory(factory);
    }

    @Override
    public void unregisterVerticleFactory(VerticleFactory factory) {
        this.verticleManager.unregisterVerticleFactory(factory);
    }

    @Override
    public Set<VerticleFactory> verticleFactories() {
        return this.verticleManager.verticleFactories();
    }

    @Override
    public boolean isClustered() {
        return this.clusterManager != null;
    }

    @Override
    public EventLoopGroup nettyEventLoopGroup() {
        return this.eventLoopGroup;
    }

    @Override
    public void simulateKill() {
        if (this.haManager() != null) {
            this.haManager().simulateKill();
        }
    }

    @Override
    public Deployment getDeployment(String deploymentID) {
        return this.deploymentManager.getDeployment(deploymentID);
    }

    @Override
    public synchronized void failoverCompleteHandler(FailoverCompleteHandler failoverCompleteHandler) {
        if (this.haManager() != null) {
            this.haManager().setFailoverCompleteHandler(failoverCompleteHandler);
        }
    }

    @Override
    public boolean isKilled() {
        return this.haManager().isKilled();
    }

    @Override
    public void failDuringFailover(boolean fail2) {
        if (this.haManager() != null) {
            this.haManager().failDuringFailover(fail2);
        }
    }

    @Override
    public VertxMetrics metricsSPI() {
        return this.metrics;
    }

    @Override
    public File resolveFile(String fileName) {
        return this.fileResolver.resolveFile(fileName);
    }

    @Override
    public void resolveAddress(String hostname, Handler<AsyncResult<InetAddress>> resultHandler) {
        this.addressResolver.resolveHostname(hostname, resultHandler);
    }

    @Override
    public AddressResolver addressResolver() {
        return this.addressResolver;
    }

    @Override
    public AddressResolverGroup<InetSocketAddress> nettyAddressResolverGroup() {
        return this.addressResolver.nettyAddressResolverGroup();
    }

    @Override
    public FileResolver fileResolver() {
        return this.fileResolver;
    }

    @Override
    public BlockedThreadChecker blockedThreadChecker() {
        return this.checker;
    }

    private void deleteCacheDirAndShutdown(final Handler<AsyncResult<Void>> completionHandler) {
        this.executeBlockingInternal(fut -> {
            try {
                this.fileResolver.close();
                fut.complete();
            }
            catch (IOException e2) {
                fut.tryFail(e2);
            }
        }, ar -> {
            this.workerPool.close();
            this.internalWorkerPool.close();
            new ArrayList<SharedWorkerPool>(this.namedWorkerPools.values()).forEach(WorkerPool::close);
            this.acceptorEventLoopGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS).addListener(new GenericFutureListener(){

                public void operationComplete(io.netty.util.concurrent.Future future2) throws Exception {
                    if (!future2.isSuccess()) {
                        log.warn("Failure in shutting down acceptor event loop group", future2.cause());
                    }
                    VertxImpl.this.eventLoopGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS).addListener(new GenericFutureListener(){

                        public void operationComplete(io.netty.util.concurrent.Future future2) throws Exception {
                            if (!future2.isSuccess()) {
                                log.warn("Failure in shutting down event loop group", future2.cause());
                            }
                            if (VertxImpl.this.metrics != null) {
                                VertxImpl.this.metrics.close();
                            }
                            if (VertxImpl.this.tracer != null) {
                                VertxImpl.this.tracer.close();
                            }
                            VertxImpl.this.checker.close();
                            if (completionHandler != null) {
                                VertxImpl.this.eventLoopThreadFactory.newThread(() -> completionHandler.handle(Future.succeededFuture())).start();
                            }
                        }
                    });
                }
            });
        });
    }

    @Override
    public HAManager haManager() {
        return this.haManager;
    }

    @Override
    public WorkerExecutorImpl createSharedWorkerExecutor(String name2) {
        return this.createSharedWorkerExecutor(name2, this.defaultWorkerPoolSize);
    }

    @Override
    public WorkerExecutorImpl createSharedWorkerExecutor(String name2, int poolSize) {
        return this.createSharedWorkerExecutor(name2, poolSize, this.maxWorkerExecTime);
    }

    @Override
    public synchronized WorkerExecutorImpl createSharedWorkerExecutor(String name2, int poolSize, long maxExecuteTime) {
        return this.createSharedWorkerExecutor(name2, poolSize, maxExecuteTime, this.maxWorkerExecTimeUnit);
    }

    @Override
    public synchronized WorkerExecutorImpl createSharedWorkerExecutor(String name2, int poolSize, long maxExecuteTime, TimeUnit maxExecuteTimeUnit) {
        SharedWorkerPool sharedWorkerPool = this.createSharedWorkerPool(name2, poolSize, maxExecuteTime, maxExecuteTimeUnit);
        CloseFuture parentCf = this.resolveCloseFuture();
        CloseFuture execCf = new CloseFuture();
        parentCf.add(execCf);
        WorkerExecutorImpl namedExec = new WorkerExecutorImpl(this, execCf, sharedWorkerPool);
        execCf.add(namedExec);
        return namedExec;
    }

    @Override
    public synchronized SharedWorkerPool createSharedWorkerPool(String name2, int poolSize, long maxExecuteTime, TimeUnit maxExecuteTimeUnit) {
        if (poolSize < 1) {
            throw new IllegalArgumentException("poolSize must be > 0");
        }
        if (maxExecuteTime < 1L) {
            throw new IllegalArgumentException("maxExecuteTime must be > 0");
        }
        SharedWorkerPool sharedWorkerPool = this.namedWorkerPools.get(name2);
        if (sharedWorkerPool == null) {
            ThreadFactory workerThreadFactory = VertxImpl.createThreadFactory(this.threadFactory, this.checker, this.useDaemonThread, maxExecuteTime, maxExecuteTimeUnit, name2 + "-", true);
            ExecutorService workerExec = this.executorServiceFactory.createExecutor(workerThreadFactory, poolSize, poolSize);
            PoolMetrics<?> workerMetrics = this.metrics != null ? this.metrics.createPoolMetrics("worker", name2, poolSize) : null;
            sharedWorkerPool = new SharedWorkerPool(name2, workerExec, workerMetrics);
            this.namedWorkerPools.put(name2, sharedWorkerPool);
        } else {
            sharedWorkerPool.refCount++;
        }
        return sharedWorkerPool;
    }

    private static ThreadFactory createThreadFactory(VertxThreadFactory threadFactory, BlockedThreadChecker checker2, Boolean useDaemonThread, long maxExecuteTime, TimeUnit maxExecuteTimeUnit, String prefix, boolean worker) {
        AtomicInteger threadCount = new AtomicInteger(0);
        return runnable -> {
            VertxThread thread2 = threadFactory.newVertxThread(runnable, prefix + threadCount.getAndIncrement(), worker, maxExecuteTime, maxExecuteTimeUnit);
            checker2.registerThread(thread2, thread2.info);
            if (useDaemonThread != null && thread2.isDaemon() != useDaemonThread.booleanValue()) {
                thread2.setDaemon(useDaemonThread);
            }
            return thread2;
        };
    }

    @Override
    public Vertx exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public CloseFuture closeFuture() {
        return this.closeFuture;
    }

    @Override
    public VertxTracer tracer() {
        return this.tracer;
    }

    @Override
    public void addCloseHook(Closeable hook) {
        this.closeFuture.add(hook);
    }

    @Override
    public void removeCloseHook(Closeable hook) {
        this.closeFuture.remove(hook);
    }

    private CloseFuture resolveCloseFuture() {
        ContextInternal context = this.getContext();
        return context != null ? context.closeFuture() : this.closeFuture;
    }

    void executeIsolated(Handler<Void> task) {
        if (Thread.currentThread() instanceof VertxThread) {
            ContextInternal prev2 = this.beginDispatch(null);
            try {
                task.handle(null);
            }
            finally {
                this.endDispatch(prev2);
            }
        } else {
            task.handle(null);
        }
    }

    ContextInternal beginDispatch(ContextInternal context) {
        ContextInternal prev2;
        Thread thread2 = Thread.currentThread();
        if (thread2 instanceof VertxThread) {
            VertxThread vertxThread = (VertxThread)thread2;
            prev2 = vertxThread.context;
            if (!ContextBase.DISABLE_TIMINGS) {
                vertxThread.executeStart();
            }
            vertxThread.context = context;
            if (!this.disableTCCL) {
                if (prev2 == null) {
                    vertxThread.topLevelTCCL = Thread.currentThread().getContextClassLoader();
                }
                if (context != null) {
                    thread2.setContextClassLoader(context.classLoader());
                }
            }
        } else {
            prev2 = this.beginDispatch2(thread2, context);
        }
        return prev2;
    }

    private ContextInternal beginDispatch2(Thread thread2, ContextInternal context) {
        ContextInternal prev2;
        ContextDispatch current = nonVertxContextDispatch.get();
        if (current != null) {
            prev2 = current.context;
        } else {
            current = new ContextDispatch();
            nonVertxContextDispatch.set(current);
            prev2 = null;
        }
        current.context = context;
        if (!this.disableTCCL) {
            if (prev2 == null) {
                current.topLevelTCCL = Thread.currentThread().getContextClassLoader();
            }
            thread2.setContextClassLoader(context.classLoader());
        }
        return prev2;
    }

    void endDispatch(ContextInternal prev2) {
        Thread thread2 = Thread.currentThread();
        if (thread2 instanceof VertxThread) {
            VertxThread vertxThread = (VertxThread)thread2;
            vertxThread.context = prev2;
            if (!this.disableTCCL) {
                ClassLoader tccl;
                if (prev2 == null) {
                    tccl = vertxThread.topLevelTCCL;
                    vertxThread.topLevelTCCL = null;
                } else {
                    tccl = prev2.classLoader();
                }
                Thread.currentThread().setContextClassLoader(tccl);
            }
            if (!ContextBase.DISABLE_TIMINGS) {
                vertxThread.executeEnd();
            }
        } else {
            this.endDispatch2(prev2);
        }
    }

    private void endDispatch2(ContextInternal prev2) {
        ClassLoader tccl;
        ContextDispatch current = nonVertxContextDispatch.get();
        if (prev2 != null) {
            current.context = prev2;
            tccl = prev2.classLoader();
        } else {
            nonVertxContextDispatch.remove();
            tccl = current.topLevelTCCL;
        }
        if (!this.disableTCCL) {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    static {
        if (System.getProperty("io.netty.leakDetection.level") == null && System.getProperty("io.netty.leakDetectionLevel") == null) {
            ResourceLeakDetector.setLevel(ResourceLeakDetector.Level.DISABLED);
        }
    }

    static class ContextDispatch {
        ContextInternal context;
        ClassLoader topLevelTCCL;

        ContextDispatch() {
        }
    }

    class SharedWorkerPool
    extends WorkerPool {
        private final String name;
        private int refCount;

        SharedWorkerPool(String name2, ExecutorService workerExec, PoolMetrics workerMetrics) {
            super(workerExec, workerMetrics);
            this.refCount = 1;
            this.name = name2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void close() {
            VertxImpl vertxImpl = VertxImpl.this;
            synchronized (vertxImpl) {
                if (--this.refCount > 0) {
                    return;
                }
                VertxImpl.this.namedWorkerPools.remove(this.name);
            }
            super.close();
        }
    }

    private class TimeoutStreamImpl
    implements TimeoutStream,
    Handler<Long> {
        private final long initialDelay;
        private final long delay;
        private final boolean periodic;
        private Long id;
        private Handler<Long> handler;
        private Handler<Void> endHandler;
        private long demand;

        public TimeoutStreamImpl(long delay2, boolean periodic) {
            this(delay2, delay2, periodic);
        }

        public TimeoutStreamImpl(long initialDelay, long delay2, boolean periodic) {
            this.initialDelay = initialDelay;
            this.delay = delay2;
            this.periodic = periodic;
            this.demand = Long.MAX_VALUE;
        }

        @Override
        public synchronized void handle(Long event) {
            try {
                if (this.demand > 0L) {
                    --this.demand;
                    this.handler.handle(event);
                }
            }
            finally {
                if (!this.periodic && this.endHandler != null) {
                    this.endHandler.handle(null);
                }
            }
        }

        @Override
        public synchronized TimeoutStream fetch(long amount) {
            this.demand += amount;
            if (this.demand < 0L) {
                this.demand = Long.MAX_VALUE;
            }
            return this;
        }

        @Override
        public TimeoutStream exceptionHandler(Handler<Throwable> handler) {
            return this;
        }

        @Override
        public void cancel() {
            if (this.id != null) {
                VertxImpl.this.cancelTimer(this.id);
            }
        }

        @Override
        public synchronized TimeoutStream handler(Handler<Long> handler) {
            if (handler != null) {
                if (this.id != null) {
                    throw new IllegalStateException();
                }
                ContextInternal ctx = VertxImpl.this.getOrCreateContext();
                this.handler = handler;
                this.id = VertxImpl.this.scheduleTimeout(ctx, this.periodic, this.initialDelay, this.delay, TimeUnit.MILLISECONDS, ctx.isDeployment(), this);
            } else {
                this.cancel();
            }
            return this;
        }

        @Override
        public synchronized TimeoutStream pause() {
            this.demand = 0L;
            return this;
        }

        @Override
        public synchronized TimeoutStream resume() {
            this.demand = Long.MAX_VALUE;
            return this;
        }

        @Override
        public synchronized TimeoutStream endHandler(Handler<Void> endHandler) {
            this.endHandler = endHandler;
            return this;
        }
    }

    class InternalTimerHandler
    implements Handler<Void>,
    Closeable,
    Runnable {
        private final Handler<Long> handler;
        private final boolean periodic;
        private final long id;
        private final ContextInternal context;
        private final AtomicBoolean disposed = new AtomicBoolean();
        private volatile java.util.concurrent.Future<?> future;

        InternalTimerHandler(long id, Handler<Long> runnable, boolean periodic, ContextInternal context) {
            this.context = context;
            this.id = id;
            this.handler = runnable;
            this.periodic = periodic;
        }

        @Override
        public void run() {
            this.context.emit(this);
        }

        @Override
        public void handle(Void v) {
            if (this.periodic) {
                if (!this.disposed.get()) {
                    this.handler.handle(this.id);
                }
            } else if (this.disposed.compareAndSet(false, true)) {
                VertxImpl.this.timeouts.remove(this.id);
                try {
                    this.handler.handle(this.id);
                }
                finally {
                    this.context.removeCloseHook(this);
                }
            }
        }

        private boolean cancel() {
            boolean cancelled = this.tryCancel();
            if (cancelled && this.context.isDeployment()) {
                this.context.removeCloseHook(this);
            }
            return cancelled;
        }

        private boolean tryCancel() {
            if (this.disposed.compareAndSet(false, true)) {
                VertxImpl.this.timeouts.remove(this.id);
                this.future.cancel(false);
                return true;
            }
            return false;
        }

        @Override
        public void close(Promise<Void> completion) {
            this.tryCancel();
            completion.complete();
        }
    }
}

