/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SerializableUtils {
    public static byte[] toBytes(Object o) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(o);
            oos.flush();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        return baos.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object fromBytes(byte[] bytes2, ObjectInputStreamFactory factory) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes2);
        try (ObjectInputStream ois = factory.create(bais);){
            Object object = ois.readObject();
            return object;
        }
        catch (IOException | ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
    }

    private SerializableUtils() {
    }

    @FunctionalInterface
    public static interface ObjectInputStreamFactory {
        public ObjectInputStream create(ByteArrayInputStream var1) throws IOException;
    }
}

