/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class IsolatingClassLoader
extends URLClassLoader {
    private volatile boolean closed;
    private List<String> isolatedClasses;

    public IsolatingClassLoader(URL[] urls, ClassLoader parent, List<String> isolatedClasses) {
        super(urls, parent);
        this.isolatedClasses = isolatedClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name2, boolean resolve2) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name2);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name2);
            if (c == null) {
                if (this.isIsolatedClass(name2)) {
                    if (this.isVertxOrSystemClass(name2)) {
                        try {
                            c = this.getParent().loadClass(name2);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (c == null) {
                        try {
                            c = this.findClass(name2);
                        }
                        catch (ClassNotFoundException e2) {
                            c = this.getParent().loadClass(name2);
                        }
                    }
                    if (resolve2) {
                        this.resolveClass(c);
                    }
                } else {
                    c = super.loadClass(name2, resolve2);
                }
            }
            return c;
        }
    }

    private boolean isIsolatedClass(String name2) {
        if (this.isolatedClasses != null) {
            for (String isolated : this.isolatedClasses) {
                if (isolated.endsWith(".*")) {
                    String isolatedPackage = isolated.substring(0, isolated.length() - 1);
                    String paramPackage = name2.substring(0, name2.lastIndexOf(46) + 1);
                    if (!paramPackage.startsWith(isolatedPackage)) continue;
                    return true;
                }
                if (!isolated.equals(name2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public URL getResource(String name2) {
        URL url = this.findResource(name2);
        if (url == null) {
            url = super.getResource(name2);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name2) throws IOException {
        Enumeration<URL> parentResources;
        ArrayList<URL> resources = Collections.list(this.findResources(name2));
        if (this.getParent() != null && (parentResources = this.getParent().getResources(name2)).hasMoreElements()) {
            resources.addAll(Collections.list(parentResources));
        }
        return Collections.enumeration(resources);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        super.close();
    }

    public boolean isClosed() {
        return this.closed;
    }

    private boolean isVertxOrSystemClass(String name2) {
        return name2.startsWith("java.") || name2.startsWith("javax.") || name2.startsWith("sun.*") || name2.startsWith("com.sun.") || name2.startsWith("io.vertx.core") || name2.startsWith("io.netty.") || name2.startsWith("com.fasterxml.jackson");
    }
}

